graph [
    isolateNames "capsule_14_fragmented"
    isolateNames "capsule_15a_fragmented"
    isolateNames "capsule_15b_fragmented"
    isolateNames "capsule_15c_fragmented"
    isolateNames "capsule_15f_fragmented"
  node [
    id 0
    label "49"
    size 1
    centroid "0_0_0"
    maxLenId 0
      members 0
      seqIDs "0_0_0"
    hasEnd 1
    protein "LVAGLTNGELIAPMTYEETMTSDFFEVWFQKFFLPTLTTPSVIIMDNARFHRMGKLELLCEEFGHKLLPLPPYSPEYNPIEKTWAHIKKPRKRYYQVAIPFTRLFYPALISIDCIISVIV"
    dna "TTGGTTGCAGGTCTAACAAATGGTGAGTTAATCGCTCCAATGACTTACGAAGAAACGATGACGAGCGACTTTTTTGAAGTATGGTTTCAGAAGTTTTTCTTACCAACATTAACCACACCATCGGTTATTATTATGGATAATGCAAGATTCCATAGAATGGGGAAGCTAGAACTTTTATGCGAAGAGTTTGGGCATAAACTTTTACCTCTTCCTCCCTACTCACCTGAGTACAATCCTATTGAGAAAACATGGGCTCATATCAAAAAGCCTCGTAAAAGGTATTACCAAGTTGCAATACCTTTTACGAGGCTTTTTTATCCTGCTCTTATTTCAATTGACTGTATTATCAGCGTAATAGTCTAA"
    annotation ""
    description "IS630 family transposase IS630-Spn1"
      lengths 363
      longCentroidID 363
      longCentroidID "0_0_0"
    paralog 0
    mergedDNA 0
    genomeIDs "0"
    geneIDs "0_0_0"
    degrees 0
    name "group_0"
  ]
  node [
    id 1
    label "11"
    size 2
    centroid "0_1_0"
    maxLenId 0
      members 0
      members 2
      seqIDs "0_1_0"
      seqIDs "2_1_0"
    hasEnd 1
    protein "MTVNRDTKKILLTTTPRDAYVPIADGGNNQKDKLTHAGIYGVDSSIHTLENLYGVDINYYVRLNFTSFLKMIDLLGGVDVHNDQEFSALHGKFHFPVGNVHLDSEQALGFVRERYSLADGDRDRGRNQQKVIVAILQKLTSTEALKNYSTIIDSLQDSIQTNMPLETMINLVNAQLESGGNYKVNSQDLKGTGRTDLPSYAMPDSNLYVMEIDDSSLAVVKAAIQDVMEGR"
    dna "ATGACTGTCAATCGAGATACCAAGAAAATCCTCTTGACCACAACGCCACGTGATGCCTATGTACCAATAGCAGATGGTGGAAATAATCAAAAAGATAAATTAACCCATGCGGGCATTTATGGAGTTGATTCGTCCATTCACACCTTAGAAAATCTCTATGGAGTGGATATCAATTACTATGTGCGATTGAACTTCACTTCTTTCTTGAAAATGATTGACTTATTGGGAGGGGTAGATGTTCATAATGATCAAGAGTTTTCAGCTCTACATGGGAAGTTCCATTTCCCAGTAGGGAATGTCCATCTAGACTCTGAGCAGGCTCTAGGTTTTGTACGTGAACGCTACTCACTAGCCGATGGAGACCGTGACCGTGGTCGCAACCAACAAAAGGTGATTGTGGCTATCCTTCAAAAATTAACGTCAACCGAAGCACTGAAAAATTATAGTACGATCATTGATAGCTTGCAAGATTCTATCCAAACAAATATGCCACTTGAGACTATGATAAATTTGGTCAATGCTCAGTTAGAAAGTGGAGGGAATTATAAAGTAAATTCTCAAGATTTAAAAGGTACAGGTCGGACGGATCTTCCTTCTTATGCAATGCCAGACAGTAACCTCTATGTGATGGAAATAGATGATAGTAGTTTAGCTGTAGTTAAAGCAGCTATACAGGATGTGATGGAGGGTAGATGA"
    annotation ""
    description "[gene=wzg] [locus_tag=SPC14_0004] [db_xref=GOA:Q9R928InterPro:IPR004190InterPro:IPR004474UniProtKB/TrEMBL:Q9R928][protein=integral membrane regulatory protein Wzg] [protein_id=CAI33317.1] [location=1200..2645][gbkey=CDS]"
      lengths 696
      lengths 696
      longCentroidID 696
      longCentroidID "0_1_0"
    paralog 0
    mergedDNA 0
    genomeIDs "0;2"
    geneIDs "0_1_0;2_1_0"
    degrees 0
    name "group_1"
  ]
  node [
    id 2
    label "42"
    size 1
    centroid "0_2_0"
    maxLenId 0
      members 0
      seqIDs "0_2_0"
    hasEnd 1
    protein "MHTSYRQIHTGLSNILMLGITPVIAHIERYDALENNEKHVRELIDMGCYTQINSYHVSKPKFFGEKYKFMKKRARYFLERDLVHVVASDMHNLDSRPPYMQQAYDIIAKKYGAKKAKELFVDNPRKIIMDQLI"
    dna "ATGCATACTTCCTATCGTCAGATTCATACGGGATTGAGCAATATTTTGATGTTGGGAATCACGCCAGTAATTGCTCATATTGAACGTTATGATGCTTTAGAGAATAACGAAAAACATGTTCGTGAACTGATTGATATGGGGTGCTATACTCAGATAAATAGTTATCATGTTTCAAAACCTAAGTTCTTTGGTGAAAAATATAAATTCATGAAAAAGAGAGCTCGGTATTTTTTGGAACGTGATTTAGTTCATGTAGTTGCAAGTGACATGCACAATTTAGACAGTAGACCTCCATATATGCAACAGGCATATGATATCATTGCTAAGAAATATGGAGCGAAAAAAGCGAAAGAACTTTTTGTAGATAATCCCAGAAAAATTATAATGGATCAATTAATTTAG"
    annotation ""
    description "[gene=wzh] [locus_tag=SPC14_0005] [db_xref=GOA:Q4K1S9InterPro:IPR004013InterPro:IPR016667UniProtKB/TrEMBL:Q4K1S9][protein=protein-tyrosine phosphatase Wzh] [protein_id=CAI33318.1] [location=2647..3378] [gbkey=CDS]"
      lengths 402
      longCentroidID 402
      longCentroidID "0_2_0"
    paralog 0
    mergedDNA 0
    genomeIDs "0"
    geneIDs "0_2_0"
    degrees 0
    name "group_2"
  ]
  node [
    id 3
    label "43"
    size 1
    centroid "0_3_0"
    maxLenId 0
      members 0
      seqIDs "0_3_0"
    hasEnd 1
    protein "LKLDLTPKGLANKIKVTVPVDTRIVSVSVNDRVPEEASRIANSLREVAAQKIISITRVSDVTTLEEARPAISPSSPNIKRNTLIGFLAGVSGTSVIVFLLEFLNTRVKRPEDIENTLQMTLLGVVPNLSKLK"
    dna "TTGAAACTAGATTTGACGCCAAAAGGTTTGGCTAATAAAATTAAAGTAACAGTACCAGTTGATACCCGTATTGTCTCTGTTTCAGTTAATGATCGAGTTCCTGAAGAGGCAAGCCGTATCGCTAACTCTTTGAGAGAAGTAGCTGCTCAAAAAATTATCAGTATTACTCGTGTTTCTGATGTGACAACACTGGAGGAGGCAAGACCGGCGATATCACCGTCTTCGCCAAATATTAAACGCAATACACTAATTGGTTTTTTGGCAGGGGTGAGTGGAACTAGTGTTATAGTTTTTCTTCTTGAATTTTTGAACACTCGTGTGAAACGTCCGGAAGATATCGAAAATACACTGCAGATGACACTTTTGGGAGTTGTACCAAACTTGAGTAAGTTGAAATAG"
    annotation ""
    description "[gene=wzd] [locus_tag=SPC14_0006] [db_xref=GOA:Q4K1S8InterPro:IPR003856InterPro:IPR005701UniProtKB/TrEMBL:Q4K1S8][protein=capsular polysaccharide biosynthesis protein Wzd] [protein_id=CAI33319.1] [location=3387..4079][gbkey=CDS]"
      lengths 399
      longCentroidID 399
      longCentroidID "0_3_0"
    paralog 0
    mergedDNA 0
    genomeIDs "0"
    geneIDs "0_3_0"
    degrees 0
    name "group_3"
  ]
  node [
    id 4
    label "63"
    size 1
    centroid "0_4_0"
    maxLenId 0
      members 0
      seqIDs "0_4_0"
    hasEnd 1
    protein "MEIMVKNNLGKILWIKKDWKFFWQYYRVLLSFYWFIFLALLERQNLNVLRWLYYTFSTFLYSILVPMVTNFLKEGT"
    dna "ATGGAAATTATGGTAAAAAATAACTTAGGAAAGATTTTATGGATAAAAAAGGATTGGAAATTTTTCTGGCAGTATTACAGAGTATTATTGTCATTTTATTGGTTTATTTTCTTAGCTTTGTTAGAGAGACAGAACTTGAACGTTCTTCGATGGTTATACTATACCTTCTCCACTTTTTTGTATTCTATTTTAGTTCCTATGGTAACAAATTTTTTAAAAGAGGGTACCTAG"
    annotation ""
    description "hypothetical protein"
      lengths 231
      longCentroidID 231
      longCentroidID "0_4_0"
    paralog 0
    mergedDNA 0
    genomeIDs "0"
    geneIDs "0_4_0"
    degrees 0
    name "group_4"
  ]
  node [
    id 5
    label "69"
    size 1
    centroid "0_5_0"
    maxLenId 0
      members 0
      seqIDs "0_5_0"
    hasEnd 1
    protein "MQFVKITKEIYNLIVIDDISDLHLILHNFKDKHFETYLNNERFNVRFNVEISNLFKGNKINEN"
    dna "ATGCAATTTGTAAAAATAACGAAAGAAATATACAATTTAATAGTTATAGATGATATTTCAGACTTACATTTAATTCTTCATAATTTTAAGGACAAACATTTTGAAACTTATTTGAATAACGAGAGATTTAATGTACGTTTCAATGTGGAAATCAGTAACCTTTTTAAAGGAAATAAAATAAATGAAAATTAG"
    annotation ""
    description "[gene=wchK] [locus_tag=SPC14_0010] [db_xref=GOA:Q4K1S4InterPro:IPR007235UniProtKB/TrEMBL:Q4K1S4][protein=putative glycosyl transferase] [protein_id=CAI33323.1][location=6608..7111] [gbkey=CDS]"
      lengths 192
      longCentroidID 192
      longCentroidID "0_5_0"
    paralog 0
    mergedDNA 0
    genomeIDs "0"
    geneIDs "0_5_0"
    degrees 0
    name "group_5"
  ]
  node [
    id 6
    label "2"
    size 1
    centroid "0_6_0"
    maxLenId 0
      members 0
      seqIDs "0_6_0"
    hasEnd 1
    protein "MQLILFFLIALTLLPTYIKEKQVFKIDTPSFCMVLWTIIYSISIIFNSLIDGLAVQVLFSDLSKAFNWLIAVFFYNYYLKMPINIDRIKRYMYYNFTILVVFVGLFYIQRGSNVILFGRSLLDWDGFTLATSYGVRYTGFLEYATLNGQLILFLLPLIRLFRFRFFTQTIIFAFLLEVLVLSKSRIAIVAMLIYIAFAVVNEINSNNKWLIGIFCPIIPFMLFYNFEKIKQIFFQMFSSRSGSNATRFRVYEESLKAINGMEMLLGAGVRIPSTVDILLGSHSMYISFIYRTGVLGSIIITVMFYYLFSKFLKCDSSERLRSIGYILALSVFWLFEELDPHYWCLILFFSTISIFINNRKEEIVG"
    dna "ATGCAATTAATATTATTCTTTTTAATTGCTTTAACTCTTTTACCAACCTATATAAAAGAAAAACAAGTTTTTAAAATAGATACACCGTCTTTTTGTATGGTGCTATGGACTATTATATATTCTATATCTATAATATTTAATTCTCTGATTGATGGATTGGCTGTTCAAGTGTTATTTTCAGATTTGAGTAAAGCATTTAATTGGCTAATAGCAGTATTTTTTTATAATTATTATTTGAAAATGCCAATCAATATTGACAGGATAAAGAGATATATGTATTATAATTTTACTATCTTAGTTGTTTTTGTCGGTTTATTCTATATACAAAGAGGCTCCAATGTAATTTTGTTTGGAAGAAGTTTGTTAGACTGGGACGGATTTACATTAGCTACTAGTTATGGTGTAAGATATACAGGTTTTTTAGAATACGCAACTTTAAATGGTCAGTTAATTCTTTTTTTATTACCGTTAATTAGATTGTTTAGATTTAGATTTTTTACACAAACTATCATTTTTGCTTTTCTTCTAGAGGTTTTGGTACTAAGCAAATCTAGAATAGCGATTGTTGCAATGCTTATATATATAGCATTTGCAGTAGTCAATGAGATTAATTCAAACAATAAATGGCTTATTGGAATTTTCTGTCCAATTATTCCTTTTATGTTATTTTACAATTTTGAAAAAATTAAACAGATTTTTTTTCAAATGTTTAGTTCTAGATCGGGTAGCAATGCGACACGCTTTAGAGTGTATGAGGAATCCCTAAAAGCTATTAATGGAATGGAAATGTTACTTGGCGCAGGTGTCAGAATTCCCTCTACAGTAGATATATTATTGGGGTCACATTCTATGTATATAAGTTTTATTTATAGGACAGGAGTTTTAGGAAGTATAATAATAACAGTAATGTTTTATTATCTGTTTTCTAAATTTTTAAAATGTGATTCATCTGAGAGACTAAGAAGTATTGGCTATATTCTAGCTTTGTCAGTATTTTGGCTTTTTGAAGAGTTAGATCCACATTATTGGTGTTTAATTTTATTTTTTTCAACAATAAGTATTTTCATAAACAATAGAAAAGAGGAAATAGTTGGATGA"
    annotation ""
    description "[gene=wzy] [locus_tag=SPC14_0011] [db_xref=UniProtKB/TrEMBL:P72516] [protein=oligosaccharide repeat unit polymerase Wzy] [protein_id=CAI33324.1] [location=7101..8273][gbkey=CDS]"
      lengths 1098
      longCentroidID 1098
      longCentroidID "0_6_0"
    paralog 0
    mergedDNA 0
    genomeIDs "0"
    geneIDs "0_6_0"
    degrees 0
    name "group_6"
  ]
  node [
    id 7
    label "8"
    size 1
    centroid "0_7_0"
    maxLenId 0
      members 0
      seqIDs "0_7_0"
    hasEnd 1
    protein "MGVSAARNVGLSYASGEYVFFLDSDDILDEGMLSKMYQFAKSNKIDLLSCWHKEPSTTQYGGNDNSSASFIARTKEEIGNHFVDIFPRSACAKLFLRRRIEENNIAFSTEMSLGEDMSFVCQYLMVSRSIAVIDGLYYTIQNVNPQSLSKRYVSNIENSLLMQNQLWDQLLEVYPKIEENYYKQHMDFRFYLASLYVNNLFKFDSPYSSKEKWDNIAQQLKKYRPFLDEKVSKEKKPKNMNEMVIFYLLKSKIPALIYSFYSFKEWWKKKRLKN"
    dna "ATGGGAGTATCTGCTGCCAGAAACGTAGGATTATCGTATGCAAGCGGAGAGTATGTGTTCTTTTTAGATTCAGATGATATATTAGATGAAGGTATGCTATCTAAAATGTATCAGTTTGCAAAAAGTAATAAAATTGATCTTTTATCTTGTTGGCATAAAGAGCCTAGTACAACACAATACGGTGGTAATGATAATAGTTCAGCTTCATTTATTGCACGAACAAAAGAGGAAATAGGAAATCATTTTGTGGATATTTTTCCGAGAAGTGCTTGTGCTAAGTTATTTCTTCGTAGAAGAATTGAGGAAAACAATATTGCTTTTTCGACTGAAATGTCACTAGGAGAAGATATGTCATTCGTTTGCCAATACTTGATGGTCTCAAGGAGTATTGCAGTAATTGATGGACTGTATTATACTATTCAGAATGTTAATCCACAGTCATTATCTAAGCGATATGTAAGTAATATCGAAAACTCCCTATTAATGCAGAATCAGTTATGGGATCAATTATTAGAAGTTTATCCTAAAATTGAGGAGAACTACTACAAGCAACATATGGATTTTAGATTTTATCTTGCTAGTTTATATGTGAATAATTTATTTAAATTTGATTCTCCGTATTCCTCAAAAGAAAAATGGGATAATATTGCACAACAATTAAAAAAATATAGACCATTTTTAGATGAGAAAGTGAGCAAAGAAAAGAAGCCTAAAAATATGAATGAGATGGTCATTTTTTATTTACTGAAGTCTAAAATTCCCGCGTTAATCTATTCTTTTTACTCATTTAAAGAATGGTGGAAGAAAAAGCGATTAAAAAATTGA"
    annotation ""
    description "[gene=wchL] [locus_tag=SPC14_0012] [db_xref=GOA:Q4K1S2InterPro:IPR001173UniProtKB/TrEMBL:Q4K1S2][protein=putative glycosyl transferase] [protein_id=CAI33325.1][location=8270..9289] [gbkey=CDS]"
      lengths 825
      longCentroidID 825
      longCentroidID "0_7_0"
    paralog 0
    mergedDNA 0
    genomeIDs "0"
    geneIDs "0_7_0"
    degrees 0
    name "group_7"
  ]
  node [
    id 8
    label "17"
    size 1
    centroid "0_8_0"
    maxLenId 0
      members 0
      seqIDs "0_8_0"
    hasEnd 1
    protein "MRTHFLGREIIVLTEENISDYIDIPDYITDKYKKGSISRAHYSDILRVELLCRYGGLWVDVTVLNTGGDFSNLELPLFVYKYLDLSRKDSQAIVASSWLISSYSNHPILLYARKLLWEYWRRKNSLCNYFLFHIFFTTATELYPIEWSAVLTFNNHSPHMLNFELNNQFSEKRWEQLKQISVFHKLNHHIDYSIGVNNFYKFIVSSKVEKNE"
    dna "ATGAGAACTCATTTTCTTGGAAGAGAGATTATCGTACTGACAGAAGAAAATATAAGTGACTATATAGATATACCAGATTATATCACTGATAAATATAAAAAGGGTTCGATTTCTCGTGCACATTATTCAGATATCCTTCGGGTAGAACTCTTATGTCGTTATGGAGGATTATGGGTAGATGTAACAGTGTTGAATACAGGAGGAGATTTCTCAAATCTTGAGTTGCCACTTTTTGTATATAAATATTTGGATTTATCAAGAAAAGATTCTCAAGCCATTGTAGCATCAAGTTGGTTAATTTCGTCATATAGTAATCATCCTATATTGCTGTATGCGAGAAAACTACTCTGGGAGTATTGGCGTAGAAAAAATAGTTTATGCAATTATTTTTTATTTCATATATTCTTTACAACAGCTACAGAGCTGTACCCAATCGAATGGTCTGCTGTCCTTACTTTTAACAATCATTCTCCTCATATGCTTAATTTTGAGTTAAATAATCAATTTTCAGAAAAAAGGTGGGAACAGCTAAAACAGATATCGGTGTTTCATAAATTAAATCATCATATAGATTATTCTATCGGTGTTAACAATTTTTATAAGTTTATAGTATCTTCGAAAGTTGAGAAAAATGAGTAA"
    annotation ""
    description "[gene=wchN] [locus_tag=SPC14_0014] [db_xref=GOA:O07341InterPro:IPR008441UniProtKB/TrEMBL:O07341][protein=putative glycosyl transferase] [protein_id=CAI33327.1][location=10348..11196] [gbkey=CDS]"
      lengths 639
      longCentroidID 639
      longCentroidID "0_8_0"
    paralog 0
    mergedDNA 0
    genomeIDs "0"
    geneIDs "0_8_0"
    degrees 0
    name "group_8"
  ]
  node [
    id 9
    label "4"
    size 1
    centroid "0_9_0"
    maxLenId 0
      members 0
      seqIDs "0_9_0"
    hasEnd 1
    protein "LFLIFSFVHESSDLWKYTLINGGVTLVGQLLLWGQLKGRLSWVKIQKKDLLSHIKPILVLFIPVLAISIFSNMDKYMLGLMVGVKQVGFYDNANRIIDIPKALIAALEAVMLPRTSYLLAEGQEEKSNYYIEVTILYAMMISSVLIFGIISVSDIFSLVFWGEEFLESGRLIAAMAPVFVFSVPGNIIRTQYLIPRAKDKDYVLSLIIGALVNILLNCFLIKPFGAMGATISTVLAEFVLYGVQFWTVRRDLDFKKYLKNGFIFYLFGMIMYLAIIAAKAHLQYNIINLVLLIVLGGIVYTGFCCFYILISRNVHFEILREKIKRKIGYENIL"
    dna "TTGTTTTTAATATTTTCGTTTGTACATGAAAGCTCAGATTTATGGAAGTACACCTTAATAAACGGAGGAGTGACTTTAGTTGGGCAACTTTTGTTATGGGGACAATTAAAAGGCAGATTATCTTGGGTGAAGATTCAAAAAAAGGATTTACTATCTCATATCAAACCAATTTTAGTTCTTTTCATTCCTGTGTTAGCAATCAGTATCTTTAGTAATATGGATAAATATATGCTTGGTTTAATGGTTGGTGTTAAGCAAGTTGGATTTTATGATAATGCAAATCGTATTATCGATATTCCTAAAGCATTAATTGCAGCATTAGAGGCTGTTATGTTACCACGAACATCTTATTTATTAGCAGAAGGTCAGGAGGAAAAAAGTAATTACTATATAGAGGTTACAATCCTTTATGCGATGATGATTTCGAGTGTATTGATATTTGGTATAATATCGGTTTCTGATATTTTCTCGCTTGTATTTTGGGGAGAAGAATTCCTTGAATCAGGAAGATTAATTGCTGCTATGGCACCAGTTTTTGTTTTTTCTGTTCCAGGAAATATAATTAGAACACAGTATTTGATTCCTAGAGCAAAGGATAAAGATTATGTGTTGTCTCTAATAATAGGTGCTCTAGTTAATATATTATTGAACTGTTTCTTAATAAAACCTTTTGGAGCCATGGGTGCTACGATTAGTACAGTTTTGGCAGAATTTGTCTTGTATGGAGTGCAATTTTGGACAGTCAGAAGAGATTTAGACTTTAAAAAATATTTAAAGAATGGTTTTATATTTTACCTATTTGGTATGATTATGTATTTAGCTATTATAGCAGCAAAAGCTCATTTGCAATATAATATAATAAATCTTGTTCTCCTTATAGTGCTGGGAGGAATAGTATATACTGGCTTTTGTTGTTTCTACATTTTAATATCAAGAAACGTACATTTTGAGATATTACGGGAAAAAATTAAACGAAAGATTGGTTATGAAAATATATTATAA"
    annotation ""
    description "[gene=wzx] [locus_tag=SPC14_0015] [db_xref=GOA:O07342InterPro:IPR002797UniProtKB/TrEMBL:O07342][protein=flippase Wzx] [protein_id=CAI33328.1] [location=11189..12652][gbkey=CDS]"
      lengths 1002
      longCentroidID 1002
      longCentroidID "0_9_0"
    paralog 0
    mergedDNA 0
    genomeIDs "0"
    geneIDs "0_9_0"
    degrees 0
    name "group_9"
  ]
  node [
    id 10
    label "38"
    size 1
    centroid "0_10_0"
    maxLenId 0
      members 0
      seqIDs "0_10_0"
    hasEnd 1
    protein "MPTFRDDASTKAYNLDYDKVINSFQDFYNRKVKVLIRFHPNVDNTFFNNTDKRLINVTDYPNPQDLMFVADIMISDYSSAPIDFLLLNRVVFLYLPDFKEYQSDKNPFFEVFKVSKTKGIALDPFDEIIGRFQFGVRIV"
    dna "ATGCCTACTTTTAGGGATGATGCTTCAACGAAGGCGTATAATCTTGATTACGATAAGGTAATAAATTCATTTCAAGATTTTTATAACAGAAAAGTTAAAGTATTGATTCGTTTTCATCCAAATGTAGATAATACATTTTTTAATAATACTGATAAAAGATTAATTAATGTGACAGATTATCCTAATCCGCAGGATTTAATGTTTGTGGCTGATATTATGATTTCAGACTATTCGTCAGCACCCATAGATTTTTTGTTATTAAATCGAGTAGTCTTTCTGTATCTACCAGATTTTAAAGAATATCAGAGCGATAAAAATCCGTTTTTTGAAGTTTTCAAAGTTTCGAAAACCAAAGGCATTGCGCTTGATCCGTTTGATGAGATTATTGGTCGCTTCCAGTTTGGCGTTAGAATAGTGTAG"
    annotation ""
    description "[gene=wciY] [locus_tag=SPC14_0016] [db_xref=GOA:O07343InterPro:IPR007554UniProtKB/TrEMBL:O07343][protein=putative glycerol phosphotransferase] [protein_id=CAI33329.1][location=12636..13715] [gbkey=CDS]"
      lengths 420
      longCentroidID 420
      longCentroidID "0_10_0"
    paralog 0
    mergedDNA 0
    genomeIDs "0"
    geneIDs "0_10_0"
    degrees 1
    name "group_10"
  ]
  node [
    id 11
    label "47"
    size 1
    centroid "0_10_1"
    maxLenId 0
      members 0
      seqIDs "0_10_1"
    hasEnd 1
    protein "MCACQIFICVACNLFKCNFYFRFLFFSIGNFKVTISFVYRLTCCKVFMFPIATFFINFFYRIFVNLILIWNFKCSPTLIWLYTFSIPFRFVIFEQLNPDLRLFSSFFYIFPFFSNSNGSWFNFPSNCC"
    dna "ATGTGCGCCTGCCAAATCTTTATTTGTGTCGCCTGCAATCTTTTTAAATGTAACTTTTATTTTAGGTTTCTCTTTTTTAGTATTGGTAATTTCAAAGTGACCATTTCCTTTGTTTACAGGTTGACCTGCTGTAAAGTCTTTATGTTTCCAATCGCGACCTTCTTTATCAACTTCTTTTACAGAATATTTGTTAATCTCATCCTTATTTGGAATTTCAAATGTAGTCCGACCCTTATCTGGCTCTATACGTTTTCGATCCCCTTCAGGTTTGTCATCTTTGAGCAATTGAATCCAGACCTCAGGCTTTTCAGCTCCTTCTTTTACATTTTCCCATTTTTTAGTAACAGTAATGGTAGCTGGTTCAATTTTCCATCTAACTGTTGCTAA"
    annotation ""
    description "hypothetical protein"
      lengths 387
      longCentroidID 387
      longCentroidID "0_10_1"
    paralog 0
    mergedDNA 0
    genomeIDs "0"
    geneIDs "0_10_1"
    degrees 1
    name "group_11"
  ]
  node [
    id 12
    label "18"
    size 1
    centroid "0_11_0"
    maxLenId 0
      members 0
      seqIDs "0_11_0"
    hasEnd 1
    protein "LKLKPGHYIFHEAVAPGGYLAVTDIHFSVDETGQVTVTDVNGNTAVAEGNKLTVTDQTKPVTPPSPEEPGAQEVHFSKVNVGGEEIAGAEIHIKQGDTVVASWVSEAGKTHTLKLKPGHYIFHEAVAPGGYLAVTDIHFSVDETGQVTVTDVNGNTAVAEGNKLTVTDQSADKDKQDKLPNTGETTGTYLSILGMITAVFASLLYRSKKK"
    dna "TTGAAACTAAAACCAGGTCACTATATCTTCCATGAAGCAGTAGCTCCAGGTGGCTATCTAGCAGTAACAGATATTCACTTTAGTGTAGATGAAACTGGTCAAGTGACAGTAACTGATGTAAATGGAAATACAGCTGTAGCGGAAGGCAACAAGCTTACGGTTACAGACCAAACCAAACCAGTAACCCCACCAAGCCCAGAAGAGCCAGGAGCACAAGAAGTTCACTTTAGTAAAGTCAATGTAGGCGGAGAAGAAATTGCAGGTGCGGAAATTCACATCAAGCAAGGCGACACTGTCGTGGCAAGCTGGGTATCAGAAGCCGGTAAGACACATACATTGAAACTAAAACCAGGTCACTATATCTTCCATGAAGCAGTAGCTCCAGGTGGCTATCTAGCAGTAACAGATATTCACTTTAGTGTAGATGAAACTGGTCAAGTGACAGTAACTGATGTAAATGGAAATACAGCTGTAGCGGAAGGCAACAAGCTTACGGTTACAGACCAAAGTGCTGATAAAGATAAGCAAGATAAGTTGCCAAATACAGGAGAAACAACAGGAACTTATTTGTCAATACTTGGTATGATTACTGCAGTTTTTGCAAGCCTATTGTACCGTAGTAAGAAAAAATAG"
    annotation ""
    description "[gene=lrp] [locus_tag=SPC14_0017] [db_xref=GOA:Q4K1R7InterPro:IPR001899InterPro:IPR019931InterPro:IPR019948UniProtKB/TrEMBL:Q4K1R7][protein=putative surface anchored protein] [protein_id=CAI33330.1] [location=14075..18154][gbkey=CDS]"
      lengths 633
      longCentroidID 633
      longCentroidID "0_11_0"
    paralog 0
    mergedDNA 0
    genomeIDs "0"
    geneIDs "0_11_0"
    degrees 1
    name "group_13"
  ]
  node [
    id 13
    label "25"
    size 1
    centroid "0_11_1"
    maxLenId 0
      members 0
      seqIDs "0_11_1"
    hasEnd 0
    protein "MSRVRVQIMNQFHQKSHEYKAIKRYWKLIQQDSRKLSDKRFYRPTFRMHLTNKEILDKLLSYSQDLKHHYQLYQLLLFHFQNKEPEKFFGLIEDNLKQVHPIFQTVFKTFLKDKEKIVNALQLHYSNAKLEATNNLIKLIKRNAFGFRNFENFKKRIFIALNIKKERTKFVLSRA"
    dna "ATGAGTCGTGTGCGTGTTCAAATCATGAATCAGTTTCATCAAAAATCCCATGAATACAAGGCTATCAAGCGCTACTGGAAACTCATTCAACAGGATAGCCGTAAACTGAGTGATAAGCGATTTTATCGTCCTACTTTTCGTATGCATTTAACCAATAAAGAGATTTTAGACAAGCTTTTGAGCTATTCACAAGACTTGAAACATCACTATCAGCTCTATCAGCTCTTGCTTTTTCACTTCCAGAATAAGGAACCAGAGAAATTTTTCGGACTTATCGAGGACAATCTTAAGCAGGTTCATCCTATTTTTCAGACTGTCTTTAAAACCTTTCTAAAGGACAAAGAGAAAATCGTCAACGCCCTTCAACTACACTATTCTAATGCCAAACTGGAAGCGACCAATAATCTCATCAAACTTATCAAGCGCAATGCCTTTGGTTTTCGAAACTTTGAAAACTTCAAAAAACGGATTTTTATCGCTTTGAACATCAAAAAAGAAAGGACAAAATTTGTCCTTTCTCGAGCTTAG"
    annotation ""
    description "ISL3 family transposase ISSpn14"
      lengths 528
      longCentroidID 528
      longCentroidID "0_11_1"
    paralog 0
    mergedDNA 0
    genomeIDs "0"
    geneIDs "0_11_1"
    degrees 2
    name "group_12"
  ]
  node [
    id 14
    label "26"
    size 1
    centroid "0_11_2"
    maxLenId 0
      members 0
      seqIDs "0_11_2"
    hasEnd 1
    protein "MEQLHFITKLLDIKDPNIQILDIVNKDTHKEIIAKLDYEAPSCPECGSQMKKYDFQKPSKIPYLETTGMPTRILLRKRRFKCYHCSKMMVAETSIVKKNHQIPRIINQKIAQKLIEKISMTDIAHQLAISTSTVIRKLNDFHFECNFRNLPKIMSWDVETVRGVTVSIGRWR"
    dna "ATGGAACAATTACATTTTATCACAAAATTACTAGACATTAAAGACCCTAATATCCAGATTTTAGACATTGTCAATAAGGATACACACAAGGAAATCATCGCCAAACTGGACTATGAAGCTCCATCTTGTCCTGAGTGCGGAAGTCAAATGAAGAAATATGACTTTCAAAAACCTTCTAAAATTCCTTATCTTGAAACGACTGGTATGCCTACTAGAATTCTCCTTAGAAAGCGTCGTTTCAAGTGCTATCATTGTTCTAAAATGATGGTCGCTGAAACTTCTATCGTCAAGAAAAATCACCAAATTCCTCGTATTATCAACCAAAAAATTGCGCAAAAGTTGATTGAGAAGATTTCTATGACCGATATTGCTCATCAGCTGGCCATTTCAACTTCAACTGTCATTCGAAAGCTCAATGACTTCCACTTTGAGTGTAATTTTAGAAATCTGCCTAAGATTATGTCTTGGGACGTTGAAACAGTCCGGGGAGTGACTGTTTCAATCGGGAGATGGAGATGA"
    annotation ""
    description "ISL3 family transposase IS1167"
      lengths 519
      longCentroidID 519
      longCentroidID "0_11_2"
    paralog 0
    mergedDNA 0
    genomeIDs "0"
    geneIDs "0_11_2"
    degrees 1
    name "group_14"
  ]
  node [
    id 15
    label "50"
    size 1
    centroid "1_0_0"
    maxLenId 0
      members 1
      seqIDs "1_0_0"
    hasEnd 1
    protein "LVAGLTNGELIAPMTYEETMTSDFFEAWFQKFLLPTLTTPSVIIMDNARFHRMGKLELLCEEFGYKLLPLPPYSPEYNPIEKTWAHIKKPRKRYYQVAIPFMRLFCLVLVSIDYVISVIV"
    dna "TTGGTTGCAGGTCTAACAAATGGTGAGTTAATCGCTCCAATGACTTACGAAGAGACGATGACGAGCGACTTTTTTGAAGCTTGGTTTCAGAAGTTTCTCTTACCAACATTAACCACACCATCGGTTATTATTATGGATAATGCAAGATTCCATAGAATGGGTAAGTTAGAACTCTTGTGTGAAGAGTTTGGGTATAAACTTTTACCTCTTCCTCCCTACTCACCTGAGTACAATCCTATTGAGAAAACATGGGCTCATATCAAAAAGCCTCGTAAAAGGTATTACCAAGTTGCCATACCTTTTATGAGGCTCTTTTGTCTTGTTCTTGTTTCAATTGACTATGTTATCAGCGTAATAGTCTAA"
    annotation ""
    description "hypothetical protein"
      lengths 363
      longCentroidID 363
      longCentroidID "1_0_0"
    paralog 0
    mergedDNA 0
    genomeIDs "1"
    geneIDs "1_0_0"
    degrees 0
    name "group_15"
  ]
  node [
    id 16
    label "66"
    size 1
    centroid "1_1_0"
    maxLenId 0
      members 1
      seqIDs "1_1_0"
    hasEnd 1
    protein "MPIETMIDLVNTQLESGGNYKVNSQDLKGTGRMDLPSYAIPDSNLYVMEIDDSSLAVVKAAIEDVMEGR"
    dna "ATGCCGATTGAGACTATGATAGATTTAGTGAATACTCAGTTGGAAAGTGGGGGGAATTATAAAGTAAATTCTCAAGATTTAAAAGGGACAGGTCGGATGGATCTTCCTTCTTATGCAATACCAGACAGTAACCTCTATGTGATGGAAATAGATGATAGTAGTTTAGCTGTAGTTAAAGCAGCTATAGAGGATGTGATGGAGGGTAGATGA"
    annotation ""
    description "[gene=wzg] [locus_tag=SPC15A_0004] [db_xref=GOA:Q4K1R4InterPro:IPR004190InterPro:IPR004474UniProtKB/TrEMBL:Q4K1R4][protein=integral membrane regulatory protein Wzg] [protein_id=CAI33336.1] [location=1202..2647][gbkey=CDS]"
      lengths 210
      longCentroidID 210
      longCentroidID "1_1_0"
    paralog 0
    mergedDNA 0
    genomeIDs "1"
    geneIDs "1_1_0"
    degrees 0
    name "group_16"
  ]
  node [
    id 17
    label "27"
    size 1
    centroid "1_2_0"
    maxLenId 0
      members 1
      seqIDs "1_2_0"
    hasEnd 1
    protein "LVIAYGAEIYYTPDVLDKLEKKRIPTLNDSRYALIEFSMNTPYRDIHSALSKILMLGITPVIAHIERYDALENNEKRVRELIDMGCYTQVNSSHVLKSKLFGERYKFMKKRAQYFLEQDLVHVIASDMHNLDGRPPHMAEAYDLVTQKYGEAKAQELFVDNPRKIIMDQLI"
    dna "TTGGTCATTGCTTACGGGGCTGAAATTTACTACACACCAGATGTTCTGGATAAGCTAGAAAAAAAGCGGATTCCGACCCTCAATGATAGTCGTTATGCCTTGATAGAGTTTAGTATGAACACTCCTTATCGCGATATTCATAGCGCCTTGAGCAAGATCTTGATGTTGGGAATTACTCCAGTCATTGCCCACATTGAGCGCTATGATGCTCTTGAAAATAATGAAAAACGCGTTCGAGAATTGATCGATATGGGCTGTTACACGCAAGTAAATAGTTCACATGTCCTCAAATCCAAACTTTTTGGCGAACGTTATAAATTCATGAAAAAAAGAGCTCAGTATTTTTTAGAGCAGGATTTGGTCCATGTCATTGCAAGTGATATGCACAATCTAGACGGCAGACCTCCTCATATGGCAGAAGCATATGACCTTGTTACCCAAAAATACGGAGAAGCGAAGGCTCAGGAACTTTTTGTAGATAATCCCAGAAAAATTATAATGGATCAATTAATTTAG"
    annotation ""
    description "[gene=wzh] [locus_tag=SPC15A_0005] [db_xref=GOA:Q4K1R3InterPro:IPR004013InterPro:IPR016667UniProtKB/TrEMBL:Q4K1R3][protein=protein-tyrosine phosphatase Wzh] [protein_id=CAI33337.1] [location=2649..3380] [gbkey=CDS]"
      lengths 516
      longCentroidID 516
      longCentroidID "1_2_0"
    paralog 0
    mergedDNA 0
    genomeIDs "1"
    geneIDs "1_2_0"
    degrees 0
    name "group_17"
  ]
  node [
    id 18
    label "44"
    size 1
    centroid "1_3_0"
    maxLenId 0
      members 1
      seqIDs "1_3_0"
    hasEnd 1
    protein "LKLDLTPKGLANKIKVTVPVDTRIVSISVKDKQPEEASRIANSLREVAAEKIVAVTRVSDVTTLEEARPATTPSSPNVRRNTLFGFLGGAVVTVIAVLLIELLDTRVKRPEDVEDVLQIPLLGLVPDLDKMK"
    dna "TTGAAACTAGATTTGACGCCAAAAGGTTTGGCTAATAAAATTAAAGTGACAGTACCAGTTGATACCCGTATTGTCTCAATCTCTGTCAAGGATAAACAGCCAGAGGAAGCCAGTCGTATCGCTAATTCTCTACGAGAAGTTGCTGCAGAAAAGATCGTCGCTGTAACGCGAGTATCTGATGTAACGACACTTGAAGAAGCGCGACCAGCTACGACTCCCTCTTCTCCAAATGTTCGACGCAACACCTTGTTTGGTTTTCTTGGAGGAGCCGTCGTAACAGTAATTGCTGTTCTTTTGATTGAGTTGCTCGACACCCGTGTGAAACGTCCTGAAGATGTTGAAGATGTACTGCAAATTCCACTTTTAGGGCTCGTTCCAGATTTGGACAAAATGAAATAG"
    annotation ""
    description "[gene=wzd] [locus_tag=SPC15F_0006] [db_xref=GOA:Q4K1K7InterPro:IPR003856InterPro:IPR005701UniProtKB/TrEMBL:Q4K1K7][protein=capsular polysaccharide biosynthesis protein Wzd] [protein_id=CAI33407.1] [location=3740..4432][gbkey=CDS]"
      lengths 399
      longCentroidID 399
      longCentroidID "1_3_0"
    paralog 0
    mergedDNA 0
    genomeIDs "1"
    geneIDs "1_3_0"
    degrees 0
    name "group_18"
  ]
  node [
    id 19
    label "24"
    size 1
    centroid "1_4_0"
    maxLenId 0
      members 1
      seqIDs "1_4_0"
    hasEnd 1
    protein "VKLGEGKSTTSTNIAWAFARAGYKTLLIDGDIRNSVMLGVFKARDKITGLTEFLSGTTDLSQGLCDTNIENLFVIQAGSVSPNPTALLQSKNFSTMLETLRKYFDYIIVDTAPVGVVIDAAIITRKCDASILVTEAGEINRRDIQKAKEQLEHTGKPFLGVVLNKFDTSVDKYGSYGNYGDYGKNKK"
    dna "GTGAAACTAGGAGAAGGAAAATCAACGACTTCCACCAATATCGCTTGGGCTTTTGCGCGTGCAGGTTACAAAACGCTGCTGATTGATGGAGATATTCGCAATTCTGTTATGTTAGGTGTCTTTAAAGCAAGGGATAAGATTACAGGCCTGACAGAATTTTTATCAGGAACTACAGACCTATCACAAGGGCTTTGTGATACCAATATCGAAAATCTCTTTGTAATTCAGGCTGGCTCTGTGTCACCGAATCCGACAGCTCTTCTTCAAAGTAAGAATTTCAGTACAATGCTTGAAACATTGCGTAAATATTTTGACTACATCATTGTAGATACTGCTCCTGTCGGTGTCGTGATTGATGCGGCTATTATTACGCGAAAATGCGATGCTTCTATTTTAGTGACGGAGGCAGGTGAAATAAATCGACGGGATATTCAAAAAGCAAAAGAACAGTTGGAACACACAGGGAAGCCGTTTTTGGGAGTTGTGTTGAATAAATTCGATACTTCAGTAGACAAATACGGTTCTTATGGAAATTATGGAGATTACGGGAAAAATAAAAAATAG"
    annotation ""
    description "[gene=wze] [locus_tag=SPC15F_0007] [db_xref=GOA:Q4K1K6InterPro:IPR002586InterPro:IPR005702UniProtKB/TrEMBL:Q4K1K6][protein=tyrosine-protein kinase Wze][protein_id=CAI33408.1] [location=4442..5131] [gbkey=CDS]"
      lengths 564
      longCentroidID 564
      longCentroidID "1_4_0"
    paralog 0
    mergedDNA 0
    genomeIDs "1"
    geneIDs "1_4_0"
    degrees 0
    name "group_19"
  ]
  node [
    id 20
    label "39"
    size 1
    centroid "1_5_0"
    maxLenId 0
      members 1
      seqIDs "1_5_0"
    hasEnd 1
    protein "MCVDAEAKKRELMEQNTMQGGMFKVDDDPRITKIGRFIRKTSLDELPQFYNVLKGDMSLVGTRPPTVDEYEHYTPEQKRRLSFKPGITGLWQVSGRSEIKNFDEVVKLDVAYIDDWTIWKDIEILLKTVKVVFMRDGAK"
    dna "ATGTGTGTAGATGCCGAGGCGAAAAAAAGAGAACTCATGGAACAAAATACCATGCAGGGTGGAATGTTTAAGGTGGACGATGATCCTCGTATCACGAAAATTGGTCGTTTTATACGGAAGACTAGCTTGGACGAGCTACCACAGTTTTATAATGTTCTAAAGGGAGATATGAGTTTGGTTGGCACACGGCCACCAACAGTGGACGAGTATGAACACTATACCCCAGAACAAAAACGTCGGCTAAGTTTTAAACCTGGTATAACAGGCTTATGGCAGGTCAGTGGACGAAGTGAGATTAAGAATTTTGATGAAGTTGTCAAATTAGATGTAGCCTATATAGACGATTGGACAATTTGGAAAGACATTGAAATTTTATTGAAGACAGTTAAAGTTGTATTTATGAGAGACGGAGCGAAGTAG"
    annotation ""
    description "[gene=wchA] [locus_tag=SPC15F_0008] [db_xref=GOA:Q4K1K5InterPro:IPR003362InterPro:IPR017475UniProtKB/TrEMBL:Q4K1K5][protein=undecaprenylphosphate glucosephosphotransferase WchA (initial sugar transferase)] [protein_id=CAI33409.1][location=5146..6513] [gbkey=CDS]"
      lengths 420
      longCentroidID 420
      longCentroidID "1_5_0"
    paralog 0
    mergedDNA 0
    genomeIDs "1"
    geneIDs "1_5_0"
    degrees 0
    name "group_20"
  ]
  node [
    id 21
    label "65"
    size 2
    centroid "1_6_0"
    maxLenId 0
      members 1
      members 4
      seqIDs "4_5_0"
      seqIDs "1_6_0"
    hasEnd 1
    protein "LIISSGAAIAVPFFYIGKLFGSKTVYIEVFDRIDASTLTGKLVYPVTDRFIVQWEEMKKVYPKAINLGGIF"
    dna "TTGATTATTTCTTCTGGTGCCGCTATCGCTGTTCCTTTCTTTTATATTGGGAAGTTATTTGGATCAAAGACAGTGTATATAGAAGTTTTTGATAGAATTGATGCTTCAACACTGACAGGAAAACTTGTTTATCCAGTAACGGATAGGTTTATTGTTCAATGGGAAGAAATGAAAAAAGTATACCCAAAGGCAATTAATCTCGGAGGGATTTTCTAA"
    annotation ""
    description "[gene=wchJ] [locus_tag=SPC15C_0009] [db_xref=GOA:Q4K1M2InterPro:IPR013969UniProtKB/TrEMBL:Q4K1M2][protein=putative glycosyl transferase enhancer] [protein_id=CAI33387.1][location=6163..6612] [gbkey=CDS]"
      lengths 216
      lengths 216
      longCentroidID 216
      longCentroidID "1_6_0"
    paralog 0
    mergedDNA 0
    genomeIDs "1;4"
    geneIDs "4_5_0;1_6_0"
    degrees 0
    name "group_21"
  ]
  node [
    id 22
    label "67"
    size 1
    centroid "1_7_0"
    maxLenId 0
      members 1
      seqIDs "1_7_0"
    hasEnd 1
    protein "VNDHQLEFVEKVLNVYNLTVITNISDLNSYISNFDERKKSDLKSKNNLFMEKFIDMINQLMETGDIKYD"
    dna "GTGAACGACCATCAACTTGAATTTGTTGAGAAAGTGTTAAATGTCTATAATTTGACAGTCATCACTAACATAAGTGATCTTAATTCCTATATTTCTAATTTTGATGAGCGAAAAAAATCAGATTTGAAGAGCAAAAATAATCTATTTATGGAGAAATTTATAGATATGATTAATCAGTTGATGGAGACAGGTGACATCAAGTATGACTAA"
    annotation ""
    description "[gene=wchK] [locus_tag=SPC15F_0010] [db_xref=GOA:Q4K1K3InterPro:IPR007235UniProtKB/TrEMBL:Q4K1K3][protein=putative glycosyl transferase] [protein_id=CAI33411.1][location=6966..7472] [gbkey=CDS]"
      lengths 210
      longCentroidID 210
      longCentroidID "1_7_0"
    paralog 0
    mergedDNA 0
    genomeIDs "1"
    geneIDs "1_7_0"
    degrees 0
    name "group_22"
  ]
  node [
    id 23
    label "29"
    size 1
    centroid "1_8_0"
    maxLenId 0
      members 1
      seqIDs "1_8_0"
    hasEnd 1
    protein "MSLGEDMSFVYQYLMVSKSIGVIDGVYYNIQNVNPQSLSKRYVQNIENSLMIQNQLWNQLLEVYPKIEENYYKQHMDFRFYLANLYVNNLFKFDSPYSSKEKLDQIAQQLKKYRLFLDEKVSKEKMPKNINEMIVFYLLKLKIPVLIYSFYSFKEWWKRRKIKNEG"
    dna "ATGTCACTAGGTGAAGATATGTCATTTGTGTATCAATACTTAATGGTTTCTAAAAGTATTGGAGTTATTGACGGGGTGTATTATAATATTCAAAATGTAAATCCACAGTCGTTATCTAAGCGCTATGTGCAGAATATTGAAAATTCCCTAATGATTCAGAACCAGTTATGGAATCAACTGTTGGAAGTTTATCCTAAAATTGAGGAGAACTACTATAAGCAACATATGGATTTTAGATTTTACCTTGCTAACTTGTATGTAAATAATTTATTTAAATTTGATTCTCCGTATTCATCAAAAGAAAAACTAGACCAAATTGCTCAACAATTAAAAAAGTATAGATTATTTTTAGATGAAAAAGTCAGCAAAGAAAAGATGCCTAAAAATATAAATGAGATGATTGTTTTTTATTTACTAAAATTGAAAATTCCAGTGTTGATTTATTCTTTTTATTCGTTTAAAGAGTGGTGGAAGAGAAGAAAAATTAAAAATGAAGGATAA"
    annotation ""
    description "[gene=wchL] [locus_tag=SPC15F_0012] [db_xref=GOA:Q4K1K1InterPro:IPR001173UniProtKB/TrEMBL:Q4K1K1][protein=putative glycosyl transferase] [protein_id=CAI33413.1][location=8666..9694] [gbkey=CDS]"
      lengths 501
      longCentroidID 501
      longCentroidID "1_8_0"
    paralog 0
    mergedDNA 0
    genomeIDs "1"
    geneIDs "1_8_0"
    degrees 0
    name "group_23"
  ]
  node [
    id 24
    label "10"
    size 3
    centroid "1_9_0"
    maxLenId 0
      members 1
      members 3
      members 4
      seqIDs "4_8_0"
      seqIDs "3_8_0"
      seqIDs "1_9_0"
    hasEnd 1
    protein "MKGQYVAFIDSDDYISKDYVWKLYSSIKNNDSEVSICSFLLVDEKGEKIKDELLDSGKICLTGQQILEKVLTADGYRYVVAWNKLYRSTLFEKLKFKKGMLYEDEFLNYLLFWDCKRVSIVEEPLYLYVQRKGSIVQSNMTLEKIKMKDEMHTSRIEFYSEKGHSFLHEKACQQYCNWIVTATTNHSKILNPNFSKYLQRQFRKFAKYTRNNDIRLIVQNILGFIDIRLAAYVKSKVM"
    dna "ATGAAAGGTCAATATGTAGCGTTTATTGATAGCGATGACTACATATCTAAGGATTATGTCTGGAAGTTGTATTCTTCTATAAAAAATAATGATTCCGAGGTGTCGATTTGTTCTTTTTTATTAGTCGATGAAAAAGGGGAAAAAATAAAAGATGAGCTATTAGATTCGGGAAAAATATGCTTGACTGGTCAACAAATATTAGAAAAAGTATTAACAGCCGACGGCTATCGCTATGTTGTTGCTTGGAATAAGCTTTATCGGTCAACTTTATTTGAAAAATTAAAATTTAAAAAAGGAATGTTGTATGAGGATGAATTTCTTAACTATCTTCTATTTTGGGACTGTAAAAGGGTATCAATTGTAGAGGAGCCGTTATATTTATACGTTCAACGAAAAGGAAGCATTGTACAAAGTAATATGACTTTAGAAAAAATAAAGATGAAGGATGAGATGCATACTTCACGCATTGAGTTTTATTCAGAAAAGGGGCATTCTTTTTTGCACGAAAAAGCGTGTCAACAGTACTGCAATTGGATTGTTACAGCGACTACCAATCATAGTAAGATTTTAAATCCTAATTTTTCGAAGTATTTACAACGACAGTTTAGAAAGTTCGCTAAATATACACGAAACAATGATATTAGACTAATTGTGCAGAACATTCTAGGATTTATAGATATTCGTTTAGCAGCTTATGTAAAATCAAAAGTAATGTAG"
    annotation ""
    description "[gene=wchM] [locus_tag=SPC15A_0013] [db_xref=GOA:Q4K1Q5InterPro:IPR001173UniProtKB/TrEMBL:Q4K1Q5][protein=putative glycosyl transferase] [protein_id=CAI33345.1][location=9351..10307] [gbkey=CDS]"
      lengths 717
      lengths 717
      lengths 717
      longCentroidID 717
      longCentroidID "1_9_0"
    paralog 0
    mergedDNA 0
    genomeIDs "1;3;4"
    geneIDs "4_8_0;3_8_0;1_9_0"
    degrees 0
    name "group_24"
  ]
  node [
    id 25
    label "23"
    size 1
    centroid "1_10_0"
    maxLenId 0
      members 1
      seqIDs "1_10_0"
    hasEnd 1
    protein "MIISSVLMFGLISVSDIFSIIFWGEEFLESGRLISAMSPAFVFSVLGNIIRTQYLIPRAKDKDYVVSLIAGAVVNLVLNYFFIKPFGAMGATVSTVLAEFVLSGMQFWSVRRDLDLKRYLKNGLIFYLFGLIMYLVIITLKTQLPYNIMSLILLIVLGGIVYVIFCCCYILMSRNLHFKLLKEKIIRKVVHKNTL"
    dna "ATGATTATTTCTAGTGTATTGATGTTTGGGCTAATATCGGTATCTGATATTTTTTCCATTATATTTTGGGGAGAAGAATTTCTTGAATCAGGTAGATTGATTTCTGCTATGTCTCCGGCTTTTGTCTTCTCTGTATTAGGAAATATCATTAGGACTCAGTATTTGATTCCTAGAGCTAAGGATAAAGATTATGTAGTGTCTCTAATTGCGGGGGCTGTTGTTAATCTAGTGCTAAACTATTTTTTTATAAAACCTTTTGGTGCTATGGGAGCAACAGTTAGTACAGTTTTGGCAGAATTTGTATTGTCTGGAATGCAGTTTTGGTCAGTAAGAAGAGACTTAGATTTAAAAAGATATTTGAAAAACGGTTTGATATTCTACCTATTTGGTCTGATTATGTACCTTGTTATTATAACACTCAAAACTCAGTTACCATACAATATAATGAGTCTTATTTTACTAATAGTTTTGGGTGGAATAGTATATGTTATTTTTTGTTGTTGCTATATTTTAATGTCAAGAAATTTACATTTTAAGTTATTGAAGGAAAAGATTATACGAAAGGTTGTACATAAAAATACATTATAA"
    annotation ""
    description "[gene=wzx] [locus_tag=SPC15F_0015] [db_xref=GOA:Q4K1J8InterPro:IPR002797UniProtKB/TrEMBL:Q4K1J8][protein=flippase Wzx] [protein_id=CAI33416.1] [location=11587..13050][gbkey=CDS]"
      lengths 588
      longCentroidID 588
      longCentroidID "1_10_0"
    paralog 0
    mergedDNA 0
    genomeIDs "1"
    geneIDs "1_10_0"
    degrees 1
    name "group_27"
  ]
  node [
    id 26
    label "62"
    size 1
    centroid "1_10_1"
    maxLenId 0
      members 1
      seqIDs "1_10_1"
    hasEnd 0
    protein "MVTKDKGLTYNSTLHAIKVLACFSVVAIHIWLPGKIGAFYQIIARFAVPMFFLISGFYSYNISKNRIKKIFRLILRSTFFM"
    dna "ATGGTTACTAAAGATAAAGGATTAACATATAATAGTACTTTGCATGCAATAAAAGTATTAGCATGTTTTAGTGTTGTTGCTATTCATATATGGCTACCAGGAAAAATTGGAGCGTTTTATCAAATAATAGCACGATTTGCAGTTCCAATGTTCTTTTTGATTTCTGGCTTTTATTCATATAATATTTCAAAGAATAGAATTAAAAAAATATTTAGATTGATATTAAGAAGTACATTTTTTATGTAA"
    annotation ""
    description "[gene=wciZ] [locus_tag=SPC15B_0016] [db_xref=GOA:Q6X851InterPro:IPR002656UniProtKB/TrEMBL:Q6X851][protein=putative acetyl transferase] [protein_id=CAI33371.1][location=13021..13998] [gbkey=CDS]"
      lengths 246
      longCentroidID 246
      longCentroidID "1_10_1"
    paralog 0
    mergedDNA 0
    genomeIDs "1"
    geneIDs "1_10_1"
    degrees 2
    name "group_26"
  ]
  node [
    id 27
    label "30"
    size 1
    centroid "1_10_2"
    maxLenId 0
      members 1
      seqIDs "1_10_2"
    hasEnd 1
    protein "MLLLFSFIMEATISDSIFYRNFLFMGIPFFGIGILIAQNQKKIINCKIINKILILGTIIYPILIFLEYYILGNSFEVYISSVLATIILMIFAIKSPKAINIKILNGIGDKYATFVYIIHQFIIVIFKFLVSNVYILKFGTIFVFLICCFLGVLFQFIKNRLLKRFS"
    dna "ATGCTTTTACTATTTTCTTTCATTATGGAAGCTACAATTAGCGATTCAATTTTTTATAGAAATTTTTTATTTATGGGAATACCATTTTTTGGAATAGGAATTCTTATTGCACAGAATCAAAAGAAGATTATTAATTGTAAAATAATAAACAAAATATTAATCTTGGGAACAATTATCTATCCAATACTAATATTTTTAGAATATTATATCTTGGGTAATTCTTTTGAGGTCTATATAAGTTCTGTGCTAGCAACCATAATATTGATGATTTTCGCGATTAAATCACCTAAAGCGATTAATATCAAAATACTGAATGGAATTGGAGATAAATATGCGACTTTTGTTTACATTATACACCAGTTTATCATTGTGATATTTAAATTTTTAGTATCTAATGTTTATATTCTCAAATTTGGGACGATATTTGTCTTTTTGATATGTTGTTTTCTAGGGGTTCTATTTCAATTTATCAAAAACAGACTATTAAAAAGGTTTAGTTAA"
    annotation ""
    description "[gene=wciZ] [locus_tag=SPC15B_0016] [db_xref=GOA:Q6X851InterPro:IPR002656UniProtKB/TrEMBL:Q6X851][protein=putative acetyl transferase] [protein_id=CAI33371.1][location=13021..13998] [gbkey=CDS]"
      lengths 501
      longCentroidID 501
      longCentroidID "1_10_2"
    paralog 0
    mergedDNA 0
    genomeIDs "1"
    geneIDs "1_10_2"
    degrees 1
    name "group_25"
  ]
  node [
    id 28
    label "53"
    size 1
    centroid "1_11_0"
    maxLenId 0
      members 1
      seqIDs "1_11_0"
    hasEnd 1
    protein "MQELILLADVLLTDYSSAIFDFMLLNKPYVRYVNDLEKYAELRGLSDTYYELPDPIIKTAEELYDLLPKKIENFDYDSIKKYRNEILCPIFNGTASENVGRRIIQEL"
    dna "ATGCAGGAACTTATATTATTGGCAGATGTTTTACTGACAGATTATTCTTCCGCGATATTTGATTTTATGCTTTTAAACAAGCCTTATGTCAGATATGTGAATGATTTAGAAAAATATGCTGAGCTTAGGGGACTATCAGATACATATTACGAATTGCCGGACCCTATCATTAAAACTGCTGAAGAATTGTATGACTTACTGCCTAAAAAAATAGAAAATTTTGATTATGATTCTATAAAAAAATATAGAAATGAAATACTGTGTCCAATCTTTAATGGAACCGCTAGTGAAAATGTAGGAAGGAGAATAATTCAAGAGTTGTGA"
    annotation ""
    description "[gene=wchX] [locus_tag=SPC15A_0017] [db_xref=GOA:Q4K1Q2InterPro:IPR007554UniProtKB/TrEMBL:Q4K1Q2][protein=putative glycerol phosphotransferase] [protein_id=CAI33349.1][location=13893..15041] [gbkey=CDS]"
      lengths 324
      longCentroidID 324
      longCentroidID "1_11_0"
    paralog 0
    mergedDNA 0
    genomeIDs "1"
    geneIDs "1_11_0"
    degrees 0
    name "group_28"
  ]
  node [
    id 29
    label "5"
    size 1
    centroid "1_12_0"
    maxLenId 0
      members 1
      seqIDs "1_12_0"
    hasEnd 1
    protein "LYGSIVRSQIEEIGRVKEESCNYNTIAYAMNIAERAIATDIDCIVGMGGGRVLDVCKYASFISKRPYLSIPTTAANDGIASPVAVLKRQDDRPKSLGAAIPSMTLIDIDVIASGPIQNIKAGIGDTISNYTALKDWELAVERGKDEMHGFAYLMSQNSLDALMKTKYNSITPDFIEVLVNSLVLSGIAMDFAGSSRPVSGSEHLFSHALDYYGSTRNLHGIQVALGTVAVLKLIENSVDAVVDYLQRFEVHINPKLLGIDEELFIYCMQHATKMRSNRYTYLHEVDLSTDRLKQIYKELISEL"
    dna "TTGTACGGTTCGATAGTACGTTCACAAATAGAGGAAATTGGTCGGGTAAAGGAAGAAAGTTGCAATTATAATACTATTGCTTATGCGATGAATATAGCAGAAAGGGCTATTGCCACAGATATTGACTGTATTGTGGGAATGGGAGGAGGTCGTGTTTTAGATGTCTGCAAGTATGCATCTTTTATTTCGAAACGTCCTTACCTATCGATTCCGACAACAGCAGCAAATGATGGCATTGCTTCCCCAGTTGCTGTTTTGAAAAGGCAGGATGATAGACCAAAAAGCTTAGGGGCGGCTATCCCCTCAATGACACTAATTGATATTGATGTTATTGCATCAGGACCTATACAAAACATAAAAGCTGGTATCGGTGATACAATATCCAATTACACTGCATTGAAAGATTGGGAGTTGGCAGTTGAGCGAGGGAAAGATGAGATGCATGGTTTTGCATATCTAATGTCGCAAAATTCTTTAGATGCTTTAATGAAAACGAAGTATAATTCTATTACCCCTGATTTTATTGAAGTTTTGGTAAACTCTTTAGTTTTATCAGGCATTGCAATGGATTTTGCGGGAAGTAGTAGACCTGTCAGTGGGTCAGAGCACTTATTTAGTCATGCATTAGATTACTATGGTTCTACAAGGAATCTTCATGGAATTCAGGTTGCATTAGGTACAGTCGCAGTTTTGAAATTAATTGAAAATTCTGTTGATGCTGTGGTGGATTACTTGCAAAGATTTGAGGTTCATATTAACCCGAAACTTTTGGGGATAGATGAAGAGTTGTTTATTTATTGTATGCAACATGCTACAAAAATGAGAAGTAATCGCTATACTTATCTGCATGAGGTTGATCTTAGTACAGATAGATTGAAACAAATATATAAGGAACTCATAAGCGAGTTGTAG"
    annotation ""
    description "[gene=gtp1] [locus_tag=SPC15A_0018] [db_xref=GOA:Q4K1Q1InterPro:IPR002658InterPro:IPR016205UniProtKB/TrEMBL:Q4K1Q1][protein=putative glycerol-2-phosphate dehydrogenase] [protein_id=CAI33350.1] [location=15077..16105][gbkey=CDS]"
      lengths 912
      longCentroidID 912
      longCentroidID "1_12_0"
    paralog 0
    mergedDNA 0
    genomeIDs "1"
    geneIDs "1_12_0"
    degrees 0
    name "group_29"
  ]
  node [
    id 30
    label "64"
    size 1
    centroid "1_13_0"
    maxLenId 0
      members 1
      seqIDs "1_13_0"
    hasEnd 1
    protein "MNPNDTGQRISGLVAMKGTSFVDRISQVLRILSLVNSVSKPTRTTSISALTCSVTSIPASDSSFIKDFVPWQ"
    dna "ATGAATCCAAACGATACTGGGCAGCGAATATCAGGGTTAGTAGCTATGAAAGGTACGTCCTTTGTTGATAGAATCTCGCAGGTATTGCGAATTTTATCACTGGTTAATTCTGTATCAAAACCAACAAGAACAACATCTATATCAGCACTAACTTGCTCAGTTACATCAATTCCTGCGTCAGATAGTTCTTTTATCAAAGATTTTGTTCCTTGGCAATAA"
    annotation ""
    description "hypothetical protein"
      lengths 219
      longCentroidID 219
      longCentroidID "1_13_0"
    paralog 0
    mergedDNA 0
    genomeIDs "1"
    geneIDs "1_13_0"
    degrees 0
    name "group_30"
  ]
  node [
    id 31
    label "76"
    size 1
    centroid "1_14_0"
    maxLenId 0
      members 1
      seqIDs "1_14_0"
    hasEnd 1
    protein "MTGINAGVTSVCVLTGEATVNDIQQGSIKPTYTFKNVKEMWKGIV"
    dna "ATGACTGGTATAAATGCAGGAGTAACTTCAGTTTGTGTGCTGACAGGAGAAGCAACGGTGAATGATATTCAACAAGGTAGTATAAAACCGACTTATACATTTAAAAACGTGAAAGAAATGTGGAAAGGAATTGTCTGA"
    annotation ""
    description "[gene=gtp3] [locus_tag=SPC15F_0020] [db_xref=GOA:Q4K1N0InterPro:IPR005834InterPro:IPR006357UniProtKB/TrEMBL:Q4K1N0][protein=putative phosphotransferase][protein_id=CAI33421.1] [location=17332..18165] [gbkey=CDS]"
      lengths 138
      longCentroidID 138
      longCentroidID "1_14_0"
    paralog 0
    mergedDNA 0
    genomeIDs "1"
    geneIDs "1_14_0"
    degrees 1
    name "group_31"
  ]
  node [
    id 32
    label "45"
    size 1
    centroid "1_14_1"
    maxLenId 0
      members 1
      seqIDs "1_14_1"
    hasEnd 1
    protein "MKAQTIVTSQGRIISLDITVNYSHDMKLFKMSRRNIGQAGKILADSGYQGLMKIYPQAQTPRKSSELKPLTAEDKACNHALSTERSKVENIFAKVKTFKMFSTTYRNHRKRFGLRMNLIAGIINHELGF"
    dna "ATGAAGGCTCAGACGATTGTCACAAGTCAAGGGAGAATTATTTCTTTGGATATCACTGTGAACTATAGTCATGATATGAAGTTGTTCAAAATGAGTCGCAGAAATATCGGACAAGCTGGTAAAATCTTGGCTGACAGTGGTTATCAAGGGCTTATGAAGATATATCCTCAAGCACAAACTCCACGTAAATCCAGCGAACTCAAGCCGCTAACAGCTGAAGATAAAGCCTGTAACCATGCACTATCTACGGAGAGAAGCAAGGTTGAGAACATCTTTGCCAAAGTAAAAACGTTTAAAATGTTTTCAACAACTTATCGAAATCATCGTAAACGCTTCGGATTACGAATGAATTTGATTGCTGGTATTATCAATCATGAACTAGGATTCTAG"
    annotation ""
    description "IS5 family transposase ISSpn7"
      lengths 390
      longCentroidID 390
      longCentroidID "1_14_1"
    paralog 0
    mergedDNA 0
    genomeIDs "1"
    geneIDs "1_14_1"
    degrees 1
    name "group_32"
  ]
  node [
    id 33
    label "74"
    size 2
    centroid "2_0_0"
    maxLenId 0
      members 2
      members 3
      seqIDs "2_0_0"
      seqIDs "3_refound_0"
    hasEnd 1
    protein "MNIKKRVLSAGLTFASALLLAACDQSGSDTKTYSSTFSGNPTTFNYLLDY;MNIKKRVLSAGLTFASALLLAACDQSGSDTKTYSSTFSGNPTTFNYLLDY*X"
    dna "ATGAACATAAAGAAGCGTGTCCTTAGTGCAGGTCTGACTTTTGCATCTGCTTTGCTTTTAGCTGCTTGCGACCAATCAGGTTCAGATACAAAAACTTACTCATCAACCTTTAGTGGAAATCCAACTACATTTAATTACCTATTAGACTATTAA"
    annotation ""
    description "hypothetical protein"
      lengths 153
      longCentroidID 153
      longCentroidID "2_0_0"
    paralog 0
    mergedDNA 0
    genomeIDs "2;3"
    geneIDs "2_0_0;3_refound_0"
    degrees 1
    name "group_33"
  ]
  node [
    id 34
    label "51"
    size 2
    centroid "2_0_1"
    maxLenId 0
      members 2
      members 3
      seqIDs "2_0_1"
      seqIDs "3_0_0"
    hasEnd 1
    protein "LVAGLTNGELIAPMTYEETMTSDFFEVWFQKFFLPTLTTPSVIIMDNVRFHRMGKLELLCEEFGNKLLPLPPYSPEYNPIEKTWTHIKKHLIKGITKLQYLLQGSFVLFLFRLTILSV"
    dna "TTGGTTGCAGGTCTAACAAATGGTGAGTTAATCGCTCCAATGACTTACGAAGAGACGATGACGAGCGACTTTTTTGAAGTATGGTTTCAGAAGTTTTTCTTACCAACATTAACCACACCATCGGTTATTATTATGGATAATGTAAGATTCCATAGAATGGGGAAGCTAGAACTCTTGTGTGAAGAGTTTGGGAATAAACTTTTACCTCTTCCTCCCTACTCACCTGAGTACAATCCTATTGAGAAAACATGGACTCATATCAAAAAGCACCTCATAAAAGGTATTACCAAGTTGCAATACCTTTTACAAGGCTCTTTTGTCTTGTTCTTGTTTCGATTGACTATATTATCAGTTTAA"
    annotation ""
    description "hypothetical protein"
      lengths 357
      lengths 357
      longCentroidID 357
      longCentroidID "2_0_1"
    paralog 0
    mergedDNA 0
    genomeIDs "2;3"
    geneIDs "2_0_1;3_0_0"
    degrees 1
    name "group_34"
  ]
  node [
    id 35
    label "15"
    size 1
    centroid "2_2_0"
    maxLenId 0
      members 2
      seqIDs "2_2_0"
    hasEnd 1
    protein "LAESYRQGVRIIVSTSHRRKGMFETPEEKIAENFLQVREIAKEVASDLVIAYGAEIYYTPDVLDKLEKKRIPTLNDSRYALIEFSMNTPYRDIHSALSKILMLGITPVIAHIERYDALENNEKRVRELIDMGCYTQVNSSHVLKPKLFGERYKFMKKRAQYFLERDLVHVVASDMHNLDSRPPYMQQAYDIIAKKYGAKKAKEFFVDNPRKIIMDQLI"
    dna "TTGGCAGAATCCTACAGGCAAGGGGTACGAATCATTGTCTCTACCTCTCACCGTCGCAAGGGCATGTTTGAAACTCCGGAAGAGAAGATAGCAGAAAACTTTCTTCAGGTTCGGGAAATAGCTAAGGAAGTGGCGAGTGACTTGGTCATTGCTTACGGAGCTGAAATTTACTACACACCAGATGTTCTGGATAAGCTGGAAAAAAAGCGGATTCCGACCCTCAATGATAGTCGTTATGCCTTGATAGAGTTTAGTATGAACACTCCTTATCGCGATATTCATAGCGCCTTGAGCAAGATCTTGATGTTGGGAATTACTCCAGTCATTGCCCACATTGAGCGCTATGATGCTCTTGAAAATAATGAAAAACGCGTTCGAGAACTGATCGATATGGGCTGTTACACGCAAGTAAATAGTTCACATGTCCTCAAACCCAAACTTTTTGGCGAACGTTATAAATTCATGAAAAAAAGAGCTCAGTATTTTTTGGAACGTGATTTAGTTCATGTAGTTGCAAGTGACATGCACAATTTAGACAGTAGACCTCCATATATGCAACAGGCATATGATATCATTGCTAAGAAATATGGAGCGAAAAAAGCGAAAGAATTTTTTGTAGATAATCCCAGAAAAATTATAATGGATCAATTAATTTAG"
    annotation ""
    description "[gene=wzh] [locus_tag=SPC15B_0005] [db_xref=GOA:Q4K1P5InterPro:IPR004013InterPro:IPR016667UniProtKB/TrEMBL:Q4K1P5][protein=protein-tyrosine phosphatase Wzh] [protein_id=CAI33360.1] [location=2651..3382] [gbkey=CDS]"
      lengths 657
      longCentroidID 657
      longCentroidID "2_2_0"
    paralog 0
    mergedDNA 0
    genomeIDs "2"
    geneIDs "2_2_0"
    degrees 0
    name "group_35"
  ]
  node [
    id 36
    label "21"
    size 1
    centroid "2_3_0"
    maxLenId 0
      members 2
      seqIDs "2_3_0"
    hasEnd 1
    protein "VAIITSSVAFAYSTFVIKPEFTSTTRIYVVNRNQEEKSGLTNQDLQAGTYLVKDYREIILSQDVLEEVISDLKLDLTPKGLANKIKVTVPVDTRIVSVSVNDRVPEEASRIANSLREVAAQKIISITRVSDVTTLEEARPAISPSSPNIKRNILIGFLAGGVGTGVIVLLLELLDTHVKRPEDIEDTLQMTLLGVVPNLSKLK"
    dna "GTGGCAATTATAACTTCTTCAGTTGCTTTTGCCTACAGTACTTTTGTTATCAAACCTGAGTTTACTAGTACGACTCGGATTTATGTAGTTAACCGTAATCAGGAAGAGAAGTCTGGTTTAACCAATCAAGACTTGCAGGCAGGAACTTATCTGGTAAAAGACTACCGTGAGATTATCCTTTCGCAGGATGTTTTGGAGGAAGTTATTTCTGATTTGAAACTAGATTTGACGCCAAAAGGTTTGGCTAATAAAATTAAAGTAACAGTACCAGTTGATACCCGTATTGTCTCTGTTTCAGTTAATGATCGAGTTCCTGAAGAGGCAAGCCGTATCGCTAACTCTTTGAGAGAAGTAGCTGCTCAAAAAATTATCAGTATTACTCGTGTTTCTGATGTGACAACACTGGAGGAGGCAAGACCGGCGATATCACCGTCTTCGCCAAATATTAAACGCAATATACTAATTGGTTTTTTGGCAGGGGGGGTTGGAACTGGTGTTATAGTTCTTCTTCTTGAACTTTTGGACACTCATGTGAAACGTCCGGAAGATATCGAAGATACACTGCAGATGACACTTTTGGGAGTTGTACCAAACTTGAGTAAGTTGAAATAG"
    annotation ""
    description "[gene=wzd] [locus_tag=SPC15C_0006] [db_xref=GOA:Q4K1M5InterPro:IPR003856InterPro:IPR005701UniProtKB/TrEMBL:Q4K1M5][protein=capsular polysaccharide biosynthesis protein Wzd] [protein_id=CAI33384.1] [location=3391..4083][gbkey=CDS]"
      lengths 612
      longCentroidID 612
      longCentroidID "2_3_0"
    paralog 0
    mergedDNA 0
    genomeIDs "2"
    geneIDs "2_3_0"
    degrees 0
    name "group_36"
  ]
  node [
    id 37
    label "59"
    size 1
    centroid "2_4_0"
    maxLenId 0
      members 2
      seqIDs "2_4_0"
    hasEnd 1
    protein "MSLVGTRPPTVDEYDQYTPEQKRRLSFKPGITGLWQVSGRSKITDFDDVVKLDVAYIDNWTIWKDIEILLKTVKVVFIRDGAK"
    dna "ATGAGTTTGGTGGGAACACGTCCACCTACAGTAGACGAGTATGATCAGTATACTCCAGAACAGAAACGTCGACTCAGCTTTAAACCTGGTATTACAGGTTTATGGCAGGTTAGCGGCCGTAGTAAAATAACCGATTTTGACGATGTTGTAAAATTAGATGTGGCTTATATTGATAATTGGACAATCTGGAAAGATATTGAAATTTTGCTTAAAACTGTTAAAGTTGTATTTATAAGAGATGGAGCGAAGTAA"
    annotation ""
    description "[gene=wchA] [locus_tag=SPC15C_0008] [db_xref=GOA:Q4K1M3InterPro:IPR003362InterPro:IPR017475UniProtKB/TrEMBL:Q4K1M3][protein=undecaprenylphosphate glucosephosphotransferase WchA (initial sugar transferase)] [protein_id=CAI33386.1][location=4792..6159] [gbkey=CDS]"
      lengths 252
      longCentroidID 252
      longCentroidID "2_4_0"
    paralog 0
    mergedDNA 0
    genomeIDs "2"
    geneIDs "2_4_0"
    degrees 0
    name "group_37"
  ]
  node [
    id 38
    label "32"
    size 1
    centroid "2_5_0"
    maxLenId 0
      members 2
      seqIDs "2_5_0"
    hasEnd 1
    protein "VTVGTHEQQFDRLIKEVDYLKKENLIQDEVFIQIGYSSYIPKYCEWEKIISYEKMNQLIKESDIIITHGGPATFMGVIAKGKVPIVVPRQKKFGEHVNDHQLQFVKLTKEIYNFIVIDDISDLYLSIRDFKDKYFGICLNNERFNLHFNAEINKLFEGNKVDEN"
    dna "GTGACTGTAGGTACACACGAACAACAATTTGATCGATTGATTAAAGAAGTTGATTATCTAAAAAAAGAAAATCTTATTCAAGATGAAGTATTTATTCAAATAGGATATTCCAGTTATATTCCGAAATATTGTGAGTGGGAAAAGATAATTTCTTATGAAAAAATGAATCAATTGATTAAGGAATCAGATATTATCATTACTCATGGTGGACCAGCGACGTTTATGGGGGTTATTGCTAAAGGAAAAGTTCCGATAGTTGTTCCGAGGCAAAAAAAATTTGGAGAGCATGTGAATGACCATCAGCTTCAATTCGTAAAACTGACGAAAGAAATATACAATTTTATAGTCATAGATGATATTTCCGACTTATATTTAAGTATACGTGATTTTAAGGATAAATATTTTGGAATTTGTTTGAACAATGAAAGATTTAATCTACATTTTAATGCGGAAATTAATAAACTATTTGAAGGAAATAAAGTAGATGAAAATTAG"
    annotation ""
    description "[gene=wchK] [locus_tag=SPC15C_0010] [db_xref=GOA:Q4K1M1InterPro:IPR007235UniProtKB/TrEMBL:Q4K1M1][protein=putative glycosyl transferase] [protein_id=CAI33388.1][location=6612..7115] [gbkey=CDS]"
      lengths 495
      longCentroidID 495
      longCentroidID "2_5_0"
    paralog 0
    mergedDNA 0
    genomeIDs "2"
    geneIDs "2_5_0"
    degrees 0
    name "group_38"
  ]
  node [
    id 39
    label "3"
    size 1
    centroid "2_6_0"
    maxLenId 0
      members 2
      seqIDs "2_6_0"
    hasEnd 1
    protein "MQLILFSLIVLILLPVYIKDRQISKIDAPSFYIVLWVMMYSISIIWNFLISGLPIQVLFSDLSKAFNWILAVFFYNYYLKNPINVDKIKKYMFYNFAILVIIVALFYVQRGANVVLFGRSLLGWDGFVSATSYGVRYAGFLEYSTLNGQLILFLLPLIRLFKLSFFTQVTILAFLLQVLVLSKSRIAIIALIIYIVFVVMVQITSINKRMIVAFYPTIPLILLYNWEKIKHIFFQMFNSRTGSNVTRFIVYEESLKAINGLGILLGAGIRTQSTVGILLGSHSMYISFIYRTGILGSIIIVILFYYLFSKFLKSAPSGKLISIGYILALLVFWLFEELDPHYWCLILFFSTISIFINNRKEEIVG"
    dna "ATGCAATTAATATTATTTTCTTTAATTGTCTTAATTCTATTACCGGTCTATATAAAAGATAGACAAATTTCCAAAATAGATGCACCGTCTTTTTATATAGTTCTATGGGTCATGATGTATTCTATATCAATAATTTGGAATTTTTTAATTAGTGGCTTACCTATTCAAGTGTTGTTTTCAGATTTGAGTAAGGCATTCAATTGGATATTAGCAGTATTTTTTTATAATTATTATTTGAAAAATCCCATTAACGTTGACAAGATAAAGAAATATATGTTTTATAATTTCGCTATATTAGTTATTATTGTTGCTTTATTCTATGTTCAAAGAGGCGCTAATGTAGTATTGTTTGGAAGAAGCTTATTAGGTTGGGACGGATTCGTATCAGCTACCAGTTACGGAGTAAGATATGCAGGATTTTTAGAATATTCAACATTAAATGGGCAGTTGATTCTTTTTTTGTTACCGTTAATTAGGTTATTTAAACTTAGTTTTTTTACACAAGTAACTATTCTTGCTTTTTTGCTACAGGTTTTAGTATTGAGTAAATCTAGAATAGCTATTATTGCTCTGATTATATACATAGTATTTGTAGTAATGGTTCAGATTACTTCAATTAATAAGCGGATGATTGTAGCGTTTTATCCAACTATACCTCTTATATTGCTTTATAATTGGGAAAAAATTAAACATATCTTTTTTCAAATGTTTAATTCAAGAACAGGTAGTAATGTGACACGTTTTATAGTGTACGAAGAATCTCTTAAAGCTATTAATGGGCTGGGAATTTTACTTGGAGCAGGAATCAGAACACAATCTACAGTAGGTATATTATTAGGATCACATTCAATGTATATTAGTTTTATTTATAGGACAGGGATTTTAGGAAGTATAATAATAGTAATACTGTTCTATTATTTGTTTTCTAAATTTTTAAAAAGTGCCCCATCTGGAAAGTTAATCAGTATAGGCTATATTTTAGCTTTATTGGTGTTTTGGCTTTTTGAAGAATTAGATCCACATTATTGGTGTTTAATTTTATTTTTTTCAACAATAAGTATTTTCATAAACAATAGAAAAGAGGAAATAGTTGGATGA"
    annotation ""
    description "[gene=wzy] [locus_tag=SPC15C_0011] [db_xref=UniProtKB/TrEMBL:Q4K1M0] [protein=oligosaccharide repeat unit polymerase Wzy] [protein_id=CAI33389.1] [location=7105..8277][gbkey=CDS]"
      lengths 1098
      longCentroidID 1098
      longCentroidID "2_6_0"
    paralog 0
    mergedDNA 0
    genomeIDs "2"
    geneIDs "2_6_0"
    degrees 0
    name "group_39"
  ]
  node [
    id 40
    label "71"
    size 1
    centroid "2_7_0"
    maxLenId 0
      members 2
      seqIDs "2_7_0"
    hasEnd 1
    protein "MIFPNTEKTKAGDIAEINLPDSRNSSPQNIMEKISDTDISPNINTLEIIITYKIVTSM"
    dna "ATGATATTTCCTAATACAGAGAAGACAAAAGCCGGAGACATAGCAGAAATCAATCTACCTGATTCAAGAAATTCTTCTCCCCAAAATATAATGGAAAAAATATCAGATACCGATATTAGCCCAAACATCAATACACTAGAAATAATCATCACGTATAAAATTGTTACCTCTATGTAG"
    annotation ""
    description "hypothetical protein"
      lengths 177
      longCentroidID 177
      longCentroidID "2_7_0"
    paralog 0
    mergedDNA 0
    genomeIDs "2"
    geneIDs "2_7_0"
    degrees 0
    name "group_40"
  ]
  node [
    id 41
    label "14"
    size 1
    centroid "2_8_0"
    maxLenId 0
      members 2
      seqIDs "2_8_0"
    hasEnd 1
    protein "MQFIFQNFNLTNIIRFVIFNRISDLIGYLATPLWYLFAILYIYIYLYFSNKRLLLTKRWISILLLFSFIMEATISDSIFYRNFLFMGIPFFGIGILIAQKQKKIINCKIINKILILGTIIYPILIFLEYYILGNSFEIYISSVLATIILMIFAIKSPKAINIKILNEIGDKYATFVYIIHQFIIVIFKFLVSNVYILKFGTIFVFLICCFLGVLFQFIKNRLLKRFS"
    dna "ATGCAGTTTATTTTTCAAAACTTTAATTTAACAAATATTATAAGATTTGTGATTTTTAATAGGATTTCAGATTTAATAGGCTATCTAGCAACACCGTTGTGGTATTTATTTGCTATATTATATATATATATATATCTTTATTTTTCCAATAAAAGACTACTATTGACAAAACGATGGATTTCTATACTTTTACTATTTTCTTTCATTATGGAAGCTACAATTAGCGATTCAATTTTTTATAGAAATTTTTTATTTATGGGAATACCATTTTTTGGAATAGGAATTCTTATTGCACAGAAGCAAAAGAAGATTATTAATTGTAAAATAATAAACAAAATATTAATCTTGGGAACAATTATCTATCCAATACTAATATTTTTAGAATATTATATCTTGGGTAATTCTTTTGAGATCTATATAAGTTCTGTGCTAGCAACCATAATATTGATGATTTTCGCGATTAAATCACCTAAAGCGATTAATATAAAAATACTGAATGAAATTGGAGATAAATATGCGACTTTTGTTTACATTATACACCAGTTTATCATTGTGATATTTAAATTTTTAGTATCTAATGTTTATATTCTCAAATTTGGGACGATATTTGTCTTTTTGATATGTTGTTTTCTAGGGGTTCTATTTCAATTTATCAAAAACAGACTATTAAAAAGGTTTAGTTAA"
    annotation ""
    description "[gene=wciZ] [locus_tag=SPC15B_0016] [db_xref=GOA:Q6X851InterPro:IPR002656UniProtKB/TrEMBL:Q6X851][protein=putative acetyl transferase] [protein_id=CAI33371.1][location=13021..13998] [gbkey=CDS]"
      lengths 684
      longCentroidID 684
      longCentroidID "2_8_0"
    paralog 0
    mergedDNA 0
    genomeIDs "2"
    geneIDs "2_8_0"
    degrees 0
    name "group_41"
  ]
  node [
    id 42
    label "58"
    size 1
    centroid "2_9_0"
    maxLenId 0
      members 2
      seqIDs "2_9_0"
    hasEnd 1
    protein "MLLNKPYVRYVNDLEKYAELRGVSDTYYELPDSIIKTAEELYDLLPKKIENFDYDSIKKYRNEILCPIFNGTASENVGRRIIQEL"
    dna "ATGCTTTTAAACAAGCCTTATGTCAGATATGTGAATGATTTAGAAAAATATGCTGAGCTTAGGGGGGTATCAGATACATATTATGAATTGCCGGATTCTATTATTAAAACTGCTGAAGAATTGTATGACTTACTGCCTAAAAAAATAGAAAATTTTGATTATGATTCTATAAAAAAATATAGAAATGAAATACTGTGTCCAATCTTTAATGGAACCGCTAGTGAAAATGTAGGAAGGAGAATAATTCAAGAGTTGTGA"
    annotation ""
    description "[gene=wchX] [locus_tag=SPC15F_0017] [db_xref=GOA:Q4K1J6InterPro:IPR007554UniProtKB/TrEMBL:Q4K1J6][protein=putative glycerol phosphotransferase] [protein_id=CAI33418.1][location=14385..15533] [gbkey=CDS]"
      lengths 258
      longCentroidID 258
      longCentroidID "2_9_0"
    paralog 0
    mergedDNA 0
    genomeIDs "2"
    geneIDs "2_9_0"
    degrees 0
    name "group_42"
  ]
  node [
    id 43
    label "36"
    size 1
    centroid "2_10_0"
    maxLenId 0
      members 2
      seqIDs "2_10_0"
    hasEnd 1
    protein "MKTKYNSITPDFIEVLVNSLVLSGIAMDFAGSSRPVSGSEHLFSHALDYYGSTRNLHGIQVALGTVAVLKLIENSVDTVVDYLQRFEVHINPKLLGIDEELFIYCMQHATKMRSNRYTYLHEVDLSTDRLKQIYKELISEL"
    dna "ATGAAAACGAAGTATAATTCTATTACCCCTGATTTTATTGAAGTTTTGGTAAACTCTTTAGTTTTATCAGGCATTGCAATGGATTTTGCGGGAAGTAGTAGACCTGTCAGTGGGTCAGAGCACTTATTTAGTCATGCATTAGATTACTATGGTTCTACAAGGAATCTTCATGGAATTCAGGTTGCATTAGGTACAGTCGCAGTTTTGAAATTAATTGAAAATTCTGTTGATACTGTAGTGGATTACTTGCAAAGATTTGAGGTTCATATTAACCCGAAACTTTTGGGGATAGATGAAGAGTTGTTTATTTATTGTATGCAACATGCTACAAAAATGAGAAGTAATCGCTATACCTATCTGCATGAAGTTGATCTTAGCACAGATAGATTGAAACAAATATATAAGGAACTCATAAGCGAGTTGTAG"
    annotation ""
    description "[gene=gtp1] [locus_tag=SPC15C_0018] [db_xref=GOA:Q6X849InterPro:IPR002658InterPro:IPR016205UniProtKB/TrEMBL:Q6X849][protein=putative glycerol-2-phosphate dehydrogenase] [protein_id=CAI33396.1] [location=15186..16214][gbkey=CDS]"
      lengths 426
      longCentroidID 426
      longCentroidID "2_10_0"
    paralog 0
    mergedDNA 0
    genomeIDs "2"
    geneIDs "2_10_0"
    degrees 0
    name "group_43"
  ]
  node [
    id 44
    label "54"
    size 1
    centroid "2_11_0"
    maxLenId 0
      members 2
      seqIDs "2_11_0"
    hasEnd 1
    protein "MKVVEKNGRLVEISKQISPEETLGVSIDVYKFSYEAGARFFEKCKEFIEDKRELQMWSEVALNAILSEVEFVACPLEGRWLEIDNHEDLVAAEKLFA"
    dna "ATGAAAGTCGTAGAAAAAAATGGTCGTTTAGTAGAAATTTCTAAACAGATTTCACCTGAGGAAACTTTAGGAGTTTCTATTGATGTTTATAAATTCTCTTATGAAGCAGGTGCTCGATTCTTTGAAAAGTGTAAGGAATTTATTGAAGATAAACGAGAACTTCAAATGTGGAGTGAGGTTGCTCTTAATGCAATTCTTTCTGAAGTTGAATTTGTAGCATGTCCATTAGAGGGTCGTTGGTTAGAAATTGATAATCATGAAGACTTAGTTGCTGCAGAAAAACTATTTGCTTGA"
    annotation ""
    description "[gene=gtp2] [locus_tag=SPC15C_0019] [db_xref=GOA:Q6X848InterPro:IPR005835UniProtKB/TrEMBL:Q6X848][protein=putative nucleotidyl transferase] [protein_id=CAI33397.1][location=16230..16934] [gbkey=CDS]"
      lengths 294
      longCentroidID 294
      longCentroidID "2_11_0"
    paralog 0
    mergedDNA 0
    genomeIDs "2"
    geneIDs "2_11_0"
    degrees 0
    name "group_44"
  ]
  node [
    id 45
    label "31"
    size 2
    centroid "2_12_0"
    maxLenId 0
      members 2
      members 3
      seqIDs "3_13_0"
      seqIDs "2_12_0"
    hasEnd 1
    protein "LIKELSDAGIDVTEQVSADIDVVLVGFDTELTSDKIRNTCEILSTKDVPFIATNPDIRCPVSFGFIPDCGSICDMISKSVDRKPVYIGKPEPTMVDIVRKKLNYSLFETVVIGDRLYTDIMTGINAGVTSVCVLTGEATVNDIQQGSIKPTYTFKNVKEMWKGIV"
    dna "TTGATAAAAGAACTATCTGACGCAGGAATTGATGTAACTGAGCAAGTTAGTGCTGATATAGATGTTGTTCTTGTTGGTTTTGATACAGAATTAACCAGTGATAAAATTCGCAATACCTGCGAGATTCTATCAACAAAGGACGTACCTTTCATAGCTACTAACCCTGATATTCGCTGCCCAGTATCGTTTGGATTCATCCCAGATTGTGGTTCTATTTGTGATATGATTAGTAAATCAGTCGATAGGAAACCTGTTTACATAGGTAAACCTGAACCTACGATGGTTGATATTGTTCGAAAAAAATTAAATTATTCTCTATTTGAAACAGTTGTGATTGGAGATCGCTTGTATACGGATATCATGACTGGTATAAATGCAGGAGTAACTTCAGTTTGTGTGCTGACAGGAGAAGCAACGGTGAATGATATTCAACAAGGTAGTATAAAACCGACTTATACATTTAAAAACGTGAAAGAAATGTGGAAAGGAATTGTCTGA"
    annotation ""
    description "[gene=gtp3] [locus_tag=SPC15F_0020] [db_xref=GOA:Q4K1N0InterPro:IPR005834InterPro:IPR006357UniProtKB/TrEMBL:Q4K1N0][protein=putative phosphotransferase][protein_id=CAI33421.1] [location=17332..18165] [gbkey=CDS]"
      lengths 498
      lengths 498
      longCentroidID 498
      longCentroidID "2_12_0"
    paralog 0
    mergedDNA 0
    genomeIDs "2;3"
    geneIDs "3_13_0;2_12_0"
    degrees 1
    name "group_46"
  ]
  node [
    id 46
    label "46"
    size 2
    centroid "2_12_1"
    maxLenId 0
      members 2
      members 3
      seqIDs "3_13_1"
      seqIDs "2_12_1"
    hasEnd 1
    protein "MKAQAIVTSQGRIVSLDITVNYCHDMKLFKMSRRNIGQAGKILADSGYQGLMKIYPQAQTPRKSSKLKPLTVEDKAYNHALSKERSKVENIFAKVKTFKMFSTTYRNHRKRFGLRMNLIAAIINHELGF"
    dna "ATGAAGGCTCAGGCGATTGTCACAAGTCAAGGGAGAATTGTTTCTTTGGATATCACTGTGAACTATTGTCATGATATGAAGTTGTTCAAAATGAGTCGCAGAAATATCGGACAAGCTGGTAAAATCTTGGCTGACAGTGGTTATCAAGGGCTCATGAAGATATATCCTCAAGCACAAACTCCACGTAAATCCAGCAAACTCAAGCCGCTAACAGTTGAAGATAAAGCCTATAACCATGCGCTATCCAAGGAGAGAAGCAAGGTCGAGAACATCTTTGCCAAAGTAAAAACGTTTAAAATGTTTTCAACAACCTATCGAAATCATCGTAAACGCTTCGGATTACGAATGAATTTGATTGCTGCTATTATCAATCATGAACTAGGATTCTAG"
    annotation ""
    description "IS5 family transposase ISSpn7"
      lengths 390
      lengths 390
      longCentroidID 390
      longCentroidID "2_12_1"
    paralog 0
    mergedDNA 0
    genomeIDs "2;3"
    geneIDs "3_13_1;2_12_1"
    degrees 1
    name "group_45"
  ]
  node [
    id 47
    label "1"
    size 1
    centroid "3_1_0"
    maxLenId 0
      members 3
      seqIDs "3_1_0"
    hasEnd 1
    protein "VVTALVLLVALVGLLLIIYKKAEKFTIFLLVFSILVSSVSLFAVQQFVGLTNRLNATSNYSEYSISVAVLADSDIENVTQLTSVTAPTGTDNENIQKLLADIKSSQNTDLTVDQSSSYLAAYKSLIAGETKAIVLNSVFENIIESEYPDYASKIKKIYTKGFTKKVEAPKTSKNQSFNIYVSGIDTYGPISSVSRSDVNILMTVNRDTKKILLTTTPRDAYVPIADGGNNQKDKLTHAGIYGVDSSIHTLENLYGVDINYYVRLNFTSFLKMIDLLGGVDVHNDQEFSALHGKFHFPVGNVHLDSEQALGFVRERYSLADGDRDRGRNQQKVIVAILQKLTSTEALKNYSTIINSLQDSIQTNMPLETMINLVNAQLESGGNYKVNSQDLKGTGRTDLPSYAMPDSNLYVLEIDDSSLAVVKAAIQDVMEGR"
    dna "GTGGTAACTGCGTTAGTCCTACTAGTTGCCTTGGTAGGGCTACTCCTGATTATCTATAAAAAAGCTGAAAAATTTACTATTTTTCTGTTGGTGTTCTCTATCCTTGTCAGCTCTGTGTCGCTCTTTGCAGTACAGCAGTTTGTTGGACTGACCAATCGTTTAAATGCGACTTCTAATTACTCAGAATATTCAATCAGTGTCGCTGTTTTAGCAGATAGTGATATCGAAAATGTTACGCAACTGACGAGTGTGACAGCACCGACTGGGACTGATAATGAAAATATTCAAAAACTACTAGCTGATATTAAGTCAAGTCAGAATACCGATTTGACGGTCGACCAGAGTTCGTCTTACTTGGCAGCTTACAAGAGTTTGATTGCAGGGGAGACTAAGGCCATTGTCTTAAATAGTGTCTTTGAAAATATCATTGAGTCAGAGTATCCAGACTACGCATCGAAGATAAAAAAGATTTATACCAAGGGATTCACTAAAAAAGTAGAAGCTCCTAAGACGTCTAAGAATCAGTCTTTCAATATCTATGTTAGTGGAATTGACACCTATGGTCCTATTAGTTCGGTGTCGCGATCAGATGTCAATATCCTGATGACTGTCAATCGAGATACCAAGAAAATCCTCTTGACCACAACACCACGTGATGCCTATGTACCAATAGCAGATGGTGGAAATAATCAAAAAGATAAATTAACCCATGCGGGCATTTATGGAGTTGATTCGTCCATTCACACCTTAGAAAATCTCTATGGAGTGGATATCAATTACTATGTGCGATTGAACTTCACTTCTTTCTTGAAAATGATTGACTTATTGGGAGGGGTAGATGTTCATAATGATCAAGAGTTTTCAGCTCTACATGGGAAGTTCCATTTCCCAGTAGGGAATGTCCATCTAGACTCTGAGCAGGCTCTAGGTTTTGTACGTGAACGCTACTCACTAGCCGATGGAGACCGTGACCGTGGTCGCAACCAACAAAAGGTGATTGTGGCTATCCTTCAAAAATTAACGTCAACCGAAGCACTGAAAAATTATAGTACGATCATTAATAGCTTGCAAGATTCTATCCAAACAAATATGCCACTTGAGACTATGATAAATTTGGTCAATGCTCAGTTAGAAAGTGGAGGGAATTATAAAGTAAATTCTCAAGATTTAAAAGGGACAGGTCGGACGGATCTTCCTTCTTATGCAATGCCAGACAGTAACCTCTATGTGTTGGAAATAGATGATAGTAGTTTAGCTGTAGTTAAAGCAGCTATACAGGATGTGATGGAGGGTAGATGA"
    annotation ""
    description "[gene=wzg] [locus_tag=SPC15C_0004] [db_xref=GOA:Q4K1M7InterPro:IPR004190InterPro:IPR004474UniProtKB/TrEMBL:Q4K1M7][protein=integral membrane regulatory protein Wzg] [protein_id=CAI33382.1] [location=1204..2649][gbkey=CDS]"
      lengths 1299
      longCentroidID 1299
      longCentroidID "3_1_0"
    paralog 0
    mergedDNA 0
    genomeIDs "3"
    geneIDs "3_1_0"
    degrees 0
    name "group_47"
  ]
  node [
    id 48
    label "68"
    size 1
    centroid "3_2_0"
    maxLenId 0
      members 3
      seqIDs "3_2_0"
    hasEnd 1
    protein "MKKRAQYFLERDLVHVVASDMHNLDSRPPYMQQAYDIIAKKYGAKKAKEFFVDNPRKIIMDQLI"
    dna "ATGAAAAAAAGAGCTCAGTATTTTTTGGAACGTGATTTAGTTCATGTAGTTGCAAGTGACATGCACAATTTAGACAGTAGACCTCCATATATGCAACAGGCATATGATATCATTGCTAAGAAATATGGAGCGAAAAAAGCGAAAGAATTTTTTGTAGATAATCCCAGAAAAATTATAATGGATCAATTAATTTAG"
    annotation ""
    description "[gene=wzh] [locus_tag=SPC15B_0005] [db_xref=GOA:Q4K1P5InterPro:IPR004013InterPro:IPR016667UniProtKB/TrEMBL:Q4K1P5][protein=protein-tyrosine phosphatase Wzh] [protein_id=CAI33360.1] [location=2651..3382] [gbkey=CDS]"
      lengths 195
      longCentroidID 195
      longCentroidID "3_2_0"
    paralog 0
    mergedDNA 0
    genomeIDs "3"
    geneIDs "3_2_0"
    degrees 0
    name "group_48"
  ]
  node [
    id 49
    label "48"
    size 1
    centroid "3_3_0"
    maxLenId 0
      members 3
      seqIDs "3_3_0"
    hasEnd 1
    protein "LANKIKVTVPVDTRIVSVSVNDRVPEEASRIANSLREVAAQKIISITRVSDVTTLEEARPAISPSSPNIKRNILIGFLAGGVGTGVIVLLLELLDTHVKRPEDIEDTLQMTLLGVVPNLSKLK"
    dna "TTGGCTAATAAAATTAAAGTAACAGTACCAGTTGATACCCGTATTGTCTCTGTTTCAGTTAATGATCGAGTTCCTGAAGAGGCAAGCCGTATCGCTAACTCTTTGAGAGAAGTAGCTGCTCAAAAAATTATCAGTATTACTCGTGTTTCTGATGTGACAACACTGGAGGAGGCAAGACCGGCGATATCACCGTCTTCGCCAAATATTAAACGCAATATACTAATTGGTTTTTTGGCAGGGGGGGTTGGAACTGGTGTTATAGTTCTTCTTCTTGAACTTTTGGACACTCATGTGAAACGTCCGGAAGATATCGAAGATACACTGCAGATGACACTTTTGGGAGTTGTACCAAACTTGAGTAAGTTGAAATAG"
    annotation ""
    description "[gene=wzd] [locus_tag=SPC15C_0006] [db_xref=GOA:Q4K1M5InterPro:IPR003856InterPro:IPR005701UniProtKB/TrEMBL:Q4K1M5][protein=capsular polysaccharide biosynthesis protein Wzd] [protein_id=CAI33384.1] [location=3391..4083][gbkey=CDS]"
      lengths 372
      longCentroidID 372
      longCentroidID "3_3_0"
    paralog 0
    mergedDNA 0
    genomeIDs "3"
    geneIDs "3_3_0"
    degrees 0
    name "group_49"
  ]
  node [
    id 50
    label "20"
    size 1
    centroid "3_4_0"
    maxLenId 0
      members 3
      seqIDs "3_4_0"
    hasEnd 1
    protein "LCTNIQLSGDKLKVISVTSVNPGEGKTTTSVNIARSFARAGYKTLLIDGDTRNSVMSGFFKSREKITGLTEFLSGTADLSHGLCDTNIENLFVVQSGSVSPNPTALLQSKNFNDMIETLRKYFDYIIVDTAPIGIVIDAAIITQKCDASILVTATGEVNKRDVQKAKQQLEQTGKLFLGVILNKFDVQHKKYGSYGDYGNYGKK"
    dna "TTGTGTACAAATATACAGTTGAGCGGAGATAAACTAAAAGTAATTTCCGTTACTTCTGTTAACCCTGGGGAAGGAAAAACAACTACTTCCGTAAATATAGCAAGGTCGTTTGCGCGTGCAGGCTATAAAACTCTTTTGATCGATGGCGATACTCGAAATTCAGTTATGTCAGGATTTTTTAAATCTCGTGAAAAAATTACAGGGCTAACAGAATTTTTATCTGGGACAGCTGATTTATCTCACGGTTTATGTGATACAAATATTGAAAATTTATTTGTAGTTCAATCGGGGTCTGTATCACCAAACCCTACAGCCTTGTTACAAAGTAAAAATTTTAATGATATGATTGAAACATTGCGTAAATATTTTGATTATATCATTGTTGATACAGCACCTATTGGAATTGTTATTGATGCGGCAATTATCACTCAAAAGTGTGATGCGTCCATCTTGGTAACAGCAACAGGTGAGGTGAATAAACGTGATGTCCAAAAAGCGAAACAACAATTAGAACAAACAGGGAAACTGTTTTTAGGTGTCATTCTCAATAAATTTGATGTTCAACATAAAAAATATGGTTCTTACGGTGACTATGGTAATTATGGTAAAAAATAA"
    annotation ""
    description "[gene=wze] [locus_tag=SPC15C_0007] [db_xref=GOA:Q4K1M4InterPro:IPR002586InterPro:IPR005702UniProtKB/TrEMBL:Q4K1M4][protein=tyrosine-protein kinase Wze][protein_id=CAI33385.1] [location=4093..4776] [gbkey=CDS]"
      lengths 615
      longCentroidID 615
      longCentroidID "3_4_0"
    paralog 0
    mergedDNA 0
    genomeIDs "3"
    geneIDs "3_4_0"
    degrees 0
    name "group_50"
  ]
  node [
    id 51
    label "28"
    size 1
    centroid "3_5_0"
    maxLenId 0
      members 3
      seqIDs "3_5_0"
    hasEnd 1
    protein "LIRKDGGPAIFAQTRIGKNGRHFTFYKFRSMRIDAEAIKEQLMDQNTMQGGMFKMDNDPRVTKIGRFIRKTSLDELPQFWNVFIGDMSLVGTRPPTVDEYDQYTPEQKRRLSFKPGITGLWQVSGRSKITDFDDVVKLDVAYIDNWTIWKDIEILLKTVKVVFIRDGAK"
    dna "TTGATTCGTAAAGATGGCGGACCAGCTATTTTTGCTCAAACTCGTATAGGGAAAAATGGTCGACATTTTACCTTTTATAAATTCCGTTCGATGAGGATCGATGCTGAAGCTATCAAAGAACAGTTGATGGATCAAAATACGATGCAAGGTGGTATGTTTAAGATGGACAATGATCCTCGTGTTACAAAAATTGGTCGCTTTATTCGTAAAACCAGTTTGGATGAATTGCCGCAGTTTTGGAATGTCTTTATAGGAGATATGAGTTTGGTGGGAACACGTCCACCTACAGTAGACGAGTATGATCAGTATACTCCAGAACAGAAACGTCGACTCAGCTTTAAACCTGGTATTACAGGTTTATGGCAGGTTAGCGGCCGTAGTAAAATAACCGATTTTGACGATGTTGTAAAATTAGATGTGGCTTATATTGATAATTGGACAATCTGGAAAGATATTGAAATTTTGCTTAAAACTGTTAAAGTTGTATTTATAAGAGATGGAGCGAAGTAA"
    annotation ""
    description "[gene=wchA] [locus_tag=SPC15C_0008] [db_xref=GOA:Q4K1M3InterPro:IPR003362InterPro:IPR017475UniProtKB/TrEMBL:Q4K1M3][protein=undecaprenylphosphate glucosephosphotransferase WchA (initial sugar transferase)] [protein_id=CAI33386.1][location=4792..6159] [gbkey=CDS]"
      lengths 510
      longCentroidID 510
      longCentroidID "3_5_0"
    paralog 0
    mergedDNA 0
    genomeIDs "3"
    geneIDs "3_5_0"
    degrees 0
    name "group_51"
  ]
  node [
    id 52
    label "41"
    size 1
    centroid "3_6_0"
    maxLenId 0
      members 3
      seqIDs "3_6_0"
    hasEnd 1
    protein "LYLLKPFWNDKERFWVTFDKADARSVLSEEVVYPCYYPTNRNIKNLIKNTFLAYKILKKERPDLIISSGAAIAVPFFYIGKLFGSKTVYIEVFDRIDASTLTGKLVYPVTDRFIVQWEEMKKVYPKAINLGGIF"
    dna "TTGTATTTATTAAAACCTTTCTGGAATGATAAAGAAAGATTTTGGGTTACTTTTGATAAGGCGGACGCTCGGAGTGTACTCTCTGAGGAAGTTGTATATCCCTGTTATTATCCAACCAATCGTAATATAAAAAATTTAATAAAAAATACTTTTCTCGCCTATAAAATTTTAAAAAAAGAGAGACCAGATTTGATTATTTCTTCTGGTGCCGCTATCGCTGTTCCTTTCTTTTATATTGGGAAGTTATTTGGATCAAAGACAGTGTATATAGAAGTGTTTGATAGAATTGATGCTTCAACACTGACAGGAAAACTTGTTTATCCAGTAACGGATAGGTTTATTGTACAATGGGAAGAAATGAAAAAAGTATACCCAAAAGCAATTAACCTAGGAGGGATATTCTAA"
    annotation ""
    description "[gene=wchJ] [locus_tag=SPC15C_0009] [db_xref=GOA:Q4K1M2InterPro:IPR013969UniProtKB/TrEMBL:Q4K1M2][protein=putative glycosyl transferase enhancer] [protein_id=CAI33387.1][location=6163..6612] [gbkey=CDS]"
      lengths 405
      longCentroidID 405
      longCentroidID "3_6_0"
    paralog 0
    mergedDNA 0
    genomeIDs "3"
    geneIDs "3_6_0"
    degrees 0
    name "group_52"
  ]
  node [
    id 53
    label "57"
    size 1
    centroid "3_7_0"
    maxLenId 0
      members 3
      seqIDs "3_7_0"
    hasEnd 1
    protein "MGVIAKGKVPIVVPRQKKFGEHVNDHQLQFVKLTKEIYNFIVIDDISDLYLSIRDFKDKYFGICLNNERFNLHFNAEINKLFEGNKVDEN"
    dna "ATGGGGGTTATTGCTAAAGGAAAAGTTCCGATAGTTGTTCCGAGGCAAAAAAAATTTGGAGAGCATGTGAATGACCATCAGCTTCAATTCGTAAAACTGACGAAAGAAATATACAATTTTATAGTCATAGATGATATTTCCGACTTATATTTAAGTATACGTGATTTTAAGGATAAATATTTTGGAATTTGTTTGAACAATGAAAGATTTAATCTACATTTTAATGCGGAAATTAATAAACTATTTGAAGGAAATAAAGTAGATGAAAATTAG"
    annotation ""
    description "[gene=wchK] [locus_tag=SPC15C_0010] [db_xref=GOA:Q4K1M1InterPro:IPR007235UniProtKB/TrEMBL:Q4K1M1][protein=putative glycosyl transferase] [protein_id=CAI33388.1][location=6612..7115] [gbkey=CDS]"
      lengths 273
      longCentroidID 273
      longCentroidID "3_7_0"
    paralog 0
    mergedDNA 0
    genomeIDs "3"
    geneIDs "3_7_0"
    degrees 1
    name "group_53"
  ]
  node [
    id 54
    label "70"
    size 1
    centroid "3_7_1"
    maxLenId 0
      members 3
      seqIDs "3_7_1"
    hasEnd 1
    protein "MYIIRAIIAILDLLNTKTCSKKARIVTCVKKLSLNNLINGNKKRINCPFNVEYSKNPAYLTP"
    dna "ATGTATATAATCAGAGCAATAATAGCTATTCTAGATTTACTCAATACTAAAACCTGTAGCAAAAAAGCAAGAATAGTTACTTGTGTAAAAAAACTAAGTTTAAATAACCTAATTAACGGTAACAAAAAAAGAATCAACTGCCCATTTAATGTTGAATATTCTAAAAATCCTGCATATCTTACTCCGTAA"
    annotation ""
    description "hypothetical protein"
      lengths 189
      longCentroidID 189
      longCentroidID "3_7_1"
    paralog 0
    mergedDNA 0
    genomeIDs "3"
    geneIDs "3_7_1"
    degrees 1
    name "group_54"
  ]
  node [
    id 55
    label "6"
    size 1
    centroid "3_9_0"
    maxLenId 0
      members 3
      seqIDs "3_9_0"
    hasEnd 1
    protein "LKDKIHRIIPLYIIKNQNIAFQQDTDIAYRKLKKKFRHISLTGDELKYKMEFSNKVWICWFQGEEHAPELIKTCIQSMRNQLQGREIIVLTEKNISDYTEIPDYIIEKYKKGWISRAHYSDILRIDLLCRHGGLWVDATVLNTGGDFSNLEVPLFVYKSLNLSRKDSQAIVASSWLISSYSNHPILLYTRKLLWAYWRRKNSLCNYFLFHICFTIATERYPIEWSAVPTFNNHSPHILHFELNEQFSEKRWEQLKHISAFHKLNHHIDYSSGVNTFYKFIVSSKV"
    dna "TTGAAGGATAAAATTCATAGAATTATTCCATTATATATTATAAAAAATCAAAATATAGCTTTTCAACAAGATACCGATATAGCATATAGAAAACTAAAGAAGAAGTTTAGACATATTTCGTTGACTGGAGATGAGCTTAAATATAAAATGGAGTTTTCAAATAAAGTTTGGATTTGTTGGTTTCAGGGAGAAGAGCATGCCCCAGAGTTAATTAAAACATGTATTCAATCAATGAGGAATCAACTTCAAGGAAGAGAAATCATTGTGTTGACAGAAAAAAATATAAGTGATTATACAGAGATTCCAGACTATATTATTGAAAAATACAAAAAAGGATGGATTTCTCGTGCGCATTACTCTGATATCCTTAGGATAGATCTTCTATGTCGCCATGGAGGATTATGGGTAGATGCAACAGTGTTGAATACAGGAGGAGATTTCTCAAATCTTGAGGTACCACTTTTTGTATATAAATCTTTGAATTTATCAAGAAAAGATTCACAAGCTATTGTAGCATCAAGTTGGTTAATTTCGTCATATAGTAATCATCCTATATTACTCTATACGAGAAAACTCCTATGGGCCTACTGGCGAAGAAAAAATAGTTTATGTAATTATTTTTTGTTCCATATATGTTTTACAATAGCTACAGAGCGGTACCCAATCGAATGGTCTGCTGTCCCTACTTTTAATAATCATTCTCCTCATATACTTCATTTTGAGTTGAATGAACAATTTTCGGAAAAACGGTGGGAACAACTGAAGCATATTTCGGCGTTTCATAAATTAAATCATCATATAGATTATTCTAGCGGTGTTAACACTTTTTATAAGTTCATAGTATCTTCGAAAGTTTAG"
    annotation ""
    description "[gene=wchN] [locus_tag=SPC15C_0014] [db_xref=GOA:Q6X853InterPro:IPR008441UniProtKB/TrEMBL:Q6X853][protein=putative glycosyl transferase] [protein_id=CAI33392.1][location=10279..11187] [gbkey=CDS]"
      lengths 858
      longCentroidID 858
      longCentroidID "3_9_0"
    paralog 0
    mergedDNA 0
    genomeIDs "3"
    geneIDs "3_9_0"
    degrees 0
    name "group_55"
  ]
  node [
    id 56
    label "0"
    size 1
    centroid "3_10_0"
    maxLenId 0
      members 3
      seqIDs "3_10_0"
    hasEnd 1
    protein "MGYQLIGIAAPLITSPYLSRILGAENLGIHSFTMSVALYFMMFMLLGIANYGNRTIATVKREGKDILSKTFWSIYSIQLIMSILVTIAYLAYLYLGAVHYKVIAILQLFLLLSNAVDITWFFYGLENFKQIVFRNTLVKLLGLFLIFLCVRQGTDLWKYTFINGSVTLVGQLLLWGQLKGILTWKKIQLKELLPHIKPILILFIPVLAISIFTNMDKYMLGLMVDVKQVGFYDNAGRIIEIPKALIAALGAVMLPRTSYLLAEGQKEKSKYYIEVTILYVMIISSVLMFGLISVSDIFSIIFWGEEFLESGRLISAMSPAFVFSVLGNIIRTQYLIPRAKDKDYVVSLIAGAVVNLVLNYFFIKPFGAMGATISTVLAEFVLSGMQFWSVRRDLDLKRYLKNGLIFYLFGLIMHLIIIALKTQLPYNIMSLILLIVLGGIVYVIFCCCYILMSRNLHFKLLKEKIIRKVVHKNTL"
    dna "ATGGGGTATCAGTTAATTGGTATTGCAGCTCCCTTGATAACTTCTCCTTATTTATCACGGATATTAGGTGCTGAAAATTTAGGTATTCATTCTTTTACTATGTCGGTTGCACTTTACTTTATGATGTTTATGCTTCTTGGAATTGCAAATTACGGAAATAGAACAATTGCGACTGTTAAACGAGAAGGAAAGGATATTCTATCAAAAACGTTTTGGAGTATCTACTCTATCCAGTTGATAATGTCTATTCTGGTAACTATAGCTTATCTTGCTTATCTATATTTGGGGGCAGTACATTACAAAGTTATTGCAATATTACAACTCTTTTTATTGTTATCAAATGCTGTTGATATTACTTGGTTTTTCTATGGATTAGAAAATTTTAAGCAAATCGTTTTTAGGAATACATTAGTCAAACTTTTAGGATTATTTTTAATTTTTTTATGTGTGCGTCAAGGCACAGATTTATGGAAATACACATTTATAAACGGATCAGTAACTTTAGTTGGCCAACTTTTACTATGGGGACAATTAAAAGGAATATTAACTTGGAAAAAAATTCAATTAAAGGAATTACTACCTCATATCAAGCCAATTTTAATTCTTTTTATTCCTGTACTAGCCATTAGTATTTTTACTAATATGGATAAATATATGCTTGGTTTAATGGTTGATGTAAAGCAGGTTGGATTTTATGACAATGCAGGTAGAATTATTGAAATTCCTAAAGCTTTGATTGCAGCTTTAGGGGCCGTTATGTTACCAAGAACTTCCTATTTATTAGCGGAAGGACAGAAAGAAAAGAGTAAATACTACATAGAGGTAACAATTTTATACGTGATGATTATTTCTAGTGTATTGATGTTTGGGCTAATATCGGTATCTGATATTTTTTCCATTATATTTTGGGGAGAAGAATTTCTTGAATCAGGTAGATTGATTTCTGCTATGTCTCCGGCTTTTGTCTTCTCTGTATTAGGAAATATCATTAGGACTCAGTATTTGATTCCTAGAGCTAAGGATAAAGATTATGTAGTGTCTCTAATTGCGGGGGCTGTTGTTAATCTAGTGCTAAACTATTTTTTTATAAAACCTTTTGGTGCTATGGGAGCAACAATTAGTACAGTTTTGGCAGAATTTGTATTGTCTGGAATGCAGTTTTGGTCAGTAAGAAGAGACTTAGATTTAAAAAGATATTTGAAAAACGGTTTGATATTCTACCTATTTGGTCTGATTATGCACCTCATTATTATAGCACTCAAAACTCAGTTACCATACAATATAATGAGTCTTATTTTACTAATAGTTTTGGGTGGAATAGTATATGTTATTTTTTGTTGTTGCTATATTTTAATGTCAAGAAATTTACATTTTAAGTTATTGAAGGAAAAGATTATACGAAAGGTTGTACATAAAAATACATTATAA"
    annotation ""
    description "[gene=wzx] [locus_tag=SPC15C_0015] [db_xref=GOA:Q6X852InterPro:IPR002797UniProtKB/TrEMBL:Q6X852][protein=flippase Wzx] [protein_id=CAI33393.1] [location=11192..12655][gbkey=CDS]"
      lengths 1428
      longCentroidID 1428
      longCentroidID "3_10_0"
    paralog 0
    mergedDNA 0
    genomeIDs "3"
    geneIDs "3_10_0"
    degrees 1
    name "group_56"
  ]
  node [
    id 57
    label "34"
    size 1
    centroid "3_10_1"
    maxLenId 0
      members 3
      seqIDs "3_10_1"
    hasEnd 0
    protein "MVTKDKGLTYNSTLHAIKVLACFSVVAIHIWLPGKIGAFYQIIARFAVPMFFLISGFYSYNISKNKIQNRIKKIFRLILRSTFFYVIIFVWMFWREGNMQFIFQNFNLTNIIRFVIFNRISDLIGYLATPLWYLFAILYIYIYIFIFPIKDYY"
    dna "ATGGTTACTAAAGATAAAGGATTAACATATAATAGTACTTTGCATGCAATAAAAGTATTAGCATGTTTTAGTGTTGTTGCTATTCATATATGGCTACCAGGAAAAATTGGAGCGTTTTATCAAATAATAGCACGATTTGCAGTTCCAATGTTCTTTTTGATTTCTGGCTTTTATTCATATAATATTTCAAAGAATAAAATACAGAATAGAATTAAAAAAATATTTAGATTGATATTAAGAAGTACATTTTTTTATGTAATAATATTTGTATGGATGTTTTGGAGAGAAGGTAATATGCAGTTTATTTTTCAAAACTTTAATTTAACAAATATTATAAGATTTGTGATTTTTAATAGGATTTCAGATTTAATAGGCTATCTAGCAACACCGTTGTGGTATTTATTTGCTATATTATATATATATATATATATCTTTATTTTTCCAATAAAAGACTACTATTGA"
    annotation ""
    description "[gene=wciZ] [locus_tag=SPC15B_0016] [db_xref=GOA:Q6X851InterPro:IPR002656UniProtKB/TrEMBL:Q6X851][protein=putative acetyl transferase] [protein_id=CAI33371.1][location=13021..13998] [gbkey=CDS]"
      lengths 462
      longCentroidID 462
      longCentroidID "3_10_1"
    paralog 0
    mergedDNA 0
    genomeIDs "3"
    geneIDs "3_10_1"
    degrees 2
    name "group_58"
  ]
  node [
    id 58
    label "33"
    size 1
    centroid "3_10_2"
    maxLenId 0
      members 3
      seqIDs "3_10_2"
    hasEnd 1
    protein "MEATISDSIFYRNFLFMGIPFFGIGILIAQKQKKIINCKIINKILILGTIIYPILIFLEYYILGNSFEIYISSVLATIILMIFAIKSPKAINIKILNEIGDKYATFVYIIHQFIIVIFKFLVSNVYILKFGTIFVFLICCFLGVLFQFIKNRLLKRFS"
    dna "ATGGAAGCTACAATTAGCGATTCAATTTTTTATAGAAATTTTTTATTTATGGGAATACCATTTTTTGGAATAGGAATTCTTATTGCACAGAAGCAAAAGAAGATTATTAATTGTAAAATAATAAACAAAATATTAATCTTGGGAACAATTATCTATCCAATACTAATATTTTTAGAATATTATATCTTGGGTAATTCTTTTGAGATCTATATAAGTTCTGTGCTAGCAACCATAATATTGATGATTTTCGCGATTAAATCACCTAAAGCGATTAATATAAAAATACTGAATGAAATTGGAGATAAATATGCGACTTTTGTTTACATTATACACCAGTTTATCATTGTGATATTTAAATTTTTAGTATCTAATGTTTATATTCTCAAATTTGGGACGATATTTGTCTTTTTGATATGTTGTTTTCTAGGGGTTCTATTTCAATTTATCAAAAACAGACTATTAAAAAGGTTTAGTTAA"
    annotation ""
    description "[gene=wciZ] [locus_tag=SPC15B_0016] [db_xref=GOA:Q6X851InterPro:IPR002656UniProtKB/TrEMBL:Q6X851][protein=putative acetyl transferase] [protein_id=CAI33371.1][location=13021..13998] [gbkey=CDS]"
      lengths 477
      longCentroidID 477
      longCentroidID "3_10_2"
    paralog 0
    mergedDNA 0
    genomeIDs "3"
    geneIDs "3_10_2"
    degrees 1
    name "group_57"
  ]
  node [
    id 59
    label "12"
    size 1
    centroid "3_11_0"
    maxLenId 0
      members 3
      seqIDs "3_11_0"
    hasEnd 1
    protein "MISDSRKQTEEFQKYFWYSGEIFEVGMPRNDALFHYKEDYDKLNNIRKKLSIDSDDYVILYAPTFRDDGDASYLDINFERLLQSIEQEIKKKCKILIRLHPNDSHFSNNISFNHDIIDVTLFSDMQELILLADVLLTDYSSAIFDFMLLNKPYVRYVNDLEKYAELRGVSDTYYELPDSIIKTAEELYDLLPKKIENFDYDSIKKYRNEILCPIFNGTASENVGRRIIQEL"
    dna "ATGATTTCAGATAGCAGAAAACAAACTGAAGAATTTCAAAAGTATTTTTGGTATTCAGGAGAAATTTTTGAGGTGGGGATGCCGAGAAATGATGCCTTGTTTCACTATAAGGAAGACTACGACAAGTTAAATAATATCAGAAAAAAACTAAGCATTGATTCAGATGATTATGTTATTTTATATGCCCCTACTTTCAGAGATGATGGGGATGCATCTTATTTAGATATAAATTTTGAACGGCTTTTGCAAAGTATTGAACAAGAAATTAAGAAGAAATGTAAAATTTTAATTAGATTACATCCTAATGACTCTCATTTTAGTAATAATATTTCTTTTAATCATGACATAATTGATGTTACGCTATTCTCAGATATGCAGGAACTTATATTATTGGCAGATGTTTTACTGACAGATTATTCTTCCGCGATATTTGATTTTATGCTTTTAAACAAGCCTTATGTCAGATATGTGAATGATTTAGAAAAATATGCTGAGCTTAGGGGGGTATCAGATACATATTATGAATTGCCGGATTCTATTATTAAAACTGCTGAAGAATTGTATGACTTACTGCCTAAAAAAATAGAAAATTTTGATTATGATTCTATAAAAAAATATAGAAATGAAATACTGTGTCCAATCTTTAATGGAACCGCTAGTGAAAATGTAGGAAGGAGAATAATTCAAGAGTTGTGA"
    annotation ""
    description "[gene=wchX] [locus_tag=SPC15C_0017] [db_xref=GOA:Q6X850InterPro:IPR007554UniProtKB/TrEMBL:Q6X850][protein=putative glycerol phosphotransferase] [protein_id=CAI33395.1][location=14002..15150] [gbkey=CDS]"
      lengths 696
      longCentroidID 696
      longCentroidID "3_11_0"
    paralog 0
    mergedDNA 0
    genomeIDs "3"
    geneIDs "3_11_0"
    degrees 0
    name "group_59"
  ]
  node [
    id 60
    label "22"
    size 1
    centroid "3_12_0"
    maxLenId 0
      members 3
      seqIDs "3_12_0"
    hasEnd 1
    protein "MKQIENLYQNNITDITIIAGYKSSVLTDAVTEKYPEINIIDNVDFKTTNNMYSAYLGKAAMGDSDFLMMNADVFYDASVIKSLLLHKAPNAIVTDLGIYIEESMKVVEKNGRLVEISKQISPEETLGVSIDVYKFSYEAGARFFEKCKEFIEDKRELQMWSEVALNAILSEVEFVACPLEGRWLEIDNHEDLVAAEKLFA"
    dna "ATGAAACAAATTGAAAATTTATATCAAAATAATATTACAGATATTACGATTATTGCTGGATATAAGTCATCTGTATTAACAGATGCAGTTACTGAAAAGTATCCAGAAATTAATATTATTGATAATGTTGATTTTAAAACGACTAATAATATGTATTCAGCCTATCTAGGAAAAGCTGCAATGGGTGATAGTGACTTCTTAATGATGAATGCAGATGTATTTTATGATGCTTCTGTTATTAAAAGTCTGTTGCTTCATAAAGCTCCAAATGCAATTGTAACTGATTTAGGTATTTATATTGAAGAGTCTATGAAAGTCGTAGAAAAAAATGGTCGTTTAGTAGAAATTTCTAAACAGATTTCACCTGAGGAAACTTTAGGAGTTTCTATTGATGTTTATAAATTCTCTTATGAAGCAGGTGCTCGATTCTTTGAAAAGTGTAAGGAATTTATTGAAGATAAACGAGAACTTCAAATGTGGAGTGAGGTTGCTCTTAATGCAATTCTTTCTGAAGTTGAATTTGTAGCATGTCCATTAGAGGGTCGTTGGTTAGAAATTGATAATCATGAAGACTTAGTTGCTGCAGAAAAACTATTTGCTTGA"
    annotation ""
    description "[gene=gtp2] [locus_tag=SPC15C_0019] [db_xref=GOA:Q6X848InterPro:IPR005835UniProtKB/TrEMBL:Q6X848][protein=putative nucleotidyl transferase] [protein_id=CAI33397.1][location=16230..16934] [gbkey=CDS]"
      lengths 603
      longCentroidID 603
      longCentroidID "3_12_0"
    paralog 0
    mergedDNA 0
    genomeIDs "3"
    geneIDs "3_12_0"
    degrees 0
    name "group_60"
  ]
  node [
    id 61
    label "72"
    size 1
    centroid "4_0_0"
    maxLenId 0
      members 4
      seqIDs "4_0_0"
    hasEnd 1
    protein "MNIKKRVLSAGLTFASALLLAACGQSGSDTKTYSSTFSGNPTTFNYLLDYYADNIVN"
    dna "ATGAACATAAAGAAGCGTGTCCTTAGTGCAGGCCTGACTTTTGCATCTGCTTTGCTTTTAGCTGCTTGCGGCCAATCAGGTTCAGATACAAAAACTTACTCATCAACCTTTAGTGGAAATCCAACTACATTTAACTATCTATTAGACTATTACGCTGATAATATAGTCAATTGA"
    annotation ""
    description "hypothetical protein"
      lengths 174
      longCentroidID 174
      longCentroidID "4_0_0"
    paralog 0
    mergedDNA 0
    genomeIDs "4"
    geneIDs "4_0_0"
    degrees 1
    name "group_61"
  ]
  node [
    id 62
    label "61"
    size 1
    centroid "4_0_1"
    maxLenId 0
      members 4
      seqIDs "4_0_1"
    hasEnd 0
    protein "MLVRETSETILQKSRSSSSLRKSLERLIHHLLDLQPKKSSDIFFQILCLLLTDLLMSDHILDKNKYRILFRQSKQVLGALNY"
    dna "ATGTTGGTAAGAGAAACTTCTGAAACCATACTTCAAAAAAGTCGCTCGTCATCGTCTCTTCGTAAGTCATTGGAACGATTAATTCACCATTTATTAGACCTGCAACCAAAGAAATCCTCTGATATCTTCTTCCAGATACTTTGCCTCTTATTAACTGACCTTTTAATGAGCGACCATATTCTCGATAAAAATAAGTATCGAATCCTGTTTCGTCAATCTAAACAGGTGCTAGGTGCTTTAAACTATTAA"
    annotation ""
    description "hypothetical protein"
      lengths 249
      longCentroidID 249
      longCentroidID "4_0_1"
    paralog 0
    mergedDNA 0
    genomeIDs "4"
    geneIDs "4_0_1"
    degrees 2
    name "group_63"
  ]
  node [
    id 63
    label "52"
    size 1
    centroid "4_0_2"
    maxLenId 0
      members 4
      seqIDs "4_0_2"
    hasEnd 1
    protein "MWYNLFMAYSIDFRKKALSYCERTGSITEASHVFQISRNTIYGWLKLKEKTGELNHQVKGIKPRKVDRDRLKNYLTDNPDAYLTEIASEFGCHPTTIHYALKAMGYTRKKEPHLL"
    dna "ATGTGGTATAATCTTTTTATGGCATATTCAATAGATTTTCGTAAAAAAGCTCTCTCTTATTGTGAGCGAACAGGTAGTATAACAGAAGCATCACACGTTTTCCAAATCTCACGTAATACCATTTATGGCTGGTTAAAGCTAAAAGAGAAAACAGGAGAGCTAAACCACCAAGTAAAAGGAATAAAACCAAGAAAAGTTGATAGAGATAGACTTAAAAACTATCTTACTGACAATCCAGACGCTTATTTGACTGAAATAGCTTCTGAATTTGGCTGTCATCCAACTACCATCCACTATGCGCTCAAAGCTATGGGCTACACTCGAAAAAAAGAACCACACCTACTATGA"
    annotation ""
    description "IS630 family transposase IS630-Spn1"
      lengths 348
      longCentroidID 348
      longCentroidID "4_0_2"
    paralog 0
    mergedDNA 0
    genomeIDs "4"
    geneIDs "4_0_2"
    degrees 1
    name "group_62"
  ]
  node [
    id 64
    label "13"
    size 1
    centroid "4_1_0"
    maxLenId 0
      members 4
      seqIDs "4_1_0"
    hasEnd 1
    protein "MTVNRDTKKILLTTTPRDAYVPIADGGNNQKDKLTHAGIYGVDSSIHTLENLYGVDINYYVRLNFTSFLKMIDLLGGVDVHNDQEFSTLHGKFHFPVGNVHLDSEQALGFVRERYSLADGDRDRGRNQQKVIVAIIKKLTSTEVLKNYSSILQGLQDSLQTNMPIETMIDLVNTQLESGGNYKVNSQDLKGTGRMDLPSYAMPDSNLYVMEIDDSSLAVVKAAIQDVMEGR"
    dna "ATGACTGTCAATCGAGATACCAAGAAAATCCTCTTGACCACAACACCACGTGATGCCTATGTACCAATCGCAGATGGTGGAAATAATCAAAAAGATAAATTAACCCATGCGGGCATTTATGGAGTTGATTCGTCCATTCACACCTTAGAAAATCTCTATGGAGTGGATATCAATTACTATGTGCGATTGAACTTCACTTCTTTCTTGAAAATGATTGACTTATTGGGAGGGGTAGATGTTCATAATGATCAAGAATTTTCAACTCTACATGGGAAGTTCCATTTCCCAGTAGGGAATGTCCATCTAGACTCTGAGCAGGCTCTCGGTTTTGTACGTGAACGCTACTCACTAGCCGATGGAGACCGTGACCGTGGTCGCAACCAACAAAAGGTCATTGTAGCAATTATTAAGAAGTTAACTTCTACAGAGGTTTTGAAAAACTATAGTAGTATTCTTCAAGGATTGCAGGATTCTCTTCAAACAAATATGCCGATTGAGACTATGATAGATTTAGTGAATACTCAGTTGGAGAGTGGAGGGAATTATAAAGTAAATTCGCAAGACTTGAAAGGTACAGGTCGGATGGATCTTCCTTCTTATGCAATGCCAGACAGTAACCTCTATGTGATGGAAATAGATGATAGTAGTTTAGCTGTAGTTAAAGCAGCTATACAGGATGTGATGGAGGGTAGATGA"
    annotation ""
    description "[gene=wzg] [locus_tag=SPC15F_0004] [db_xref=GOA:Q4K1K9InterPro:IPR004190InterPro:IPR004474UniProtKB/TrEMBL:Q4K1K9][protein=integral membrane regulatory protein Wzg] [protein_id=CAI33405.1] [location=1544..2998][gbkey=CDS]"
      lengths 696
      longCentroidID 696
      longCentroidID "4_1_0"
    paralog 0
    mergedDNA 0
    genomeIDs "4"
    geneIDs "4_1_0"
    degrees 0
    name "group_64"
  ]
  node [
    id 65
    label "16"
    size 1
    centroid "4_2_0"
    maxLenId 0
      members 4
      seqIDs "4_2_0"
    hasEnd 1
    protein "LAEAYRQGVRTIVSTSHRRKGMFETPEEKIAENFLQVREIAKEVASDLVIAYGAEIYYTPDVLDKLGKKRIPTLNDSRYALIEFSMNTPYRDIHSALNKILMLGITPVIAHIERYDALENNEKRVRELIDMGCYTQVNSSHVLKSKLFGERYKFMKKRAQYFLEQDLVHVIASDMHNLDGRPPHMAEAYDLVTQKYGEAKAQELFVDNPRKIIMDQLI"
    dna "TTGGCAGAAGCCTACAGACAGGGGGTGCGAACCATTGTCTCTACCTCTCACCGTCGCAAGGGCATGTTTGAAACTCCGGAAGAGAAGATAGCAGAAAACTTTCTTCAGGTTCGGGAAATAGCTAAGGAAGTGGCGAGTGACTTAGTCATTGCTTACGGGGCTGAAATTTACTACACACCAGATGTTCTGGATAAGCTGGGAAAAAAGCGGATTCCGACCCTCAATGATAGTCGTTATGCCTTGATAGAGTTTAGTATGAACACTCCTTATCGCGATATTCATAGCGCCTTGAACAAGATCTTGATGTTGGGAATTACTCCAGTCATTGCCCACATTGAGCGCTATGATGCTCTTGAAAATAATGAAAAACGCGTTCGAGAATTGATCGATATGGGCTGTTACACGCAAGTAAATAGTTCACATGTCCTCAAATCCAAACTTTTTGGCGAACGTTATAAATTCATGAAAAAAAGAGCTCAGTATTTTTTAGAGCAGGATTTGGTCCATGTCATTGCAAGTGATATGCACAATCTAGACGGCAGACCTCCTCATATGGCAGAAGCATATGACCTTGTTACCCAAAAATACGGAGAAGCGAAGGCTCAGGAACTTTTTGTAGATAATCCCAGAAAAATTATAATGGATCAATTAATTTAG"
    annotation ""
    description "[gene=wzh] [locus_tag=SPC15F_0005] [db_xref=GOA:Q4K1K8InterPro:IPR004013InterPro:IPR016667UniProtKB/TrEMBL:Q4K1K8][protein=protein-tyrosine phosphatase Wzh] [protein_id=CAI33406.1] [location=3000..3731] [gbkey=CDS]"
      lengths 657
      longCentroidID 657
      longCentroidID "4_2_0"
    paralog 0
    mergedDNA 0
    genomeIDs "4"
    geneIDs "4_2_0"
    degrees 0
    name "group_65"
  ]
  node [
    id 66
    label "55"
    size 1
    centroid "4_3_0"
    maxLenId 0
      members 4
      seqIDs "4_3_0"
    hasEnd 1
    protein "MLETLRKYFDYIIVDTAPVGVVIDAAIITRKCDASILVTEAGEINRRDIQKAKEQLEHTGKPFLGVVLNKFDTSVDKYGSYGNYGDYGKNKK"
    dna "ATGCTTGAAACCTTGCGTAAATATTTTGACTATATCATTGTAGATACTGCTCCTGTCGGTGTCGTGATTGATGCGGCTATTATTACGCGAAAATGCGATGCTTCTATTTTAGTGACGGAGGCAGGTGAAATAAATCGACGGGATATTCAAAAAGCAAAAGAACAGTTGGAACACACAGGGAAGCCGTTTTTGGGAGTTGTGTTGAATAAATTCGATACTTCAGTAGACAAATACGGTTCTTATGGAAATTATGGAGATTACGGGAAAAATAAAAAATAG"
    annotation ""
    description "[gene=wze] [locus_tag=SPC15F_0007] [db_xref=GOA:Q4K1K6InterPro:IPR002586InterPro:IPR005702UniProtKB/TrEMBL:Q4K1K6][protein=tyrosine-protein kinase Wze][protein_id=CAI33408.1] [location=4442..5131] [gbkey=CDS]"
      lengths 279
      longCentroidID 279
      longCentroidID "4_3_0"
    paralog 0
    mergedDNA 0
    genomeIDs "4"
    geneIDs "4_3_0"
    degrees 0
    name "group_66"
  ]
  node [
    id 67
    label "60"
    size 1
    centroid "4_4_0"
    maxLenId 0
      members 4
      seqIDs "4_4_0"
    hasEnd 1
    protein "MSLVGTRPPTVDEYEHYTPEQKRRLSFKPGITGLWQVSGRSEIKNFDEVVKLDVAYIDDWTIWKDIEILLKTVKVVFMRDGAK"
    dna "ATGAGTTTGGTTGGCACACGGCCACCAACAGTGGACGAGTATGAACACTATACCCCAGAACAAAAACGTCGGCTAAGTTTTAAACCTGGTATAACAGGCTTATGGCAGGTCAGTGGACGAAGTGAGATTAAGAATTTTGATGAAGTTGTCAAATTAGATGTAGCCTATATAGACGATTGGACAATTTGGAAAGACATTGAAATTTTATTGAAGACAGTTAAAGTTGTATTTATGAGAGACGGAGCGAAGTAG"
    annotation ""
    description "[gene=wchA] [locus_tag=SPC15F_0008] [db_xref=GOA:Q4K1K5InterPro:IPR003362InterPro:IPR017475UniProtKB/TrEMBL:Q4K1K5][protein=undecaprenylphosphate glucosephosphotransferase WchA (initial sugar transferase)] [protein_id=CAI33409.1][location=5146..6513] [gbkey=CDS]"
      lengths 252
      longCentroidID 252
      longCentroidID "4_4_0"
    paralog 0
    mergedDNA 0
    genomeIDs "4"
    geneIDs "4_4_0"
    degrees 0
    name "group_67"
  ]
  node [
    id 68
    label "35"
    size 1
    centroid "4_6_0"
    maxLenId 0
      members 4
      seqIDs "4_6_0"
    hasEnd 1
    protein "LYTFFNVTKALSYENRTEFAGRTNTISFLWDNLFYYDYISAIFGKGLGSYSVNYIYELGKMLADGGFISVILLYSFLLSLFIRGTITRGKNKQSERLIVSIIAFVVMISIIVWNSTFSRPTYLVFFFLAIGNAAYKSTKLIRRD"
    dna "TTGTATACTTTTTTTAATGTTACAAAGGCATTATCATATGAGAATAGGACAGAGTTTGCGGGACGAACAAATACTATTTCCTTCCTATGGGACAACTTATTTTATTATGATTATATTAGTGCTATATTTGGGAAAGGACTAGGTTCATACTCTGTTAATTATATTTATGAACTTGGTAAAATGCTTGCAGATGGTGGTTTTATTTCAGTGATTTTGCTTTATTCATTTTTGTTGTCATTATTCATACGGGGAACTATTACTAGAGGAAAAAATAAGCAAAGTGAAAGACTAATTGTATCCATCATAGCTTTTGTGGTGATGATTAGCATTATTGTTTGGAATAGTACGTTCTCTAGACCAACTTATCTTGTATTTTTCTTTCTAGCAATAGGTAATGCAGCGTATAAGTCTACTAAATTAATAAGAAGGGATTGA"
    annotation ""
    description "[gene=wzy] [locus_tag=SPC15F_0011] [db_xref=UniProtKB/TrEMBL:Q4K1K2] [protein=oligosaccharide repeat unit polymerase Wzy] [protein_id=CAI33412.1] [location=7453..8664][gbkey=CDS]"
      lengths 435
      longCentroidID 435
      longCentroidID "4_6_0"
    paralog 0
    mergedDNA 0
    genomeIDs "4"
    geneIDs "4_6_0"
    degrees 0
    name "group_68"
  ]
  node [
    id 69
    label "56"
    size 1
    centroid "4_7_0"
    maxLenId 0
      members 4
      seqIDs "4_7_0"
    hasEnd 1
    protein "MDFRFYLANLYVNNLFKFDSPYSSKEKLDQIAQQLKKYRLFLDEKVSKEKMPKNINEMIVFYLLKLKIPVLIYSFYSFKEWWKRRKIKNEG"
    dna "ATGGATTTTAGATTTTACCTTGCTAACTTGTATGTAAATAATTTATTTAAATTTGATTCTCCGTATTCATCAAAAGAAAAACTAGACCAAATTGCTCAACAATTAAAAAAGTATAGATTATTTTTAGATGAAAAAGTCAGCAAAGAAAAGATGCCTAAAAATATAAATGAGATGATTGTTTTTTATTTACTAAAATTGAAAATTCCAGTGTTGATTTATTCTTTTTATTCGTTTAAAGAGTGGTGGAAGAGAAGAAAAATTAAAAATGAAGGATAA"
    annotation ""
    description "[gene=wchL] [locus_tag=SPC15C_0012] [db_xref=GOA:Q4K1L9InterPro:IPR001173UniProtKB/TrEMBL:Q4K1L9][protein=putative glycosyl transferase] [protein_id=CAI33390.1][location=8274..9299] [gbkey=CDS]"
      lengths 276
      longCentroidID 276
      longCentroidID "4_7_0"
    paralog 0
    mergedDNA 0
    genomeIDs "4"
    geneIDs "4_7_0"
    degrees 0
    name "group_69"
  ]
  node [
    id 70
    label "37"
    size 1
    centroid "4_9_0"
    maxLenId 0
      members 4
      seqIDs "4_9_0"
    hasEnd 1
    protein "LIPRAKDKDYVVSLIAGAVVNLVLNYFFIKPFGAMGATVSTVLAEFVLSGMQFWSVRRDLDLKRYLKNGLIFYLFGLIMYLVIITLKTQLPYNIMSLILLIVLGGIVYVIFCCCYILMSRNLHFKLLKEKIIRKVVHKNTL"
    dna "TTGATTCCTAGAGCTAAGGATAAAGATTATGTAGTGTCTCTAATTGCGGGGGCTGTTGTTAATCTAGTGCTAAACTATTTTTTTATAAAACCTTTTGGTGCTATGGGAGCAACAGTTAGTACAGTTTTGGCAGAATTTGTATTGTCTGGAATGCAGTTTTGGTCAGTAAGAAGAGACTTAGATTTAAAAAGATATTTGAAAAACGGTTTGATATTCTACCTATTTGGTCTGATTATGTACCTTGTTATTATAACACTCAAAACTCAGTTACCATACAATATAATGAGTCTTATTTTACTAATAGTTTTGGGTGGAATAGTATATGTTATTTTTTGTTGTTGCTATATTTTAATGTCAAGAAATTTACATTTTAAGTTATTGAAGGAAAAGATTATACGAAAGGTTGTACATAAAAATACATTATAA"
    annotation ""
    description "[gene=wzx] [locus_tag=SPC15F_0015] [db_xref=GOA:Q4K1J8InterPro:IPR002797UniProtKB/TrEMBL:Q4K1J8][protein=flippase Wzx] [protein_id=CAI33416.1] [location=11587..13050][gbkey=CDS]"
      lengths 426
      longCentroidID 426
      longCentroidID "4_9_0"
    paralog 0
    mergedDNA 0
    genomeIDs "4"
    geneIDs "4_9_0"
    degrees 0
    name "group_70"
  ]
  node [
    id 71
    label "7"
    size 1
    centroid "4_10_0"
    maxLenId 0
      members 4
      seqIDs "4_10_0"
    hasEnd 1
    protein "MFFLISGFYSYNISKNKIRNRIKKIFRLILRSTFFYVIIFVWMFWREGNMQFIFQNFNLTNIIRFVIFNRISDLIGYLATPLWYLFAILYIYIYLYFSNKRLLLTKRWISILLLFSFIMEATISDSIFYRNFLFMGIPFFGIGILIAQKQKEIINCKIINKILILGTIIYPILIFLEYYILGNSFEVYISSVLATIILMIFAIKSPKAINIKILNEIGDKYATFVYIIHQFIIVIFKFLVSNVYILKFGTIFVFLICCFLGVLFQFIKNRLLKRFS"
    dna "ATGTTCTTTTTGATTTCTGGCTTTTATTCATATAATATTTCAAAGAATAAAATACGGAATAGAATTAAAAAAATATTTAGATTGATATTAAGAAGTACATTTTTTTATGTAATAATATTTGTATGGATGTTTTGGAGAGAAGGTAATATGCAGTTTATTTTTCAAAACTTTAATTTAACAAATATTATAAGATTTGTGATTTTTAATAGAATTTCAGATTTAATAGGCTATCTAGCAACACCGTTATGGTATTTATTTGCCATACTATATATATATATTTACCTTTATTTTTCCAATAAAAGACTACTATTGACAAAACGATGGATCTCTATACTTTTACTATTTTCTTTCATTATGGAAGCTACAATTAGCGATTCAATTTTTTATAGAAATTTTTTATTTATGGGAATACCATTTTTTGGAATAGGAATTCTTATTGCACAGAAGCAAAAGGAGATTATTAATTGTAAAATAATAAACAAAATATTAATCTTGGGAACAATTATCTATCCAATACTAATATTTTTAGAATATTATATCTTGGGTAATTCTTTTGAGGTCTATATAAGTTCTGTGCTAGCAACCATAATATTGATGATTTTCGCGATTAAATCACCTAAAGCGATTAATATCAAAATACTGAATGAAATTGGAGATAAATATGCGACTTTTGTTTACATTATACACCAGTTTATCATTGTGATATTTAAATTTTTAGTATCTAATGTTTATATTCTCAAATTTGGGACGATATTTGTCTTTTTGATATGTTGTTTTCTAGGGGTTCTATTTCAATTTATCAAAAACAGACTATTAAAAAGGTTTAGTTAA"
    annotation ""
    description "[gene=wciZ] [locus_tag=SPC15F_0016] [db_xref=GOA:Q4K1J7InterPro:IPR002656UniProtKB/TrEMBL:Q4K1J7][protein=putative acetyl transferase] [protein_id=CAI33417.1][location=13406..14383] [gbkey=CDS]"
      lengths 831
      longCentroidID 831
      longCentroidID "4_10_0"
    paralog 0
    mergedDNA 0
    genomeIDs "4"
    geneIDs "4_10_0"
    degrees 0
    name "group_71"
  ]
  node [
    id 72
    label "73"
    size 1
    centroid "4_11_0"
    maxLenId 0
      members 4
      seqIDs "4_11_0"
    hasEnd 1
    protein "MFCIGPDAITSISISVIEGIAAPKLFGLSSCLFKTATGEAMPSFAAVVGIDR"
    dna "ATGTTTTGTATAGGTCCTGATGCAATAACATCAATATCAATTAGTGTCATTGAGGGGATAGCCGCCCCTAAGCTTTTTGGTCTATCATCCTGTCTTTTCAAAACAGCAACTGGGGAAGCAATGCCATCATTTGCTGCTGTTGTCGGAATCGATAGGTAA"
    annotation ""
    description "hypothetical protein"
      lengths 159
      longCentroidID 159
      longCentroidID "4_11_0"
    paralog 0
    mergedDNA 0
    genomeIDs "4"
    geneIDs "4_11_0"
    degrees 0
    name "group_72"
  ]
  node [
    id 73
    label "9"
    size 1
    centroid "4_12_0"
    maxLenId 0
      members 4
      seqIDs "4_12_0"
    hasEnd 1
    protein "LFEGTLELLDYIHNIGGEYIFITNNSSKSVVDYVEKVNRLGIKAERDNFFTSAQATIVYIKENYPKSKVYCQGTKSLIKELSDAGIDVTEQVSADIDVVLVGFDTELTSDKIRNTCEILSTKDVPFIATNPDIRCPVSFGFIPDCGSICDMISKSVDRKPVYIGKPEPTMVDIVRKKLNYSLFETVVIGDRLYTDIMTGINAGVTSVCVLTGEATVNDIQQGSIKPTYTFKNVKEMWKGIV"
    dna "TTGTTTGAGGGTACTCTCGAATTATTAGACTATATTCATAATATTGGCGGTGAGTATATTTTTATTACAAACAATTCATCTAAGTCTGTTGTTGACTATGTTGAAAAAGTTAACAGATTAGGTATTAAAGCTGAACGAGATAATTTTTTTACCTCTGCTCAAGCCACAATTGTTTATATTAAAGAAAATTATCCTAAATCTAAAGTTTATTGCCAAGGAACAAAATCTTTGATAAAAGAACTATCTGACGCAGGAATTGATGTAACTGAGCAAGTTAGTGCTGATATAGATGTTGTTCTTGTTGGTTTTGATACAGAATTAACCAGTGATAAAATTCGCAATACCTGCGAGATTCTATCAACAAAGGACGTACCTTTCATAGCTACTAACCCTGATATTCGCTGCCCAGTATCGTTTGGATTCATCCCAGATTGTGGTTCTATTTGTGATATGATTAGTAAATCAGTCGATAGGAAACCTGTTTACATAGGTAAACCTGAACCTACGATGGTTGATATTGTTCGAAAAAAATTAAATTATTCTCTATTTGAAACAGTTGTGATTGGAGATCGCTTGTATACGGATATCATGACTGGTATAAATGCAGGAGTAACTTCAGTTTGTGTGCTGACAGGAGAAGCAACGGTGAATGATATTCAACAAGGTAGTATAAAACCGACTTATACATTTAAAAACGTGAAAGAAATGTGGAAAGGAATTGTCTGA"
    annotation ""
    description "[gene=gtp3] [locus_tag=SPC15F_0020] [db_xref=GOA:Q4K1N0InterPro:IPR005834InterPro:IPR006357UniProtKB/TrEMBL:Q4K1N0][protein=putative phosphotransferase][protein_id=CAI33421.1] [location=17332..18165] [gbkey=CDS]"
      lengths 726
      longCentroidID 726
      longCentroidID "4_12_0"
    paralog 0
    mergedDNA 0
    genomeIDs "4"
    geneIDs "4_12_0"
    degrees 0
    name "group_73"
  ]
  node [
    id 74
    label "19"
    size 1
    centroid "4_13_0"
    maxLenId 0
      members 4
      seqIDs "4_13_0"
    hasEnd 1
    protein "VTGTKNVAKASEKHGATLVYISTDYVFDGKKPVGQEWEVDDRPDPQTEYGRTKRMGEELVEKHVSNFYIIRTAWVFGNYGKNFVFTMQNLAKTHKTLTVVNDQYGRPTWTRTLAEFMTYLAENRKEFGYYHLSNDATEDTTWYDFAVEILKDTDVEVKPVDSSQFPAKAKRPLNSTMSLAKAKATGFVIPTWQDALQEFYKQEVR"
    dna "GTGACGGGGACAAAAAATGTCGCAAAAGCATCTGAAAAGCATGGTGCAACTCTAGTTTATATTTCTACGGACTATGTCTTTGACGGTAAGAAACCAGTTGGACAAGAGTGGGAAGTTGATGACCGACCAGATCCACAGACAGAATATGGACGCACTAAGCGTATGGGGGAAGAGTTAGTTGAGAAGCATGTGTCTAATTTCTATATTATCCGTACTGCCTGGGTATTTGGAAATTATGGCAAAAACTTCGTTTTTACCATGCAAAATCTTGCGAAAACTCATAAGACTTTAACAGTTGTAAATGACCAGTACGGTCGTCCGACTTGGACTCGTACCTTGGCTGAGTTCATGACCTACCTAGCTGAAAATCGTAAGGAATTTGGTTATTATCATTTGTCAAATGATGCGACAGAAGACACAACATGGTATGATTTTGCAGTTGAAATTTTGAAAGATACAGATGTCGAAGTCAAGCCAGTAGATTCCAGTCAATTTCCAGCCAAAGCTAAACGTCCGCTAAACTCAACGATGAGCCTGGCCAAAGCCAAAGCTACTGGATTTGTTATTCCAACTTGGCAAGATGCATTGCAAGAATTTTACAAACAAGAAGTGAGATAA"
    annotation ""
    description "[gene=rmlD] [locus_tag=SPC15F_0022] [db_xref=GOA:Q4K1G6InterPro:IPR005913InterPro:IPR016040UniProtKB/TrEMBL:Q4K1G6][protein=dTDP-4-keto-L-rhamnose reductase RmlD] [protein_id=CAI33423.1] [location=19145..19996][gbkey=CDS]"
      lengths 618
      longCentroidID 618
      longCentroidID "4_13_0"
    paralog 0
    mergedDNA 0
    genomeIDs "4"
    geneIDs "4_13_0"
    degrees 0
    name "group_74"
  ]
  node [
    id 75
    label "75"
    size 1
    centroid "4_14_0"
    maxLenId 0
      members 4
      seqIDs "4_14_0"
    hasEnd 1
    protein "MFAKYQEEASKNDKVIFCGRLADYKYYDMHVVIERALEVVEKEFGYDKK"
    dna "ATGTTTGCTAAGTACCAAGAGGAAGCTTCAAAGAATGATAAGGTTATTTTCTGTGGACGTTTAGCAGATTATAAATATTATGATATGCATGTGGTGATTGAACGGGCGCTTGAGGTTGTGGAGAAAGAGTTTGGATATGACAAAAAGTAG"
    annotation ""
    description "[gene=glf] [locus_tag=SPC15F_0023] [db_xref=GOA:Q4JZV2InterPro:IPR004379InterPro:IPR006076InterPro:IPR015899InterPro:IPR016040UniProtKB/TrEMBL:Q4JZV2][protein=UDP-galactopyranose mutase Glf] [protein_id=CAI33424.1][location=20059..21168] [gbkey=CDS]"
      lengths 150
      longCentroidID 150
      longCentroidID "4_14_0"
    paralog 0
    mergedDNA 0
    genomeIDs "4"
    geneIDs "4_14_0"
    degrees 0
    name "group_75"
  ]
  node [
    id 76
    label "40"
    size 1
    centroid "4_15_0"
    maxLenId 0
      members 4
      seqIDs "4_15_0"
    hasEnd 1
    protein "VLFDFIYMFAWFLFYEVGSKKDYVSYINPGLWGIAFIVCVLVAFAIFPKMEKNFPKTFLYFTKYGKDSLGIYILHAPICSMIRILMLKVGINSVFLHVVVGIVLGWYLSILATYILKKIPFLNIVLLPQKYIKLK"
    dna "GTGTTATTTGATTTTATTTATATGTTCGCTTGGTTCTTGTTTTATGAAGTAGGGTCTAAGAAGGATTATGTAAGCTATATTAACCCAGGTTTGTGGGGGATTGCTTTTATTGTCTGTGTATTAGTTGCTTTTGCGATTTTTCCTAAAATGGAGAAAAATTTTCCTAAAACTTTCCTATATTTCACTAAATACGGGAAAGATAGTTTAGGGATCTATATTCTTCATGCACCAATTTGTAGCATGATTCGGATTCTAATGTTGAAAGTGGGAATAAACTCAGTTTTTCTTCACGTTGTTGTTGGGATTGTGCTAGGCTGGTATTTATCCATACTAGCAACTTATATATTGAAAAAAATTCCATTTTTGAATATTGTTTTATTACCACAAAAGTATATTAAATTAAAATAA"
    annotation ""
    description "[gene=wcjE] [locus_tag=SPC15F_0024] [db_xref=GOA:Q4K1I9InterPro:IPR002656UniProtKB/TrEMBL:Q4K1I9][protein=putative acetyl transferase] [protein_id=CAI33425.1][location=21116..22183] [gbkey=CDS]"
      lengths 408
      longCentroidID 408
      longCentroidID "4_15_0"
    paralog 0
    mergedDNA 0
    genomeIDs "4"
    geneIDs "4_15_0"
    degrees 0
    name "group_76"
  ]
  edge [
    source 10
    target 11
    size 1
      members 0
    genomeIDs "0"
  ]
  edge [
    source 12
    target 13
    size 1
      members 0
    genomeIDs "0"
  ]
  edge [
    source 13
    target 14
    size 1
      members 0
    genomeIDs "0"
  ]
  edge [
    source 25
    target 26
    size 1
      members 1
    genomeIDs "1"
  ]
  edge [
    source 26
    target 27
    size 1
      members 1
    genomeIDs "1"
  ]
  edge [
    source 31
    target 32
    size 1
      members 1
    genomeIDs "1"
  ]
  edge [
    source 33
    target 34
    size 1
      members 2
    genomeIDs "2"
  ]
  edge [
    source 45
    target 46
    size 2
      members 2
      members 3
    genomeIDs "2;3"
  ]
  edge [
    source 53
    target 54
    size 1
      members 3
    genomeIDs "3"
  ]
  edge [
    source 56
    target 57
    size 1
      members 3
    genomeIDs "3"
  ]
  edge [
    source 57
    target 58
    size 1
      members 3
    genomeIDs "3"
  ]
  edge [
    source 61
    target 62
    size 1
      members 4
    genomeIDs "4"
  ]
  edge [
    source 62
    target 63
    size 1
      members 4
    genomeIDs "4"
  ]
]
