# Functional enrichment for mole-rat cis-regulatory elements

This folder contains an implementation of some of the [GREAT](http://great.stanford.edu/public/html/) functional enrichment tests for cis-regulatory regions, that we applied to mole rats regulatory shifts. Note that the code in intended for repoducibility only, and that more robust packages have re-implemented GREAT since (see [rGREAT](https://bioconductor.org/packages/release/bioc/vignettes/rGREAT/inst/doc/local-GREAT.html)).

## Setting up and activating the environment

`mamba env create -f env.yaml`

`conda activate snake_great`

## Running

The following command runs enrichment tests on heart enhancers UP in the ancestral mole-rat branch, using the Damaraland mole-rat (Fdam) genome as background. The pipeline automatically finds the corresponding .bed files in the `dataset_s2` and `dataset_s3` folders. Results are stored in a new `GO_GREAT_RESULTS_` folder.

`snakemake -s great_hgla_fdam.smk --cores 4 --config sp=Fdam t=Heart r=Enhancers b=ancestral_MR_branch s=UP`

The following command runs enrichment tests on heart enhancers DOWN in the naked mole-rat branch, using the naked mole-rat (Hgla) genome as background:

`snakemake -s great_hgla_fdam.smk --cores 4 --config sp=Hgla t=Heart r=Enhancers b=Hgla_branch s=DOWN`

The following command is similar to the previous one, but filters out heart hgla DOWN enhancers by removing heart enhancers also found as DOWN in the ancestral mole-rat branch (we used this redundancy filter to compare enrichments across branches).

`snakemake -s great_hgla_fdam.smk --cores 4 --config sp=Hgla t=Heart r=Enhancers b=Hgla_branch s=DOWN reduce=y`