#/usr/bin/env/python

"""
TODO

Example
"""

import argparse


def load_mapped_ids(input_file):

    """
    """

    with open(input_file, 'r') as infile:
        mapped = {line.strip().split('\t')[-1]:line.strip().split('\t')[:3] for line in infile}
    return mapped

def get_mappable_regions(input_files, labels):

    """
    """

    li = []
    mapped = {}
    for i, input_file in enumerate(input_files):
        label = labels[i+1]
        mapped[label] = load_mapped_ids(input_file)
        li.append(set(mapped[label].keys()))
    intersection = set.intersection(*li)
    return intersection, mapped

def write_mappable(input_regions, output, mappable_ids):

    """
    """

    with open(input_regions, 'r') as infile, open(output, 'w') as outfile:
        for line in infile:
            _, _, _, unique_id = line.strip().split('\t')
            if unique_id in mappable_ids:
                outfile.write(line)

def write_mappable_summary(input_regions, output, mapped, REF="Mus_musculus"):

    """
    """

    with open(input_regions, 'r') as infile, open(output, 'w') as outfile:
        outfile.write('\t'.join([REF+'_chr', REF+'_start', REF+'_end', "unique_id"]\
                                +sorted(mapped.keys()))+'\n')
        for line in infile:
            ref_chr, ref_start, ref_end, unique_id = line.strip().split('\t')

            tmp = [ref_chr, ref_start, ref_end, unique_id]
            for species in sorted(mapped.keys()):
                if unique_id in mapped[species]:
                    tmp.append(' '.join(mapped[species][unique_id]))
                else:
                    tmp.append("UnMapped")
            outfile.write('\t'.join(tmp)+'\n')



if __name__ == '__main__':

    PARSER = argparse.ArgumentParser(description=__doc__,
                                     formatter_class=argparse.RawDescriptionHelpFormatter)

    PARSER.add_argument('-i', '--inv_mappings', nargs='+', required=True)

    PARSER.add_argument('-l', '--labels', nargs='+', required=True)

    PARSER.add_argument('-r', '--all_regions', type=str, required=True)

    PARSER.add_argument('-o', '--output', type=str, required=True)

    PARSER.add_argument('-s', '--summary', type=str, help='Write a summary file with all input '
                        'regions and their coordinates in each species. If this arg is not '
                        'provided, no summary is written.', required=False, default='')

    ARGS = vars(PARSER.parse_args())

    #mappable in all
    MAPPABLE_REGIONS, MAP = get_mappable_regions(ARGS["inv_mappings"], ARGS["labels"])

    #write to file
    write_mappable(ARGS["all_regions"], ARGS["output"], MAPPABLE_REGIONS)

    if ARGS.get("summary", ""):
        #write more detailed mapping summary
        write_mappable_summary(ARGS["all_regions"], ARGS["summary"], MAP, REF=ARGS["labels"][0])
