#!/usr/bin/env Rscript

library('preprocessCore')
library("optparse")


########
# ARGS #
########

option_list = list(
  make_option(c("-s", "--signal"), type="character"),
  make_option(c("-c", "--control"), type="character"),
  make_option(c("-o", "--output"), type="character")); 

opt_parser = OptionParser(option_list=option_list);
opt = parse_args(opt_parser);


############################
# LOAD input read coverage #
############################

#load data
regDF.input <- read.delim(opt$control)
rownames = regDF.input$unique_id
regDF.input <- regDF.input[,-1]

#replace zero input reads density by smallest read density (to avoid division by 0)
regDF.input[] <- lapply(regDF.input, function(x) replace(x, x == 0, min(x[x>0])))


#format data as matrix
regMat.input <- as.matrix(regDF.input)
rownames(regMat.input) <- rownames
colSpecies <- sub("_.*$", "", colnames(regMat.input))
regMat.input <- regMat.input[order(rownames(regMat.input)), ]


#############################
# LOAD signal read coverage #
#############################

#TOIMPROVE for DRY (not important)

#load data
regDF.signal <- read.delim(opt$signal)

#format data as matrix
regMat.signal <- as.matrix(regDF.signal[,-1])
rownames(regMat.signal) <- regDF.signal$unique_id
colSpecies <- sub("_.*$", "", colnames(regMat.signal))
regMat.signal <- regMat.signal[order(rownames(regMat.signal)), ]


######################
# Normalize by INPUT #
######################

regMat <- regMat.signal / regMat.input
regMat[regMat < 1] <- 1 #set 1 as smallest value (do not allow signal < input)


##########################
# QUANTILE normalization #
##########################

regMat.quant = normalize.quantiles(regMat)
colnames(regMat.quant) = colnames(regMat)
rownames(regMat.quant) = rownames(regMat)
regMat.quant <- log2(regMat.quant)


################
# WRITE output #
################

#remove invariant regions (can't be analyzed by EVE as it would not make sense to test for shifts)
keep <- apply(regMat.quant, 1, function(x) length(unique(x[!is.na(x)])) != 1)
regMat.quant <- regMat.quant[keep,]

#write output table
write.table(regMat.quant, opt$output, sep='\t', quote = FALSE)
