#/usr/bin/env/python

"""
Script producing customized quality control plots for the crossregmap workflow.
"""

import argparse

import seaborn as sns

import matplotlib as mpl
mpl.use('Agg')

import matplotlib.pyplot as plt
import pandas as pd

sns.set_palette("muted")

def load_multiinter(input_file):
    """

    """
    over = []
    with open(input_file, 'r') as infile:
        for line in infile:
            line = line.strip().split('\t')
            sets = line[3]
            sets = set(sets.split(',')) #parse result of merge -o collapse
            sets = (",").join(sorted(list(sets)))
            coord = line[:3]
            size = int(line[2]) - int(line[1])
            over.append((sets, size))
    return pd.DataFrame.from_records(over, columns=["sets", 'Overlap size (# bases)'])

def size_boxplot(df, output):
    """

    """
    order = sorted(df['sets'].unique())
    tmp2 = order[-1]
    tmp1 = order[-2]
    order[-1], order[-2] = tmp1, tmp2
    sns.boxplot(y='Overlap size (# bases)', x='sets', data=df, width=0.3, order=order)
    sns.despine()
    plt.xticks(rotation=45, horizontalalignment="right")
    plt.tight_layout()
    plt.savefig(output)
    plt.close("all")


def sets_barplot(df, output):
    """

    """
    order = sorted(df['sets'].unique())
    tmp2 = order[-1]
    tmp1 = order[-2]
    order[-1], order[-2] = tmp1, tmp2

    ax = sns.countplot(x='sets', data=df, order=order)

    for p in ax.patches: #I guess 'try and except' was there for 0-sized bars ???
        try:
            ax.annotate(int(p.get_height()), (p.get_x() + p.get_width() / 2., p.get_height()),
                        ha='center', va='center', fontsize=8, color='gray', xytext=(0, 5),
                        textcoords='offset points')
        except:
            pass

    sns.despine()

    plt.xticks(rotation=45, horizontalalignment="right")
    plt.tight_layout()
    plt.savefig(output)
    plt.close("all")

if __name__ == '__main__':

    PARSER = argparse.ArgumentParser(description=__doc__,
                                     formatter_class=argparse.RawDescriptionHelpFormatter)

    PARSER.add_argument('-i', '--input', type=str, required=True)

    PARSER.add_argument('-plot_types', "--plot_types", nargs='+', required=False,
                        default=["nb", "size"])

    PARSER.add_argument('-o', "--output", nargs='+', required=False, default="")

    ARGS = vars(PARSER.parse_args())


    if not ARGS["output"]:
        ARGS["output"] = ARGS["plot_types"]

    assert len(ARGS["output"]) == len(ARGS["plot_types"]), "Different nb of plots and outputs."

    DATAFRAME = load_multiinter(ARGS["input"])

    if 'nb' in ARGS["plot_types"]:
        sets_barplot(DATAFRAME, ARGS["output"][0])

    if 'size' in ARGS["plot_types"]:
        if len(ARGS["plot_types"]) == 1:
            OUT = ARGS["output"][0]
        else:
            OUT = ARGS["output"][1]

        size_boxplot(DATAFRAME, OUT)


