import pandas as pd
import seaborn as sns

import matplotlib as mpl
mpl.use('Agg')

import matplotlib.pyplot as plt

import argparse

PARSER = argparse.ArgumentParser(description=__doc__,
                                 formatter_class=argparse.RawDescriptionHelpFormatter)

#Required
PARSER.add_argument('-i', '--input', required=True)

PARSER.add_argument('-o', '--output', required=True)

ARGS = vars(PARSER.parse_args())


df = pd.read_csv(ARGS["input"], sep='\t')

plt.figure(figsize=(7, 4))
g = sns.boxplot(data=df, showfliers=True)
plt.xticks(rotation=45, horizontalalignment="right")
plt.ylabel("Quantile normalized reads density\nlog2(signal_fpkm/input_fpkm)")
sns.despine()
plt.tight_layout()
plt.savefig(ARGS["output"])
# plt.show()
plt.close('all')