#/usr/bin/env/python

"""
TODO

Example
"""

import argparse

def load_active_region(input_file):

    """
    TODO
    """

    data = {}
    with open(input_file, 'r') as infile:
        data = {line.strip().split("\t")[3] for line in infile}
    return data


def write_full_summary(map_summary, active_regions, output_file, ref="Mus_musculus"):

    """
    TODO
    """

    with open(map_summary, 'r') as infile, open(output_file, 'w') as outfile:
        for i, line in enumerate(infile):
            if i == 0:
                col_dict = {j:colname for j, colname in enumerate(line.strip().split('\t'))\
                            if colname in active_regions.keys()}
                line = line.strip().split('\t')
                header = line[:4]+[ref+'_activity']
                for j in range(4, len(line)):
                    header += [line[j]+'_coord', line[j]+'_activity']
                header = '\t'.join(header)
                outfile.write(header+'\n')

            else:
                regions = line.strip().split('\t')[:3]
                unique_id = line.strip().split('\t')[3]
                regions.append(unique_id)

                if unique_id in active_regions[ref]:
                    regions.append("active")
                else:
                    regions.append("inactive")

                for j, sp_entry in enumerate(line.strip().split('\t')[4:]):
                    sp = col_dict[j+4]
                    regions.append(sp_entry)
                    if sp_entry == "UnMapped":
                        regions.append("UnMapped")
                    elif unique_id in active_regions[sp]:
                        regions.append("active")

                    else:
                        regions.append("inactive")

                outfile.write('\t'.join(regions)+'\n')



if __name__ == '__main__':

    PARSER = argparse.ArgumentParser(description=__doc__,
                                     formatter_class=argparse.RawDescriptionHelpFormatter)

    PARSER.add_argument('-r', '--active_regions', nargs='+', required=True)

    PARSER.add_argument('-s', '--summary', type=str, required=True)

    PARSER.add_argument('-l', '--labels', nargs='+', required=True)

    PARSER.add_argument('-o', '--output', type=str, required=False, default='CrossMap_Summary')

    ARGS = vars(PARSER.parse_args())

    #active regions
    ACTIVE = {}
    for LABEL, INPUT_FILE in zip(ARGS["labels"], ARGS["active_regions"]):
        ACTIVE[LABEL] = load_active_region(INPUT_FILE)

    #add activity to mapping summary
    write_full_summary(ARGS["summary"], ACTIVE, ARGS["output"], ARGS["labels"][0])
