#/usr/bin/env/python

"""
TODO

Example
"""

import argparse
from collections import OrderedDict

def load_active_region(input_file):

    """
    TODO
    """
    data = {}
    with open(input_file, 'r') as infile:
        data = {line.strip().split("\t")[3] for line in infile if line != '\n'}
    return data

def load_mapped_regions(input_file):

    """
    TODO
    """

    with open(input_file, 'r') as infile:
        data = {line.strip().split("\t")[3]: ' '.join(line.strip().split("\t")[:-1]) for line in infile  if line != '\n'}
    return data

def write_full_summary(mapped_regions, active_regions, output_file, ref="Mus_musculus"):

    """
    TODO
    """

    with open(output_file, 'w') as outfile:
        header = [ref+'_chr', ref+'_start', ref+'_end', ref+'_activity', 'unique_id']
        for sp in mapped_regions:
            if sp != ref:
                header += [sp+'_coord', sp+'_activity']

        header = '\t'.join(header)
        outfile.write(header+'\n')

        for unique_id in mapped_regions[ref]:

            to_write = ''

            to_write += '\t'.join(mapped_regions[ref][unique_id].split() + [unique_id]) + '\t'

            if unique_id in active_regions[ref]:
                to_write += "active\t"
            else:
                to_write += "inactive\t"

            for sp in mapped_regions:
                if sp != ref:
                    to_write += mapped_regions[sp][unique_id]+'\t'
                    if unique_id in active_regions[sp]:
                        to_write += "active\t"
                    else:
                        to_write += "inactive\t"

            outfile.write(to_write[:-1]+'\n')



if __name__ == '__main__':

    PARSER = argparse.ArgumentParser(description=__doc__,
                                     formatter_class=argparse.RawDescriptionHelpFormatter)

    PARSER.add_argument('-a', '--active_regions', nargs='+', required=True)

    PARSER.add_argument('-m', '--mapped_regions', nargs='+', required=True)

    PARSER.add_argument('-l', '--labels', nargs='+', required=True)

    PARSER.add_argument('-o', '--output', type=str, required=False, default='CrossMap_Summary')

    ARGS = vars(PARSER.parse_args())

    #active regions
    ACTIVE = OrderedDict()
    for LABEL, INPUT_FILE in zip(ARGS["labels"], ARGS["active_regions"]):
        ACTIVE[LABEL] = load_active_region(INPUT_FILE)

    #mapped regions
    MAPPED = OrderedDict()
    for LABEL, INPUT_FILE in zip(ARGS["labels"], ARGS["mapped_regions"]):
        MAPPED[LABEL] = load_mapped_regions(INPUT_FILE)

    #add activity and mapping summary
    write_full_summary(MAPPED, ACTIVE, ARGS["output"], ARGS["labels"][0])
