import argparse


def load_reg(input_file):
    res = {}
    with open(input_file, 'r') as f:
        for line in f:
            line_split = line.strip().split('\t')
            c, start, end, _, _, _, unique_id = line_split #_ are original regions, we could do load them and plot region reduction
            if unique_id not in res:
                res[unique_id] = (c, start, end)
            else:
                lg = int(end) - int(start)
                _, st, e = res[unique_id] 
                lg_prev = int(e) - int(st)
                if lg > lg_prev:
                    res[unique_id] = (c, start, end)
    return res

def write_bed4(bed_dict, output_file, subset=False):
    with open(output_file, 'w') as out:
        for unique_id in bed_dict:
            if not subset or unique_id in subset:
                out.write('\t'.join(bed_dict[unique_id])+'\t'+unique_id+'\n')



if __name__ == '__main__':
    
    PARSER = argparse.ArgumentParser(description=__doc__,
                                     formatter_class=argparse.RawDescriptionHelpFormatter)

    PARSER.add_argument('-i', '--input', type=str, required=True)

    PARSER.add_argument('-o', "--output", type=str, required=True)

    ARGS = vars(PARSER.parse_args())


    MYREG = load_reg(ARGS["input"])

    write_bed4(MYREG, ARGS["output"])