#/usr/bin/env/python


"""
TODO

"""
import sys
import argparse
from collections import OrderedDict


def split_entries_per_species(infile, output_dir):
    """
    Dirty function to split bed summary with regions mapped in x species
    """
    for line in infile:
        header = line.strip().split('\t')
        ref_sp = header[0].replace("_chr", "")
        species = ['_'.join(sp.split('_')[:-1]) for i, sp in enumerate(header[5:]) if i % 2 == 0]
        break

    filenames = [output_dir+'/'+sp+'.bed' for sp in species]

    #TODO use contextlib.ExitStack for this (cleaner solution)
    filedata = OrderedDict({filename: open(filename, 'w') for filename in filenames})

    with open(output_dir+'/'+ref_sp+'.bed', 'w') as out:

        for line in infile:

            line = line.strip().split('\t')
            out.write('\t'.join(line[0:4])+'\n')

            for i, outfile in enumerate(filedata.values()):
                outfile.write('\t'.join(line[5+i*2].split())+'\t'+line[3]+'\n')


    for outfile in filedata.values():
        outfile.close()


if __name__ == '__main__':

    PARSER = argparse.ArgumentParser(description=__doc__,
                                     formatter_class=argparse.RawDescriptionHelpFormatter)

    PARSER.add_argument('infile', nargs='?', type=argparse.FileType('r'), default=sys.stdin)
    PARSER.add_argument('-o', '--output_dir', required=False, default='')

    ARGS = vars(PARSER.parse_args())

    split_entries_per_species(ARGS["infile"], ARGS["output_dir"])

    ARGS["infile"].close()
