#!/usr/bin/env Rscript

library('shipunov')

library("optparse")


########
# ARGS #
########

option_list = list(
  make_option(c("-i", "--input"), type="character"),
  make_option(c("-o", "--out_plot"), type="character")
); 

opt_parser = OptionParser(option_list=option_list);
opt = parse_args(opt_parser);

###############
# LOAD MATRIX #
###############

regMat.quant <- as.matrix(read.delim(opt$input))

###########################
# PLOT SAMPLES DENDROGRAM #
###########################

pdf(opt$out_plot)
clust <- Bclust(t(regMat.quant), method.d="euclidean", method.c="average")
plot(clust)
dev.off()