#/usr/bin/env/python

"""
TODO script to polish

"""
import sys
import argparse

import pandas as pd


if __name__ == '__main__':

    PARSER = argparse.ArgumentParser(description=__doc__,
                                     formatter_class=argparse.RawDescriptionHelpFormatter)

    PARSER.add_argument('-i', '--infile', required=True)
    PARSER.add_argument('-m', '--mapping', required=True)
    PARSER.add_argument('-o', '--output', required=False, default=None)
    ARGS = vars(PARSER.parse_args())

    df = pd.read_csv(ARGS["infile"], sep='\t', names=["chr", "start", "stop", "id", "a", "b", "c"])
    df.drop(["a", "b", "c"], axis=1, inplace=True)

    mapping = pd.read_csv(ARGS["mapping"], sep='\t', names=["chr_ref", "start_ref", "stop_ref", "id"])

    res = mapping.merge(df, on='id', how='right')
    res.drop(["chr", "start", "stop"], axis=1, inplace=True)

    if ARGS["output"]:
        res.to_csv(ARGS["output"], index=False, header=False, sep='\t')

    else:
        res.to_csv(sys.stdout, index=False, header=False, sep='\t')