"""
Snakemake workflow module of the nmdrdmr pipeline.

Step 2 : combine histone marks to predict regulatory elements.
"""

rule promoters:
    """
    Define promoters: overlap between an H3K4me3 reproducible peak and an H3K27ac reproducible peak.
    """
    input:
        k4me3 = CONSENSUS_DIR+"/Consensus_peaks-{species}-{tissue}-H3K4me3.bed",
        k27ac = CONSENSUS_DIR+"/Consensus_peaks-{species}-{tissue}-H3K27ac.bed"
    output: REGMAP_DIR + "/Promoters/Promoters-{species}-{tissue}.bed"
    conda: "envs/bedtools_py.yaml"
    shell:
        "bedtools intersect -f 0.5 -F 0.5 -e -a {input.k4me3} -b {input.k27ac} | bedtools sort > {output}"

rule enhancers:
    """
    Define enhancers: all H3K27ac reproducible peaks not overlapping a promoter.
    """
    input:
        k27ac =  CONSENSUS_DIR+"/Consensus_peaks-{species}-{tissue}-H3K27ac.bed",
        promoters = REGMAP_DIR + "/Promoters/Promoters-{species}-{tissue}.bed"
    output:
        enhancers = REGMAP_DIR + "/Enhancers/Enhancers-{species}-{tissue}.bed"
    conda: "envs/bedtools_py.yaml"
    shell:
        "bedtools intersect -v -a {input.k27ac} -b {input.promoters} | bedtools sort > {output.enhancers}"

rule primed_enhancers:
    """
    Define primed enhancers: all H3K44me1 reproducible peaks not overlapping k27ac nor k4me3 peak.
    """
    input:
        k4me3 = CONSENSUS_DIR+"/Consensus_peaks-{species}-{tissue}-H3K4me3.bed",
        k27ac = CONSENSUS_DIR+"/Consensus_peaks-{species}-{tissue}-H3K27ac.bed",
        k4me1 = CONSENSUS_DIR+"/Consensus_peaks-{species}-{tissue}-H3K4me1.bed"
    output: REGMAP_DIR + "/Primed_enhancers/Primed_enhancers-{species}-{tissue}.bed"
    conda: "envs/bedtools_py.yaml"
    shell:
        "bedtools intersect -v -a {input.k4me1} -b {input.k27ac} {input.k4me3} | bedtools sort > {output}"

