# Code and dataset for the manuscript "Phylogenetic modeling of enhancer shifts in African mole-rats reveals regulatory changes associated with tissue-specific traits"

## Structure of the archive

### Datasets

The data generated in the manuscript is available in the `dataset_sx` folders:

- `dataset_s1/` contains the .bed files for predicted promoters, enhancers and primed enhancers in each of the 4 rodents.

- `dataset_s2/` contains the .bed files for predicted orthologous promoters and enhancers in each of the 4 rodents, along with tables of normalized H3k27ac read densities.

- `dataset_s3/` contains the .bed files for up and down enhancers and promoters in the 4 rodents, as identified by phylogenetic modeling.

- `dataset_s4/` contains the .fasta and .bed files for *de novo* repeat annotations, as well as .bed for non-alignable enhancers and their association with repeats.

### Code

The code to reproduce the main analyses presented in the manuscript is provided in the `code` folder, including:

- A snakemake pipeline in `nmrdmr_pipeline/`, which (i) predicts regulatory elements from histone mark peaks, (ii) identifies orthologous elements across the 4 species and (iii) computes normalized H3k27ac read densities for orthologous elements, from the .bam files.

- R scripts in `phylogenetic_modeling/`, to reproduce simulations and tests for up/down shifts using the [evemodel](https://gitlab.com/sandve-lab/evemodel) R package. 

- A snakemake pipeline in `snakeGREAT/`, to perform functional enrichment on up/down elements in mole-rats, using the [GREAT](http://great.stanford.edu/public/html/) approach.
