library(ggplot2)
library(dplyr)
setwd("~/Documents/Publications/Livestock/Lee_2022A/Genome_Research/Revision")
Dam <- read.delim("~/Documents/Publications/Livestock/Lee_2022A/Genome_Research/Revision/Damona.txt")
str(Dam)
res_sum <- lm(formula = Nunber.of.dnSV.detect ~ Sample.Type.Prob + Repro.Prob + Age.Sire.in.years + Age.Dam.in.years + Sequ.Depth.Prob + Sequ.Depth.Sire + Sequ.Depth.Dam,data = Dam)
summary(res_sum)
res_sum <- lm(formula = Nr.detected.in.Sire ~ Sample.Type.Prob + Repro.Prob + Age.Sire.in.years + Age.Dam.in.years + Sequ.Depth.Prob + Sequ.Depth.Sire + Sequ.Depth.Dam,data = Dam)
summary(res_sum)
res_sum <- lm(formula = Nr.detected.in.Dam ~ Sample.Type.Prob + Repro.Prob + Age.Sire.in.years + Age.Dam.in.years + Sequ.Depth.Prob + Sequ.Depth.Sire + Sequ.Depth.Dam,data = Dam)
summary(res_sum)
res_sum <- lm(formula = Nr.detected.in.Proband ~ Sample.Type.Prob + Repro.Prob + Age.Sire.in.years + Age.Dam.in.years + Sequ.Depth.Prob + Sequ.Depth.Sire + Sequ.Depth.Dam,data = Dam)
summary(res_sum)
ggplot(Dam,aes(x=Sequ.Depth.Sire,y=Nunber.of.dnSV.detect,color=Repro.Prob)) + geom_point() +
  stat_smooth(method=lm)
  
ids <- Dam$Proband
ids
nr <- length(ids)
nr_sim=50
results <- data.frame(SIM=1:(3*nr_sim),REP_TECH=0,PROP=0)
results

for (i in 1:nr_sim){
  #i = 1
  sel <- sample(ids,nr,replace=TRUE) 
  sel_df <- data.frame(Proband=1:nr)
  sel_df$Proband <- sel
  btstrp <- merge(sel_df, Dam, by = 'Proband', all.x= TRUE)
  ivf <- sum(btstrp$Nunber.of.dnSV.detect[btstrp$Repro.Prob == "IVF"])/sum(btstrp$Repro.Prob == "IVF")
  fe <- sum(btstrp$Nunber.of.dnSV.detect[btstrp$Repro.Prob == "Flushed embryo"])/sum(btstrp$Repro.Prob == "Flushed embryo")
  ai <- sum(btstrp$Nunber.of.dnSV.detect[btstrp$Repro.Prob == "AI"])/sum(btstrp$Repro.Prob == "AI")
  #ivf
  #fe
  #ai
  results$SIM[(i-1)*3+1] = i
  results$SIM[(i-1)*3+2] = i
  results$SIM[(i-1)*3+3] = i
  results$REP_TECH[(i-1)*3+1] = "IVF"
  results$REP_TECH[(i-1)*3+2] = "MOET"
  results$REP_TECH[(i-1)*3+3] = "AI"
  results$PROP[(i-1)*3+1] = ivf
  results$PROP[(i-1)*3+2] = fe
  results$PROP[(i-1)*3+3] = ai
}
results
ggplot(results,aes(x=REP_TECH,y=PROP)) + 
  geom_dotplot(binaxis="y", binwidth=0.009, stackdir="center",alpha=0.5) +
  scale_x_discrete(limits=c("AI","MOET","IVF")) +
  xlab("Reproductive technology") +
  ylab("dnSV per offspring") +
  theme_bw() +
  theme(axis.title=element_text(size=24,color="black")) +
  theme(axis.text=element_text(size=20,color="black")) +
  #theme(legend.position="top") +
  #theme(legend.position=c(0.65,0.75)) +
  #theme(legend.title=element_blank()) +
  #theme(legend.text=element_text(size=24,color="black")) + 
  theme(
    panel.grid.major = element_line(colour="white"),
    panel.grid.minor = element_line(colour="white"),
    panel.background = element_rect(fill="white"),
    panel.border = element_rect(colour="black", size=2)) +
  scale_fill_manual(values=c("#252525","#636363","#969696","#cccccc")) 
ggplot(results,aes(x=REP_TECH,y=PROP)) + 
  geom_boxplot()
