#!/bin/bash
#SBATCH -n 1
#SBATCH -c 1
#SBATCH --partition=all_24hrs
#SBATCH --error=error_dnm_filt%A.txt
#SBATCH --job-name=dnm_filt
#SBATCH --mem=10G

#this script will sort out the candidate dnm cnvs
#to be inspected in igv manually

input_vcf='final_results.smoove.square.vcf' #obtained from Smoove population-calling mode
dnm_scan_vcf='final_results.smoove.square.de_novo.vcf'
tmp_trio_id='temporary_sample_id.txt'
output_stem='dnm_candidate'
final_output='results_dnm_candidate_sites'
dnm_filter_script='3_smoove_de_novo_filter.py'


echo "ID CHROM POS END BIN SVLEN QUAL SVTYPE CIPOS95 CIEND95 SU PE SR AC GT_1 GT_2 GT_3 GQ_1 GQ_2 GQ_3 RO_1 RO_2 RO_3 AO_1 AO_2 AO_3 AS_1 AS_2 AS_3 ASC_1 ASC_2 ASC_3 AP_1 AP_2 AP_3 DHBFC_1 DHBFC_2 DHBFC_3 DHFFC_1 DHFFC_2 DHFFC_3" | sed 's/ /\t/g'> ${final_output}.txt
while read line; do
	proband=$(echo $line | cut -d' ' -f1)
	sire=$(echo $line | cut -d' ' -f2)
	dam=$(echo $line | cut -d' ' -f3)
	echo $proband $sire $dam
	echo $proband $sire $dam | sed 's/ /\n/g' > ${tmp_trio_id}
	python ${dnm_filter_script} ${input_vcf} ${proband} ${sire} ${dam}
	bcftools view -i 'FORMAT/DQ==60' -S ${tmp_trio_id} -I ${dnm_scan_vcf} | bcftools query -f '%ID\t%CHROM\t%POS\t%INFO/END\t%CHROM:%POS-%INFO/END\t%INFO/SVLEN\t%QUAL\t%INFO/SVTYPE\t%INFO/CIPOS95\t%INFO/CIEND95\t%INFO/SU\t%INFO/PE\t%INFO/SR\t%INFO/AC[\t%SAMPLE=%GT][\t%GQ][\t%RO][\t%AO][\t%AS][\t%ASC][\t%AP][[\t%DHBFC][\t%DHFFC]\n' >> ${final_output}.txt
	
	rm ${dnm_scan_vcf} ${tmp_trio_id}
done < pedigree.txt 
