# Single Cell Aging Level Estimator (SCALE)

### Abstract
Accurately measuring biological age is crucial for improving healthcare for the elderly population. However, the complexity of aging biology poses challenges in how to robustly estimate aging and in how to interpret the biological significance of the traits used for estimation. Here we present SCALE, a statistical pipeline that quantifies biological aging in different tissues using explainable features learned from literature and single-cell transcriptomic data. Applying SCALE to the Tabula Muris Senis data, we identified tissue-level transcriptomic aging programs for over 20 murine tissues and created a multi-tissue resource of mouse quantitative aging-associated genes. We observed that SCALE correlates well with other age indicators, such as the accumulation of somatic mutations, and can distinguish subtle differences in aging even in cells of the same chronological age. We further compared SCALE with other transcriptomic and methylation ‘clocks’ in data of aging muscle stem cells, Alzheimer’s disease, and heterochronic parabiosis. And we found that SCALE is more generalizable and reliable in assessing biological aging in aging related diseases and rejuvenating interventions. Overall, SCALE represents a significant advancement in our ability to measure aging accurately, robustly, and interpretably in single cells.
