The **Code** directory contains 5 directories sorted as used in the study:
 1. **01_PreMix** - pre-mixture model code - generates integration site ranges and the final outputs are a tables of the numeric-coded sequences that serve as an input for mixture model.
 2. **02_Mix** - mixture model - runs EM algorithm and outputs reports from which data describing the mixture components can be extracted.
 3. **03_PostMix** - post-mixture model code - single shell *extract_PPM code that extract the information about the mixture components
 4. **04_HotSpot** - code creating the data for the analysis of the hotspot targeting
 5. **05_Figures** - R code that creates the Figures found in the publication

Most of the '*.sh*' code is a standole code with its own variables and should be run from the defined directory. Read the comments in each code file to learn more.

---

Code files present in the directories:

add **1.**
 - *Get_IS_coordinates.sh* - describes how coordinates of IS were obtained
 - *Create_Ranges.sh* - creates ranges surrounding IS from IS coordinates
 - *Get_IS_seq.sh* - extracts sequences of ranges from reference genomes (not provided, needs to be obtained separatelly) and transforms nucleotide sequences to numeric sequences used as input for the EM algorithm

add **2.**
 - *MixProductPAPER.cpp.txt* - a C++ code running the EM algorithm. PARAM.GEN and Report.GEN files are output

add **3.**
 - *extract_PPMs.sh* - extracts PPMs and component weights from the EM algorith PARAM.GEN file

add **4.**
 - **CompSeq** - directory with R code that identifies and selects the sequences associted with given mixture component
	       - contains main script (*SeqMemFun.R*) and supportive scripts (*Functions.R*, *Load_mixPPM.R*)
 - *rmsk_to_BED.sh* - transforms rmsk.txt to BED + extract Alu coorinates and save as separated file
 - *RMSK_target.sh* - quantifies targeting of repeats
 - *Map_IS_to_Alu_consensus.sh* - maps component-associated IS to Alu consensus sequence
 - *Extract_Alu_BED.sh* - creates BED file with Alu coordinates
 - *HIV_Alu_target.sh* - locates and counts intra-feature (Alu) IS and creates shuffled controls
 - *Locate_pattern_in_genome.sh* - extracts genome-wide coordinates of the sequence motif
 - *Intersect_pattern_with_feature.sh* - creates files with coordinates of intra-feature motifs
 - *HIV_Alu_motif_target_distance.sh* - calculate distances of IS to the nearest motif

add **5.**
- Directory contains R code used to create Figures present in the publication. The code uses data created by the code from categories **2.** - **4.**. All data needed to create the Figures should be present in '**Data**' and '**Results**' directories.

