# Input

The script input are:

`count_dir` : The directory of counts file generate by GATK ASEReadCounter
command such as :
```shell
java -jar GenomeAnalysisTK.jar -R genome_fasta -T ASEReadCounter -o prefix.readcounts.txt -I bam_file -sites het_vcf_file -U ALLOW_N_CIGAR_READS --minDepth 1 --minMappingQuality 255  --minBaseQuality 10 --allow_potentially_misencoded_quality_scores -L het_vcf_file
```

`map_file` :  This file should be a  tab character delimitation with two columns :
1. The prefix of IP file.
2. The prefix of Input file.
```text
IP	Input
CRR042312	CRR042313
CRR042288	CRR042289
```

`summary_file` : The total read counts of every bam files with two columns :
1. The prefix of file.
2. read counts.
```text
CRR073016	3714308
CRR073021	3487644
```



# Output

The output file (tab character delimitation) include 10 columns :

1. **contig** - The name of the chromosome.
2. **position** - The position of the variant in the chromosome. The first base in a chromosome is numbered 1.
3. **refAllele** - The reference allele in this position.
4. **altAllele** - The alternative allele in this position.
5. **refRPKM_ratio** - m6A level in reference allele = ref_RPKM_IP/ref_RPKM_Input
6. **altRPKM_ratio** - m6A level in alternative allele = alt_RPKM_IP/alt_RPKM_Input
7. **allelicRatio** - refRPKM_ratio / ( refRPKM_ratio + altRPKM_ratio )
8. **pvalue** - The significant level generated by Fisher exact
9. **oddsratio** -  The odds ratio generated by Fisher exact
10. **qvalue** - The False Discovery Rate generated by Benjamini–Hochberg method

```
contig	position	refAllele	altAllele	refRPKM_ratio	altRPKM_ratio	allelicRatio	pvalue	oddsratio	qvalue
chr1	14599	T	A	9.000360365698876	9.732096980796346	0.48046874999999994	0.5816744580730645	0.9296535028752602	0.6155198270115915
chr1	14604	A	G	9.000360365698876	9.732096980796346	0.48046874999999994	0.5816744580730645	0.9296535028752602	0.6155198270115915
```

