# -*- coding: utf-8 -*-
"""
Created on Sun Mar 12 14:07:43 2023

@author: pspea
"""

import pandas as pd

copy_number_filename = ('C:/Gresham/tiny_projects/Project_Grace/relative_depth_DNA_corrected_v3.txt')
df = pd.read_table(copy_number_filename, index_col=0)
cn_dict = df.to_dict('index')

strain_list = ['DGY1728','DGY1734','DGY1736','DGY1740','DGY1744','DGY1747','DGY1751']
#We need to populate the gene list with those genes that are detected in every strain - 
# otherwise there will be misalignement on between genes between strains on the global heatmap

sig_diff_dict = {}


for evo_strain in strain_list:
    if evo_strain != 'DGY1657':
        deseq_results_filename =  ('C:/Gresham/tiny_projects/Project_Grace/insertions/DESeq_inserts_DGY1657_{}.txt').format(evo_strain)
        deseq_results_file = open(deseq_results_filename)
        df = pd.read_table(deseq_results_filename, index_col=0)
        deseq_results = df.to_dict('index')
        

        if evo_strain not in sig_diff_dict:
            sig_diff_dict[evo_strain] = set()

        for gene in deseq_results:
            if gene in cn_dict:
                if evo_strain in cn_dict[gene]:
                    if gene[0] == 'Y' and cn_dict[gene][evo_strain] == 1:
                        sig_diff_dict[evo_strain].add(gene)
                        

                            

for evo_strain in strain_list:
    if evo_strain != 'DGY1657':
        deseq_results_outfilename = ('C:/Gresham/tiny_projects/Project_Grace/insertions/DESeq_for_GSEA_inserts_DGY1657_{}.txt').format(evo_strain)
        deseq_results_outfile = open(deseq_results_outfilename, 'w')
        
        
        deseq_results_filename =  ('C:/Gresham/tiny_projects/Project_Grace/insertions/DESeq_inserts_DGY1657_{}.txt').format(evo_strain)
        deseq_results_file = open(deseq_results_filename)
        

        for line in deseq_results_file:
            if 'pvalue' in line:
                deseq_results_outfile.write(line)
            else:
                gene = line.split('\t')[0]
            
                if gene in sig_diff_dict[evo_strain]:
                    deseq_results_outfile.write(line)
                
        deseq_results_outfile.close()
        deseq_results_file.close()


