aa_protein_lengths <- read.delim("SF4_Hermes_analysis/aa_protein_lengths.tsv", header=FALSE)
calc_insertion_median <- read.delim("SF4_Hermes_analysis/calc_insertion_median.txt")

unity<-merge(aa_protein_lengths,calc_insertion_median, by.x="V2", by.y="X")
write.csv(unity, "SF4_Hermes_analysis/unity.csv")

essential <-read.delim('SF4_Hermes_analysis/Essential_ORFs.txt')

essential_unity <- merge(essential, unity, by.x = "essential_genes", by.y = "V2")

#essential <-read.delim('SF4_Hermes_analysis/Essential_ORFs.txt')

pdf('SF4_Hermes_analysis/Adj.R-squared_DGY1657_insertions.pdf')
plot(log2(unity$X1657_1),log2(unity$X1657_2))
fit <- lm(log2(unity$X1657_2) ~ log2(unity$X1657_1))
summary(fit)
abline(fit)
dev.off()

pdf('SF4_Hermes_analysis/Adj.R-squared_length_insertions.pdf')
plot(log2(unity$V1),log2(unity$median))
fit <- lm(log2(unity$median) ~ log2(unity$V1))
summary(fit)
dev.off()