#Supplemental_Fig_S13
library(scales)
mic_raw <- read.delim("mrna_insertions_cn_ratio_combined.txt")
mic <- na.omit(mic_raw)

mic_cnv<-subset(mic, mic$cn!=1)
plot(log2(mic_cnv$insertions), (mic_cnv$cn), col = alpha("black",0.2))
#

cn1<-subset(mic, mic$cn==1)
cn2<-subset(mic, mic$cn==2)
cn3<-subset(mic, mic$cn==3)
cn4<-subset(mic, mic$cn==4)

median(cn1$insertions)/1
median(cn2$insertions)/2
median(cn3$insertions)/3
median(cn4$insertions)/4

length(cn1$insertions)
length(cn2$insertions)
length(cn3$insertions)
length(cn4$insertions)

pdf("Supplemental_Fig_S13.pdf")
boxplot(log2(cn1$insertions), log2(cn2$insertions),
        log2(cn3$insertions), log2(cn4$insertions)
        , notch=TRUE)
dev.off()