#BiocManager::install("clusterProfiler", version = "3.8")
#BiocManager::install("pathview")
#BiocManager::install("enrichplot")
library(clusterProfiler)
library(enrichplot)
# we use ggplot2 to add x axis labels (ex: ridgeplot)
library(ggplot2)


# SET THE DESIRED ORGANISM HERE
#organism = "org.Sc.sgd.db"
#BiocManager::install(organism, character.only = TRUE)
library(organism, character.only = TRUE)




# reading in data from deseq2
df = read.delim("Supplemental_File_DESeq_for_GSEA/DESeq_Obs_DGY1657_DGY1728.txt",sep='\t', header=TRUE)

# we want the log2 fold change 
original_gene_list <- df$log2FoldChange

# name the vector
names(original_gene_list) <- df$gene

# omit any NA values 
gene_list<-na.omit(original_gene_list)

# sort the list in decreasing order (required for clusterProfiler)
gene_list = sort(gene_list, decreasing = TRUE)

#keytypes(org.Sc.sgd.db)

gse <- gseGO(geneList=gene_list, 
             ont ="BP", 
             keyType = "ENSEMBL", 
             minGSSize = 3, 
             maxGSSize = 800, 
             pvalueCutoff = 0.05, 
             verbose = TRUE, 
             OrgDb = organism, 
             pAdjustMethod = "none")

require(DOSE)
dotplot(gse, showCategory=10, split=".sign") + facet_grid(.~.sign)

#
write.csv(gse, file = "gsea_cds_annotated_1728.csv")
