# -*- coding: utf-8 -*-
"""
Created on Fri Apr 28 12:10:39 2023

@author: pspea
"""
import pandas as pd
import numpy as np

base_dir = ('C:/Gresham/tiny_projects/Project_Grace/Review_GB/growth_curves-20230428T160140Z-001/growth_curves/')

anc_infile_name = ("{}/growth_rates_1657_CCCP.csv").format(base_dir)
evo_infile_name = ("{}/growth_rates_1751_CCCP.csv").format(base_dir)

wt_set = set(['1657'])
anc_mt_set = set(['2559', '2560'])
evo_mt_set = set(['1751'])
dbl_mt_set = set(['2573', '2574'])

def build_W_one_set(infile_name, wt_set, mt_set):
    all_strains = wt_set.union(mt_set)
    print(all_strains)
    
    df = pd.read_table(infile_name, index_col=0, sep=',')
    plate_dict = df.to_dict('index')
    
    wt_rate = []
    mt_rate = []
    
    for well in plate_dict:
        for each in all_strains:
            if each == plate_dict[well]['sample']:
                if plate_dict[well]['Drug'] != 'CCCP':                    
                    rate = float(plate_dict[well]['r'])              
                                    
                    if plate_dict[well]['sample'] in wt_set:
                        wt_rate.append(rate)
                        
                    if plate_dict[well]['sample'] in mt_set:
                        mt_rate.append(rate)
                        
    W_term = np.mean(mt_rate)/np.mean(wt_rate)
    
    return(W_term)   
#
def build_W_two_set(infile_name, wt_set, mt_set):
    W_join_term = []

    for each_mt in mt_set:
        mt_subset = set([each_mt])
        w_term = build_W_one_set(infile_name, wt_set, mt_subset)
        
        W_join_term.append(w_term)
        
    return(W_join_term)
#

def calc_epsilon(wx, Wy_list, Obs_list):
    wy_error = abs(np.std(Wy_list)*wx)
    w_error = np.sqrt((np.std(Obs_list)**2)+wy_error)
    
    epsilon = np.mean(Obs_list) - (np.mean(Wy_list)*wx)
    epsilon_error = abs(w_error*epsilon)
    epsilon_min = epsilon-epsilon_error
    epsilon_max = epsilon+epsilon_error
    
    print(epsilon, epsilon_min, epsilon_max)
    

Wy_list = build_W_two_set(anc_infile_name, wt_set, anc_mt_set)

Wx_list = build_W_one_set(evo_infile_name, wt_set, evo_mt_set)

Obs_list = build_W_two_set(evo_infile_name, wt_set, dbl_mt_set)

calc_epsilon(Wx_list, Wy_list, Obs_list)


        
