#!/usr/bin/env Rscript

library(ggplot2)
library(tidyr)
library(fst)

dfsse <- read.fst('04sse.fst')

plot_ani_sum <- function(bits=bits, k=k, max_error=Inf, squared=T, types=NULL, ani_min=0.7) {
    if(squared) {
      bad_types <- dfsse %>% dplyr::group_by(type) %>%
        dplyr::summarise(max_error=max(sse)) %>% filter(max_error > !!max_error)
    } else {
      bad_types <- dfsse %>% dplyr::group_by(type) %>%
        dplyr::summarise(max_error=max(se)) %>% filter(max_error > !!max_error)
    }

    dfssetmp <- dfsse %>% dplyr::filter(totbits == !!bits & k == !!k & !(type %in% bad_types) & anibin >= ani_min)
    if(!is.null(types)) {
        dfssetmp <- dfssetmp %>% filter(type %in% types)
    }
    if(squared) {
        pl <- ggplot(dfssetmp, aes(x=anibin, color=type, y=sse))
    } else {
        pl <- ggplot(dfssetmp, aes(x=anibin, color=type, y=se))
    }
    pl + geom_point(position=position_dodge(width = 0.01)) +
      labs(title=paste('Sketch total of', as.character(bits), 'bits, k =', k),
           y=paste0(ifelse(squared, 'SSE', 'SE'), '(Est ANI - True ANI)')) +
      theme_bw()
}

pdf(file='10anisumm_16384_27.pdf')
plot_ani_sum(bits=16384, k=27, squared=F)
dev.off()

pdf(file='10anisumm_65536_27.pdf')
plot_ani_sum(bits=65536, k=27, squared=F)
dev.off()

pdf(file='10anisumm_262144_27.pdf')
plot_ani_sum(bits=262144, k=27, squared=F)
dev.off()

pdf(file='10anisumm_1048576_27.pdf')
plot_ani_sum(bits=1048576, k=27, squared=F)
dev.off()
