/*
 * Decompiled with CFR 0.152.
 */
package bi.service.orthoani.main;

import bi.core.bioutil.seq.Seqtools;
import bi.core.util.cli.SimpleCLITemplate;
import bi.core.util.common.Webtools;
import bi.core.util.manager.FileManager;
import bi.core.util.manager.entity.PipelineEntity;
import bi.service.orthoani.main.CalOrthoAni;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.json.JSONObject;

public class main
extends SimpleCLITemplate {
    private String fasta1 = null;
    private String fasta2 = null;
    private String fastaDir = null;
    private String usearchPath = null;
    private String tmpDir = null;
    private String outDir = null;
    private String format = null;
    private String threadsStr = null;
    private Integer threadsInt = null;
    private ArrayList<JSONObject> jarr = new ArrayList();
    private Boolean runMulti = false;
    private static Double version = 1.2;
    private static URI uri;
    private static URI exe;
    private static final String downloadURL = "http://www.ezbiocloud.net/tools/orthoaniu";

    public static void main(String[] args) throws Exception {
        String oldEnv = System.getProperty("maven.profile");
        main exec = new main("java -jar <path to bi-orthoaniu.jar>", args);
        exec.calcOrthoAniUsearch();
        if (oldEnv != null) {
            System.setProperty("maven.profile", oldEnv);
        }
    }

    public main(String usage, String ... args) throws IOException {
        super(usage, args);
        this.printOptions();
        this.configure();
    }

    private void checkVersion() throws IOException {
        Boolean noParams = this.usearchPath == null && this.fastaDir == null && this.fasta1 == null && this.fasta2 == null && this.tmpDir.equals("/tmp/") && this.outDir == null && this.format.equals("list") && this.threadsStr == null;
        if (noParams.booleanValue()) {
            System.out.println("Checking for updates... This may take a while if your computer has no network connection.");
            System.out.println("");
            Double ver = Webtools.getVersionFromURL("http://www.ezbiocloud.net/oau_version", 1000);
            if (ver == null) {
                System.out.println("##########################################################################################");
                System.out.println("OAU v" + version);
                System.out.println("##########################################################################################");
                System.out.println("");
            } else if (ver > version) {
                System.out.println("##########################################################################################");
                System.out.println("");
                System.out.println("A newer version of OAU is available. For best results, please download OAU v" + ver + " at:");
                System.out.println(downloadURL);
                System.out.println("");
                System.out.println("##########################################################################################");
                System.out.println("");
            } else {
                System.out.println("##########################################################################################");
                System.out.println("OAU v" + version);
                System.out.println("##########################################################################################");
                System.out.println("");
            }
        } else {
            System.out.println("##########################################################################################");
            System.out.println("OAU v" + version);
            System.out.println("##########################################################################################");
            System.out.println("");
        }
    }

    private static URI getJarURI() throws URISyntaxException {
        ProtectionDomain domain = main.class.getProtectionDomain();
        CodeSource source = domain.getCodeSource();
        URL url = source.getLocation();
        URI uri = url.toURI();
        return uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static URI getFile(URI where, String fileName) throws ZipException, IOException {
        URI fileURI;
        File location = new File(where);
        if (location.isDirectory()) {
            fileURI = URI.create(where.toString() + fileName);
        } else {
            try (ZipFile zipFile = new ZipFile(location);){
                fileURI = main.extract(zipFile, fileName);
            }
        }
        System.out.println(fileURI.getPath());
        return fileURI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static URI extract(ZipFile zipFile, String fileName) throws IOException {
        File tempFile = File.createTempFile(fileName, "");
        tempFile.deleteOnExit();
        ZipEntry entry = zipFile.getEntry(fileName);
        if (entry == null) {
            throw new FileNotFoundException("Failed to find file: " + fileName + " in archive: " + zipFile.getName());
        }
        InputStream zipStream = zipFile.getInputStream(entry);
        FileOutputStream fileStream = null;
        try {
            fileStream = new FileOutputStream(tempFile);
            byte[] buffer = new byte[1024];
            int i = 0;
            while ((i = zipStream.read(buffer)) != -1) {
                ((OutputStream)fileStream).write(buffer, 0, i);
            }
        }
        finally {
            main.close(zipStream);
            main.close(fileStream);
        }
        return tempFile.toURI();
    }

    private static void close(Closeable stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void calcOrthoAniUsearch() throws URISyntaxException, ZipException, IOException, InterruptedException {
        FileWriter f;
        String resultStr;
        JSONObject pairMapJSON;
        JSONObject mainJSON;
        int i;
        CalOrthoAni ortho = null;
        HashMap<Integer, String> pairMap = new HashMap<Integer, String>();
        ArrayList<String> validFiles = new ArrayList<String>();
        int pairNum = 1;
        String whichOS = System.getProperty("os.name");
        if (whichOS.toLowerCase().indexOf("windows") == -1) {
            Process proc = Runtime.getRuntime().exec("chmod +x " + this.usearchPath);
            proc.waitFor();
        }
        if (this.runMulti.booleanValue()) {
            File directory = new File(this.fastaDir);
            File[] itemList = directory.listFiles();
            for (i = 0; i < itemList.length; ++i) {
                File item1;
                Boolean isValid1;
                if (i == itemList.length - 1 || !(isValid1 = Boolean.valueOf(Seqtools.checkFastaDNA((item1 = itemList[i]).getAbsolutePath()))).booleanValue()) continue;
                if (validFiles.indexOf(item1.getName()) == -1) {
                    validFiles.add(item1.getName());
                }
                for (int j = i + 1; j < itemList.length; ++j) {
                    File item2 = itemList[j];
                    Boolean isValid2 = Seqtools.checkFastaDNA(item2.getAbsolutePath());
                    if (!isValid2.booleanValue()) continue;
                    if (validFiles.indexOf(item2.getName()) == -1) {
                        validFiles.add(item2.getName());
                    }
                    pairMap.put(pairNum, item1.getName() + " | " + item2.getName());
                    System.out.println("Calculating ANI for pair number: " + pairNum);
                    ortho = new CalOrthoAni(item1.getAbsolutePath(), item2.getAbsolutePath(), false);
                    ortho.setUsearchPath(this.usearchPath);
                    ortho.setTmpDirPath(this.tmpDir);
                    if (this.threadsInt != null) {
                        ortho.setThreads(this.threadsInt);
                    }
                    ortho.executeWithUsearch();
                    JSONObject obj = new JSONObject();
                    obj.put("pairNum", pairNum);
                    obj.put("orthoaniValue", ortho.getAniValue());
                    obj.put("alignedLenAvg", ortho.getAlignedLenAvg());
                    obj.put("queryCoverage", ortho.getQueryCoverage());
                    obj.put("subjectCoverage", ortho.getSubjectCoverage());
                    obj.put("queryLength", ortho.getqSeqLen());
                    obj.put("subjectLength", ortho.getsSeqLen());
                    this.jarr.add(obj);
                    ++pairNum;
                }
            }
        } else {
            pairMap.put(pairNum, this.fasta1 + " | " + this.fasta2);
            System.out.println("Calculating ANI for pair number: " + pairNum);
            ortho = new CalOrthoAni(this.fasta1, this.fasta2, false);
            ortho.setUsearchPath(this.usearchPath);
            ortho.setTmpDirPath(this.tmpDir);
            if (this.threadsInt != null) {
                ortho.setThreads(this.threadsInt);
            }
            ortho.executeWithUsearch();
            JSONObject obj = new JSONObject();
            obj.put("pairNum", pairNum);
            obj.put("orthoaniValue", ortho.getAniValue());
            obj.put("alignedLenAvg", ortho.getAlignedLenAvg());
            obj.put("queryCoverage", ortho.getQueryCoverage());
            obj.put("subjectCoverage", ortho.getSubjectCoverage());
            obj.put("queryLength", ortho.getqSeqLen());
            obj.put("subjectLength", ortho.getsSeqLen());
            this.jarr.add(obj);
        }
        if (this.outDir == null) {
            if (this.format.equalsIgnoreCase("list")) {
                this.printSpace(1);
                this.printPairMap(pairMap);
                this.printSpace(3);
                this.printStdout(this.jarr);
            } else if (this.format.equalsIgnoreCase("matrix")) {
                this.printSpace(1);
                this.printFileNames(validFiles);
                this.printSpace(3);
                this.printMatrix(validFiles, pairMap, this.jarr);
            } else {
                mainJSON = new JSONObject();
                pairMapJSON = new JSONObject();
                Set<Integer> keys = pairMap.keySet();
                for (Integer key : keys) {
                    pairMapJSON.put(key.toString(), pairMap.get(key));
                }
                mainJSON.put("pairMap", pairMapJSON);
                mainJSON.put("results", this.jarr);
                System.out.println(mainJSON.toString());
            }
        } else if (this.format.equalsIgnoreCase("list")) {
            String pairMapStr = "";
            resultStr = "";
            pairMapStr = pairMapStr + "# Pair number mappings\npair#\taligned_files\n";
            Set<Integer> keys = pairMap.keySet();
            for (Integer key : keys) {
                pairMapStr = pairMapStr + key + "\t" + pairMap.get(key) + "\n";
            }
            pairMapStr = pairMapStr + "\n\n\n";
            resultStr = resultStr + "# OrthoANIu results as list\npair#\torthoANI_value\tavg_aligned_length\tquery_coverage\tsubject_coverage\tquery_length\tsubject_length\n";
            for (JSONObject obj : this.jarr) {
                resultStr = resultStr + obj.getInt("pairNum") + "\t" + obj.getDouble("orthoaniValue") + "\t" + obj.getInt("alignedLenAvg") + "\t" + obj.getDouble("queryCoverage") + "\t" + obj.getDouble("subjectCoverage") + "\t" + obj.getInt("queryLength") + "\t" + obj.getInt("subjectLength") + "\n";
            }
            try {
                f = new FileWriter(new File(this.outDir));
                f.write(pairMapStr + resultStr);
                f.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (this.format.equalsIgnoreCase("matrix")) {
            String fileMapStr = "";
            resultStr = "";
            fileMapStr = fileMapStr + "# File number mappings\nfile#\tfile name\n";
            for (i = 0; i < validFiles.size(); ++i) {
                fileMapStr = fileMapStr + i + "\t" + validFiles.get(i) + "\n";
            }
            fileMapStr = fileMapStr + "\n\n\n";
            resultStr = resultStr + "# OrthoANIu results as matrix\nMatrix axes are file# from file number mapping, and matrix values are OrthoANI values.\n";
            double[][] matrix = new double[validFiles.size()][validFiles.size()];
            for (JSONObject obj : this.jarr) {
                Integer pair = obj.getInt("pairNum");
                String[] names = pairMap.get(pair).split("\\|");
                Integer idx1 = validFiles.indexOf(names[0].trim());
                Integer idx2 = validFiles.indexOf(names[1].trim());
                double d = obj.getDouble("orthoaniValue");
                matrix[idx2.intValue()][idx1.intValue()] = d;
                matrix[idx1.intValue()][idx2.intValue()] = d;
            }
            String finalStr = ".";
            for (int i2 = 0; i2 < validFiles.size(); ++i2) {
                finalStr = finalStr + "\t" + i2;
                String row = i2 + "";
                for (int j = 0; j < validFiles.size(); ++j) {
                    row = i2 == j ? row + "\t100.0" : row + "\t" + matrix[i2][j];
                }
                resultStr = resultStr + row + "\n";
            }
            resultStr = resultStr + finalStr;
            try {
                FileWriter f2 = new FileWriter(new File(this.outDir));
                f2.write(fileMapStr + resultStr);
                f2.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            mainJSON = new JSONObject();
            pairMapJSON = new JSONObject();
            Set<Integer> keys = pairMap.keySet();
            for (Integer key : keys) {
                pairMapJSON.put(key.toString(), pairMap.get(key));
            }
            mainJSON.put("pairMap", pairMapJSON);
            mainJSON.put("results", this.jarr);
            try {
                f = new FileWriter(new File(this.outDir));
                f.write(mainJSON.toString());
                f.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void printPairMap(HashMap<Integer, String> pairMap) {
        System.out.println("# Pair number mappings");
        System.out.println("pair#\taligned_files");
        Set<Integer> keys = pairMap.keySet();
        for (Integer key : keys) {
            System.out.println(key + "\t" + pairMap.get(key));
        }
    }

    private void printSpace(int lines) {
        for (int i = 0; i < lines; ++i) {
            System.out.println("");
        }
    }

    private void printStdout(ArrayList<JSONObject> jarr) {
        System.out.println("# OrthoANIu results as list");
        System.out.println("pair#\torthoANI_value\tavg_aligned_length\tquery_coverage\tsubject_coverage\tquery_length\tsubject_length");
        for (JSONObject obj : jarr) {
            System.out.println(obj.getInt("pairNum") + "\t" + obj.getDouble("orthoaniValue") + "\t" + obj.getInt("alignedLenAvg") + "\t" + obj.getDouble("queryCoverage") + "\t" + obj.getDouble("subjectCoverage") + "\t" + obj.getInt("queryLength") + "\t" + obj.getInt("subjectLength"));
        }
    }

    private void printFileNames(ArrayList<String> files) {
        System.out.println("# File number mappings");
        System.out.println("file#\tfile name");
        for (int i = 0; i < files.size(); ++i) {
            System.out.println(i + "\t" + files.get(i));
        }
    }

    private void printMatrix(ArrayList<String> files, HashMap<Integer, String> pairMap, ArrayList<JSONObject> jarr) {
        double[][] matrix = new double[files.size()][files.size()];
        for (JSONObject obj : jarr) {
            Integer pairNum = obj.getInt("pairNum");
            String[] names = pairMap.get(pairNum).split("\\|");
            Integer idx1 = files.indexOf(names[0].trim());
            Integer idx2 = files.indexOf(names[1].trim());
            double d = obj.getDouble("orthoaniValue");
            matrix[idx2.intValue()][idx1.intValue()] = d;
            matrix[idx1.intValue()][idx2.intValue()] = d;
        }
        System.out.println("# OrthoANIu results as matrix");
        System.out.println("Matrix axes are file# from file number mapping, and matrix values are OrthoANI values.");
        String finalStr = ".";
        for (int i = 0; i < files.size(); ++i) {
            finalStr = finalStr + "\t" + i;
            String row = i + "";
            for (int j = 0; j < files.size(); ++j) {
                row = i == j ? row + "\t100.0" : row + "\t" + matrix[i][j];
            }
            System.out.println(row);
        }
        System.out.println(finalStr);
    }

    private void calcOrthoAniUsearchStdOut() {
        CalOrthoAni ortho = new CalOrthoAni(this.fasta1, this.fasta2, false);
        ortho.setUsearchPath(this.usearchPath);
        ortho.setTmpDirPath(this.tmpDir);
        ortho.executeWithUsearch();
        System.out.println("orthoANI_value\t" + ortho.getAniValue());
        System.out.println("average_aligned_length\t" + ortho.getAlignedLenAvg());
        System.out.println("query_coverage\t" + ortho.getQueryCoverage());
        System.out.println("subject_coverage\t" + ortho.getSubjectCoverage());
        System.out.println("query_length\t" + ortho.getqSeqLen());
        System.out.println("subject_length\t" + ortho.getsSeqLen());
    }

    private void configure() throws IOException {
        this.usearchPath = this.getOptionValue("upath", null);
        this.fastaDir = this.getOptionValue("fastadir", null);
        this.fasta1 = this.getOptionValue("fasta1", null);
        this.fasta2 = this.getOptionValue("fasta2", null);
        this.tmpDir = this.getOptionValue("tmp", "/tmp/");
        this.outDir = this.getOptionValue("out", null);
        this.format = this.getOptionValue("format", "list");
        this.threadsStr = this.getOptionValue("threads", null);
        this.checkVersion();
        if (this.usearchPath == null) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.setWidth(150);
            formatter.printHelp(this.usage, "---------------------------------------", this.options, "", true);
            this.printSpace(1);
            System.out.println("You must provide a path to the USEARCH program using -u.");
            System.exit(0);
        } else {
            HelpFormatter formatter;
            File uCheck = new File(this.usearchPath);
            boolean exists = uCheck.exists();
            boolean isDirectory = uCheck.isDirectory();
            String absPath = uCheck.getAbsolutePath();
            if (!exists) {
                formatter = new HelpFormatter();
                formatter.setWidth(150);
                formatter.printHelp(this.usage, "---------------------------------------", this.options, "", true);
                this.printSpace(1);
                System.out.println("The provided USEARCH program path does not exist.");
                System.exit(0);
            }
            if (isDirectory) {
                formatter = new HelpFormatter();
                formatter.setWidth(150);
                formatter.printHelp(this.usage, "---------------------------------------", this.options, "", true);
                this.printSpace(1);
                System.out.println("The USEARCH path provided is a directory. Please provide the full path to the USEARCH program.");
                System.exit(0);
            }
            this.usearchPath = absPath;
        }
        Boolean single = this.fasta1 != null && this.fasta2 != null;
        Boolean multi = this.fastaDir != null;
        if (single.booleanValue() && multi.booleanValue()) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.setWidth(150);
            formatter.printHelp(this.usage, "---------------------------------------", this.options, "", true);
            this.printSpace(1);
            System.out.println("Conflicting options provided: -fd, -f1, and -f2 options are all set. Please use only -fd for specifying a directory of fasta files, or use both -f1 and -f2 to specify specific single fasta files for OrthoANIu calculation.");
            System.exit(0);
        } else if (!single.booleanValue() && !multi.booleanValue()) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.setWidth(150);
            formatter.printHelp(this.usage, "---------------------------------------", this.options, "", true);
            this.printSpace(1);
            System.out.println("Insufficient input. Please use only -fd for specifying a directory of fasta files, or use both -f1 and -f2 to specify specific single fasta files for OrthoANIu calculation.");
            System.exit(0);
        } else if (multi.booleanValue()) {
            this.runMulti = true;
        }
        if (!(this.format.equalsIgnoreCase("list") || this.format.equalsIgnoreCase("matrix") || this.format.equalsIgnoreCase("json"))) {
            System.out.println("Received unsupported input for -fmt. Defaulting to list.");
            this.format = "list";
        }
        if (this.threadsStr != null) {
            try {
                this.threadsInt = Integer.parseInt(this.threadsStr);
            }
            catch (NumberFormatException e) {
                System.out.println("Received non-integer value for threads argument. Defaulting to 8.");
            }
        }
    }

    @Override
    protected Options defineOptions() {
        Options options = new Options();
        Option fastaDir = new Option("fd", "fastadir", true, "Path of directory with fasta files (required if f1 and f2 options not given)");
        options.addOption(fastaDir);
        Option fasta1 = new Option("f1", "fasta1", true, "Path of first input fasta file (required if running single OrthoANIu calculation)");
        options.addOption(fasta1);
        Option fasta2 = new Option("f2", "fasta2", true, "Path of second input fasta file (required if running single OrthoANIu calculation)");
        options.addOption(fasta2);
        Option usearchPath = new Option("u", "upath", true, "Path of usearch program (required)");
        options.addOption(usearchPath);
        Option tmpDir = new Option("t", "tmp", true, "Path of temp dir (optional)");
        options.addOption(tmpDir);
        Option outDir = new Option("o", "out", true, "Path of output dir (optional)");
        options.addOption(outDir);
        Option format = new Option("fmt", "format", true, "Output format (optional, default: list, possible options: list, matrix, json)");
        options.addOption(format);
        Option threads = new Option("n", "threads", true, "Number of threads to use (optional, default: 8)");
        options.addOption(threads);
        return options;
    }

    @Override
    protected void init(FileManager mgr, PipelineEntity pipelineEntity, Map<String, Object> pipelineContext) {
    }
}

