/*
 * Decompiled with CFR 0.152.
 */
package bi.service.orthoani.main;

import bi.core.bioutil.domain.DnaSeqDomain;
import bi.core.bioutil.domain.DnaSeqDomainList;
import bi.core.bioutil.seq.FastSeqLoader;
import bi.core.bioutil.wrapper.common.BlastPlusWrapper;
import bi.core.bioutil.wrapper.common.MakeBlastDbWrapper;
import bi.core.bioutil.wrapper.common.USearchWrapper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.DuplicateFormatFlagsException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.RandomStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalOrthoAni {
    private static final Logger log = LoggerFactory.getLogger(CalOrthoAni.class);
    private int threads = 8;
    private boolean isChopped = true;
    public static int CHOP_SIZE = 1020;
    private File qFile;
    private File sFile;
    private DnaSeqDomainList querySeqDomain;
    private DnaSeqDomainList subjectSeqDomain;
    private Map<String, String> qTosMap;
    private Map<String, String> sToqMap;
    private double alignedLenAvg;
    private int qSeqLen;
    private int sSeqLen;
    private Double aniValue;
    private String usearchPath = null;
    private String blastnPath = null;
    private String makeBlastDbPath = null;
    private OrthoAniChopOption chopOption = OrthoAniChopOption.EXCLUDE_UNDER_SIZE;
    private OrthoAniUsearchOption usearchOption = OrthoAniUsearchOption.USEARCH_LOCAL;
    private int minHspLen = 347;
    private File tmpDir = null;
    private float elapsedTime = 0.0f;
    private boolean isTestMode = false;

    public CalOrthoAni(String dirName, boolean isChopped) {
    }

    public CalOrthoAni(String qFileName, String sFileName) {
        this(qFileName, sFileName, true);
    }

    public CalOrthoAni(String qFileName, String sFileName, boolean isChopped) {
        this(new File(qFileName), new File(sFileName), isChopped);
    }

    public CalOrthoAni(File qFile, File sFile) {
        this(qFile, sFile, true);
    }

    public CalOrthoAni(File qFile, File sFile, boolean isChopped) {
        this.qFile = qFile;
        this.sFile = sFile;
        this.isChopped = isChopped;
        log.info("run with " + qFile.getAbsolutePath() + ":" + sFile.getAbsolutePath());
    }

    public Double executeWithUsearch() {
        return this.execute(OrthoAniProgram.USEARCH);
    }

    public Double executeWithBlast() {
        return this.execute(OrthoAniProgram.BLAST);
    }

    public Double execute(OrthoAniProgram program) {
        File queryFile = this.qFile;
        File subjectFile = this.sFile;
        if (!this.isChopped) {
            log.info("input Files will be chopped.");
            queryFile = this.getChoppedFile(this.qFile.getAbsolutePath(), this.chopOption);
            subjectFile = this.getChoppedFile(this.sFile.getAbsolutePath(), this.chopOption);
            log.info("temp chopped query File " + queryFile.getAbsolutePath() + " is generated.");
            log.info("temp chopped subject File " + subjectFile.getAbsolutePath() + " is generated.");
        }
        log.info("Ani Calculated With " + queryFile.getAbsolutePath() + ":" + subjectFile.getAbsolutePath());
        this.loadSeq(queryFile, subjectFile);
        Calendar start = Calendar.getInstance();
        if (program == OrthoAniProgram.BLAST) {
            this.qTosMap = this.executeBlast(queryFile, subjectFile);
            this.sToqMap = this.executeBlast(subjectFile, queryFile);
        } else if (program == OrthoAniProgram.USEARCH) {
            this.qTosMap = this.executeUsearch(queryFile, subjectFile);
            this.sToqMap = this.executeUsearch(subjectFile, queryFile);
        }
        Double ani = null;
        ani = queryFile.length() > subjectFile.length() ? this.getAvgValue(this.querySeqDomain, this.qTosMap, this.sToqMap) : this.getAvgValue(this.subjectSeqDomain, this.sToqMap, this.qTosMap);
        Calendar end = Calendar.getInstance();
        this.elapsedTime = (float)(end.getTimeInMillis() - start.getTimeInMillis()) / 1000.0f;
        if (!this.isTestMode && !this.isChopped) {
            if (queryFile.exists() && queryFile.delete()) {
                log.info("temp chopped query File : " + queryFile.getAbsolutePath() + " is deleted.");
            }
            if (subjectFile.exists() && subjectFile.delete()) {
                log.info("temp chopped subject File : " + subjectFile.getAbsolutePath() + " is deleted.");
            }
        }
        this.aniValue = ani;
        return ani;
    }

    private void loadSeq(File queryFile, File subjectFile) {
        this.querySeqDomain = this.loadSeq(queryFile);
        this.setqSeqLen(this.querySeqDomain.getSizeOfAllContigs());
        log.info("query file has " + this.querySeqDomain.getListSize() + " seqs. loading complete.");
        this.subjectSeqDomain = this.loadSeq(subjectFile);
        this.setsSeqLen(this.subjectSeqDomain.getSizeOfAllContigs());
        log.info("subject file has " + this.subjectSeqDomain.getListSize() + " seqs. loading complete.");
    }

    private DnaSeqDomainList loadSeq(File fastaFile) {
        DnaSeqDomainList seqList = new DnaSeqDomainList();
        FastSeqLoader fsl = new FastSeqLoader();
        fsl.loadSeqFile(fastaFile);
        HashSet<String> titleSet = new HashSet<String>();
        while (fsl.hasNextSeq()) {
            DnaSeqDomain seq = fsl.nextSeq();
            if (titleSet.contains(seq.getTitle())) {
                throw new DuplicateFormatFlagsException("title " + seq.getTitle() + " is duplicated.");
            }
            titleSet.add(seq.getTitle());
            seqList.add(seq);
        }
        fsl.close();
        return seqList;
    }

    private Double getAvgValue(DnaSeqDomainList seqList, Map<String, String> forwardMap, Map<String, String> reverseMap) {
        BigDecimal sum_avg = BigDecimal.ZERO;
        ArrayList<Double> valueList = new ArrayList<Double>();
        for (DnaSeqDomain seq : seqList.getList()) {
            String[] rs;
            String[] fs;
            String revRes;
            String title = seq.getTitle();
            String forRes = forwardMap.get(title);
            if (forRes == null || (revRes = reverseMap.get((fs = forRes.split("\t"))[1])) == null || !(rs = revRes.split("\t"))[1].equals(fs[0])) continue;
            double f_id = Double.valueOf(fs[2]);
            int f_hsp = Integer.valueOf(fs[3]) - Integer.valueOf(fs[4]) - Integer.valueOf(fs[5]);
            int f_aligned = Integer.valueOf(fs[3]) - Integer.valueOf(fs[5]);
            double r_id = Double.valueOf(rs[2]);
            int r_hsp = Integer.valueOf(rs[3]) - Integer.valueOf(rs[4]) - Integer.valueOf(rs[5]);
            int r_aligned = Integer.valueOf(rs[3]) - Integer.valueOf(rs[5]);
            if (f_hsp < this.minHspLen || r_hsp < this.minHspLen) continue;
            this.alignedLenAvg += (double)(f_aligned + r_aligned) / 2.0;
            double nThavg = (f_id + r_id) / 2.0;
            sum_avg = sum_avg.add(BigDecimal.valueOf(f_id)).add(BigDecimal.valueOf(r_id));
            valueList.add(nThavg);
        }
        log.info("hitlist size : " + valueList.size());
        if (valueList.size() == 0) {
            log.error("The number of calculated fragments is zero.");
            return -1.0;
        }
        double avg = sum_avg.divide(BigDecimal.valueOf(valueList.size() * 2), 4, RoundingMode.HALF_DOWN).doubleValue();
        log.info("Orhto ANI value : " + avg);
        return avg;
    }

    private File getChoppedFile(String inFileName, OrthoAniChopOption option) {
        DnaSeqDomainList oriSeqList = FastSeqLoader.importFileToDnaSeqDomainList(inFileName);
        DnaSeqDomainList choppedList = new DnaSeqDomainList();
        HashSet<String> titleSet = new HashSet<String>();
        int index = 0;
        int cnt = 0;
        if (CHOP_SIZE < 0) {
            System.out.println("chopping size must be a positive number.");
            return null;
        }
        block2: for (int i = 0; i < oriSeqList.getListSize(); ++i) {
            String sequence = oriSeqList.getList().get(i).getSequence();
            if (sequence.length() < CHOP_SIZE) continue;
            for (int j = 0; j < sequence.length(); j += CHOP_SIZE) {
                String indexTitle;
                if (titleSet.contains(indexTitle = ++cnt + "")) {
                    throw new DuplicateFormatFlagsException("title " + indexTitle + " is duplicated.");
                }
                titleSet.add(indexTitle);
                if (j + CHOP_SIZE > sequence.length()) {
                    if (option == OrthoAniChopOption.EXCLUDE_UNDER_SIZE) continue block2;
                    if (option == OrthoAniChopOption.INCLUDE_UNDER_SIZE) {
                        choppedList.add(indexTitle, sequence.substring(j));
                        ++index;
                        continue block2;
                    }
                }
                String temp = new String(sequence.substring(j, j + CHOP_SIZE));
                int countN = 0;
                for (int k = 0; k < temp.length(); ++k) {
                    if (temp.charAt(k) != 'N' && temp.charAt(k) != 'n') continue;
                    ++countN;
                }
                if ((double)countN / (double)temp.length() * 100.0 >= 80.0) {
                    ++index;
                    continue;
                }
                choppedList.add(indexTitle, temp);
                ++index;
            }
        }
        String outFileName = inFileName.replace(".fasta", "") + "_" + CHOP_SIZE + ".fasta";
        if (this.tmpDir != null) {
            outFileName = this.tmpDir.getAbsolutePath() + File.separator + new File(inFileName).getName().replace(".fasta", "") + "_" + CHOP_SIZE + ".fasta";
        }
        File outFile = new File(outFileName);
        try {
            choppedList.writeAsFasta(outFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        log.info(outFile.getAbsolutePath() + " is generated.");
        return outFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> executeBlast(File queryFile, File referenceFile) {
        String tempOut = queryFile.getParent() + File.separator + queryFile.getName().replace(".fasta", "") + "_" + referenceFile.getName().replace(".fasta", "") + "_" + RandomStringUtils.randomAlphanumeric(10) + ".bout";
        if (this.tmpDir != null) {
            tempOut = this.tmpDir.getAbsolutePath() + File.separator + queryFile.getName().replace(".fasta", "") + "_" + referenceFile.getName().replace(".fasta", "") + "_" + RandomStringUtils.randomAlphanumeric(10) + ".bout";
        }
        File[] blastDbFiles = this.checkBlastDB(referenceFile);
        BlastPlusWrapper blast = new BlastPlusWrapper();
        if (System.getProperty("os.name").toLowerCase().startsWith("windows")) {
            blast.setProgramPath("/chunlab/tool/blast+/ncbi-blast-2.2.30+/bin/blastn.exe");
        }
        if (this.blastnPath != null) {
            blast.setProgramPath(this.blastnPath);
        }
        blast.setWorkingDir(this.tmpDir);
        blast.setPrintCommand(true);
        blast.setTask(0);
        blast.setInFileName(queryFile.getAbsolutePath());
        blast.setDbFileName(referenceFile.getAbsolutePath());
        blast.setFilterEvalue(1.0E-15);
        blast.setFilterQuerySeq("no");
        blast.addArgument("-xdrop_gap", 150);
        blast.addArgument("-penalty", -1);
        blast.addArgument("-reward", 1);
        blast.addArgument("-outfmt", "6");
        blast.setCoreForMultiThread(this.threads);
        blast.setNumAlignments(1);
        blast.setOutFileName(tempOut);
        blast.exec();
        HashMap<String, String> map = new HashMap<String, String>();
        File tempFile = new File(tempOut);
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(tempFile));
            String line = null;
            while ((line = br.readLine()) != null) {
                String[] s = line.split("\t");
                if (map.get(s[0]) != null) continue;
                map.put(s[0], line);
            }
            IOUtils.closeQuietly(br);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            IOUtils.closeQuietly(br);
        }
        if (!this.isTestMode) {
            if (tempFile.delete()) {
                log.info(tempFile.getAbsolutePath() + " is deleted");
            }
            for (File f : blastDbFiles) {
                if (!f.delete()) continue;
                log.info(f.getAbsolutePath() + " is deleted");
            }
        }
        return map;
    }

    private File[] checkBlastDB(File referenceFile) {
        File ninFile = new File(referenceFile.getAbsolutePath() + ".nin");
        File nhrFile = new File(referenceFile.getAbsolutePath() + ".nhr");
        File nsqFile = new File(referenceFile.getAbsolutePath() + ".nsq");
        File[] blastDbFiles = new File[]{ninFile, nhrFile, nsqFile};
        if (ninFile.exists() && nhrFile.exists() && nsqFile.exists()) {
            return blastDbFiles;
        }
        MakeBlastDbWrapper mbd = new MakeBlastDbWrapper(referenceFile.getAbsolutePath(), MakeBlastDbWrapper.TYPE_DNA);
        if (System.getProperty("os.name").toLowerCase().startsWith("windows")) {
            mbd.setProgramPath("/chunlab/tool/blast+/ncbi-blast-2.2.30+/bin/makeblastdb.exe");
        }
        if (this.makeBlastDbPath != null) {
            mbd.setProgramPath(this.makeBlastDbPath);
        }
        mbd.setOutFileNames(referenceFile.getAbsolutePath());
        mbd.execute();
        if (ninFile.exists() && nhrFile.exists() && nsqFile.exists()) {
            return blastDbFiles;
        }
        throw new NullPointerException("Blast Db Files are failed to generate.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> executeUsearch(File queryFile, File referenceFile) {
        String tempOut = queryFile.getParent() + File.separator + queryFile.getName().replace(".fasta", "") + "_" + referenceFile.getName().replace(".fasta", "") + "_" + RandomStringUtils.randomAlphanumeric(10) + ".uout";
        if (this.tmpDir != null) {
            tempOut = this.tmpDir.getAbsolutePath() + File.separator + queryFile.getName().replace(".fasta", "") + "_" + referenceFile.getName().replace(".fasta", "") + "_" + RandomStringUtils.randomAlphanumeric(10) + ".uout";
        }
        USearchWrapper usearch = new USearchWrapper();
        if (System.getProperty("os.name").toLowerCase().startsWith("windows")) {
            usearch.setProgramPath("/chunlab/tool/usearch/usearch8.1.1861_win32.exe");
        }
        if (this.usearchPath != null) {
            usearch.setProgramPath(this.usearchPath);
        }
        usearch.setWorkingDir(this.tmpDir);
        usearch.setPrintCommand(true);
        usearch.setSeqFileName(queryFile.getAbsolutePath());
        if (this.usearchOption == OrthoAniUsearchOption.USEARCH_LOCAL) {
            usearch.setDBFile(referenceFile.getAbsolutePath());
            usearch.setLocalAlignment();
            usearch.setSequenceIdentity(0.5);
        } else if (this.usearchOption == OrthoAniUsearchOption.USEARCH_GLOBAL) {
            usearch.setDBFile(referenceFile.getAbsolutePath());
            usearch.setGlobalAlignment();
            usearch.setSequenceIdentity(0.5);
        } else if (this.usearchOption == OrthoAniUsearchOption.UBLAST) {
            usearch.setUBlast(referenceFile.getAbsolutePath());
            usearch.setAccel(1.0);
            usearch.setReject(32);
        }
        usearch.setBlastSimpleOutput(tempOut);
        usearch.setStrandBoth();
        usearch.setEvalue(1.0E-15);
        usearch.setHits(1);
        usearch.addArgument("-xdrop_g", 150);
        usearch.addArgument("-mismatch", -1);
        usearch.addArgument("-match", 1);
        usearch.addArgument("-dbaccelpct", 100);
        usearch.addArgument("-qmask", "none");
        usearch.addArgument("-dbmask", "none");
        usearch.setThreads(this.threads);
        usearch.exec();
        HashMap<String, String> map = new HashMap<String, String>();
        File tempFile = new File(tempOut);
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(tempFile));
            String line = null;
            while ((line = br.readLine()) != null) {
                String[] s = line.split("\t");
                if (map.get(s[0]) != null) continue;
                map.put(s[0], line);
            }
            IOUtils.closeQuietly(br);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            IOUtils.closeQuietly(br);
        }
        if (!this.isTestMode && tempFile.delete()) {
            log.info(tempFile.getAbsolutePath() + " is deleted");
        }
        return map;
    }

    public int getThreads() {
        return this.threads;
    }

    public void setThreads(int threads) {
        this.threads = threads;
    }

    public int getCHOP_SIZE() {
        return CHOP_SIZE;
    }

    public void setCHOP_SIZE(int cHOP_SIZE) {
        CHOP_SIZE = cHOP_SIZE;
    }

    public int getMinHspLen() {
        return this.minHspLen;
    }

    public void setMinHspLen(int minHspLen) {
        this.minHspLen = minHspLen;
    }

    public String getUsearchPath() {
        return this.usearchPath;
    }

    public void setUsearchPath(String usearchPath) {
        this.usearchPath = usearchPath;
    }

    public String getBlastnPath() {
        return this.blastnPath;
    }

    public void setBlastnPath(String blastnPath) {
        this.blastnPath = blastnPath;
    }

    public String getMakeBlastDbPath() {
        return this.makeBlastDbPath;
    }

    public void setMakeBlastDbPath(String makeBlastDbPath) {
        this.makeBlastDbPath = makeBlastDbPath;
    }

    public double getAlignedLenAvg() {
        return this.alignedLenAvg;
    }

    public int getqSeqLen() {
        return this.qSeqLen;
    }

    public void setqSeqLen(int qSeqLen) {
        this.qSeqLen = qSeqLen;
    }

    public int getsSeqLen() {
        return this.sSeqLen;
    }

    public void setsSeqLen(int sSeqLen) {
        this.sSeqLen = sSeqLen;
    }

    public Double getAniValue() {
        return this.aniValue;
    }

    public void setAniValue(Double aniValue) {
        this.aniValue = aniValue;
    }

    public Double getQueryCoverage() {
        return this.alignedLenAvg / (double)this.qSeqLen;
    }

    public Double getSubjectCoverage() {
        return this.alignedLenAvg / (double)this.sSeqLen;
    }

    public boolean isTestMode() {
        return this.isTestMode;
    }

    public void setTestMode() {
        this.isTestMode = true;
    }

    public float getElapsedTime() {
        return this.elapsedTime;
    }

    public void setElapsedTime(float elapsedTime) {
        this.elapsedTime = elapsedTime;
    }

    public File getTmpDir() {
        return this.tmpDir;
    }

    public void setTmpDir(File tmpDir) {
        this.tmpDir = tmpDir;
        if (!tmpDir.exists()) {
            tmpDir.mkdirs();
        }
        if (!tmpDir.exists()) {
            throw new NullPointerException("temp directory " + tmpDir.getAbsolutePath() + " is not exists.");
        }
    }

    public String getTmpDirPath() {
        return this.tmpDir.getAbsolutePath();
    }

    public void setTmpDirPath(String tmpDirPath) {
        this.tmpDir = new File(tmpDirPath);
        if (!this.tmpDir.exists()) {
            this.tmpDir.mkdirs();
        }
        if (!this.tmpDir.exists()) {
            throw new NullPointerException("temp directory " + this.tmpDir.getAbsolutePath() + " is not exists.");
        }
    }

    public void setChopOption(OrthoAniChopOption chopOption) {
        this.chopOption = chopOption;
    }

    public void setUsearchOption(OrthoAniUsearchOption usearchOption) {
        this.usearchOption = usearchOption;
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        log.info("Hello!!");
        CalOrthoAni calu = new CalOrthoAni("/chunlab/data/genome/temp/11954.fasta", "/chunlab/data/genome/temp/44129.fasta", false);
        calu.setChopOption(OrthoAniChopOption.INCLUDE_UNDER_SIZE);
        calu.setTmpDirPath("/chunlab/data/genome/temp/");
        log.info("Usearch : " + calu.executeWithUsearch() + "\t" + calu.getAlignedLenAvg() + "\t" + calu.getQueryCoverage() + "\t" + calu.getSubjectCoverage());
        calu = new CalOrthoAni("/chunlab/data/genome/temp/11954.fasta", "/chunlab/data/genome/temp/44129.fasta", false);
        calu.setChopOption(OrthoAniChopOption.EXCLUDE_UNDER_SIZE);
        calu.setTmpDirPath("/chunlab/data/genome/temp/");
        log.info("Usearch : " + calu.executeWithUsearch() + "\t" + calu.getAlignedLenAvg() + "\t" + calu.getQueryCoverage() + "\t" + calu.getSubjectCoverage());
    }

    public static enum OrthoAniUsearchOption {
        USEARCH_LOCAL,
        USEARCH_GLOBAL,
        UBLAST;

    }

    public static enum OrthoAniProgram {
        BLAST,
        USEARCH;

    }

    public static enum OrthoAniChopOption {
        INCLUDE_UNDER_SIZE,
        EXCLUDE_UNDER_SIZE;

    }
}

