/*
 * Decompiled with CFR 0.152.
 */
package bi.core.util.manager;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.springframework.util.StringUtils;

public class FileManager {
    private List<String> jobList;
    private Map<String, Map<String, File>> inFileInfoMap = new Hashtable<String, Map<String, File>>();
    private Map<String, Map<String, File>> outFileInfoMap = new Hashtable<String, Map<String, File>>();
    private Map<String, File> fileMap = new Hashtable<String, File>();
    private List<String> alternativePath = new ArrayList<String>();
    private String primaryPath = null;
    private int startJobEntryIdx = 0;

    public FileManager(List<String> jobList) {
        if (jobList != null) {
            this.jobList = jobList;
            for (String curJobName : jobList) {
                Hashtable curInFileInfoList = new Hashtable();
                Hashtable curOutFileInfoList = new Hashtable();
                this.inFileInfoMap.put(curJobName, curInFileInfoList);
                this.outFileInfoMap.put(curJobName, curOutFileInfoList);
            }
        }
    }

    public void addInitFileInfo(String fileId, String filePath) {
        Map<String, File> curFileMap = this.inFileInfoMap.get(this.jobList.get(0));
        File curFile = new File(filePath);
        curFileMap.put(fileId, curFile);
        this.fileMap.put(fileId, curFile);
    }

    public void addInFileInfo(String jobName, String fileId) {
        try {
            Map<String, File> curFileMap = this.inFileInfoMap.get(jobName);
            File curFile = this.fileMap.get(fileId);
            if (!StringUtils.isEmpty(this.primaryPath) && this.alternativePath.size() > 0 && !curFile.exists() && curFile.getAbsolutePath().startsWith(this.primaryPath)) {
                String curPath = curFile.getAbsolutePath();
                for (String curAPath : this.alternativePath) {
                    String tmpPath = curPath.replace(this.primaryPath, curAPath);
                    File tmpFile = new File(tmpPath);
                    if (!tmpFile.exists()) continue;
                    curFile = tmpFile;
                    break;
                }
            }
            curFileMap.put(fileId, curFile);
        }
        catch (Exception ex) {
            System.out.println(jobName + " : " + fileId);
            ex.printStackTrace();
            throw new RuntimeException();
        }
    }

    public void addOutFileInfo(boolean usePrev, String jobName, String fileId, String filePath) {
        try {
            Map<String, File> curFileMap = this.outFileInfoMap.get(jobName);
            if (curFileMap == null) {
                System.out.println("curFileMap is null");
            }
            File curFile = new File(filePath);
            if (usePrev && !StringUtils.isEmpty(this.primaryPath) && this.alternativePath.size() > 0 && !curFile.exists() && curFile.getAbsolutePath().startsWith(this.primaryPath)) {
                String curPath = curFile.getAbsolutePath();
                for (String curAPath : this.alternativePath) {
                    String tmpPath = curPath.replace(this.primaryPath, curAPath);
                    System.out.println("tmpPath : " + tmpPath);
                    File tmpFile = new File(tmpPath);
                    if (!tmpFile.exists()) continue;
                    curFile = tmpFile;
                    System.out.println(jobName + "]replace file path: " + filePath + " > " + tmpPath);
                    break;
                }
            }
            curFileMap.put(fileId, curFile);
            if (!this.fileMap.containsKey(fileId)) {
                this.fileMap.put(fileId, curFile);
            }
        }
        catch (Exception ex) {
            System.out.println(jobName + " : " + fileId);
            ex.printStackTrace();
            throw new RuntimeException();
        }
    }

    public File getFile(String fileId) {
        return this.fileMap.get(fileId);
    }

    public boolean checkValidation(String nextJobName) throws FileNotFoundException {
        Map<String, File> curFileMap = this.inFileInfoMap.get(nextJobName);
        for (File cur : curFileMap.values()) {
            if (cur.exists()) continue;
            return false;
        }
        return true;
    }

    public boolean checkPostValidation(String curJobName) {
        try {
            Map<String, File> curFileMap = this.outFileInfoMap.get(curJobName);
            for (File cur : curFileMap.values()) {
                if (cur.exists()) continue;
                return false;
            }
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public void printMap() {
        for (String key : this.fileMap.keySet()) {
            System.out.println("KEY:" + key);
        }
    }

    public List<String> getAlternativePath() {
        return this.alternativePath;
    }

    public void setAlternativePath(List<String> alternativePath) {
        this.alternativePath = alternativePath;
    }

    public String getPrimaryPath() {
        return this.primaryPath;
    }

    public void setPrimaryPath(String primaryPath) {
        this.primaryPath = primaryPath;
    }

    public int getStartJobEntryIdx() {
        return this.startJobEntryIdx;
    }

    public void setStartJobEntryIdx(int startJobEntryIdx) {
        this.startJobEntryIdx = startJobEntryIdx;
    }
}

