/*
 * Decompiled with CFR 0.152.
 */
package bi.core.util.exec;

import bi.core.util.common.StringUtil;
import bi.core.util.exec.SimpleExecTemplate;
import bi.core.util.manager.FileManager;
import bi.core.util.manager.entity.ArgumentEntity;
import bi.core.util.manager.entity.ConditionEntity;
import bi.core.util.manager.entity.InFileEntity;
import bi.core.util.manager.entity.InitFileEntity;
import bi.core.util.manager.entity.JobEntity;
import bi.core.util.manager.entity.OutFileEntity;
import bi.core.util.manager.entity.PipelineEntity;
import bi.core.util.manager.entity.WrapperEntity;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class SimpleExecUtil {
    public static File addWrapperArgument(SimpleExecTemplate wrapper, WrapperEntity param, Map<String, Object> pipelineContext, FileManager mgr) {
        wrapper.setWorkingDir(mgr.getFile(param.getWorkDir()));
        List<ArgumentEntity> argumentList = param.getConditoinList() != null ? SimpleExecUtil.getArgumentList(param.getConditoinList(), pipelineContext) : param.getArgumentList();
        String outFileName = param.getOutFile();
        for (ArgumentEntity curArg : argumentList) {
            String value = StringUtil.replacePlaceHolder(pipelineContext, "${", "}", curArg.getValue());
            if (StringUtils.isBlank(value)) {
                throw new RuntimeException("Empty argument!!!");
            }
            wrapper.addArgument(value);
        }
        if (outFileName == null) {
            return null;
        }
        return mgr.getFile(outFileName);
    }

    public static List<ArgumentEntity> getArgumentList(List<ConditionEntity> conditoinList, Map<String, Object> pipelineContext) {
        if (conditoinList != null) {
            for (ConditionEntity cur : conditoinList) {
                if (!((Boolean)pipelineContext.get(cur.getName())).booleanValue()) continue;
                if (cur.getConditoinList() != null) {
                    return SimpleExecUtil.getArgumentList(cur.getConditoinList(), pipelineContext);
                }
                return cur.getArgumentList();
            }
        }
        return null;
    }

    public static List<InFileEntity> getInFileList(List<ConditionEntity> conditoinList, Map<String, Object> pipelineContext) {
        if (conditoinList != null) {
            for (ConditionEntity cur : conditoinList) {
                if (!((Boolean)pipelineContext.get(cur.getName())).booleanValue()) continue;
                if (cur.getConditoinList() != null) {
                    return SimpleExecUtil.getInFileList(cur.getConditoinList(), pipelineContext);
                }
                return cur.getInfileList();
            }
        }
        return null;
    }

    public static List<OutFileEntity> getOutFileList(List<ConditionEntity> conditoinList, Map<String, Object> pipelineContext) {
        if (conditoinList != null) {
            for (ConditionEntity cur : conditoinList) {
                if (!((Boolean)pipelineContext.get(cur.getName())).booleanValue()) continue;
                if (cur.getConditoinList() != null) {
                    return SimpleExecUtil.getOutFileList(cur.getConditoinList(), pipelineContext);
                }
                return cur.getOutFileList();
            }
        }
        return null;
    }

    public static boolean checkDependency(String dependencyString, Map<String, Object> pipelineContext) {
        return StringUtils.isBlank(dependencyString) || (Boolean)pipelineContext.get(dependencyString) != false;
    }

    public static void initFileManager(int startJobEntryIdx, FileManager mgr, Map<String, Object> pipelineContext, PipelineEntity pipelineEntity) {
        SimpleExecUtil.setInitFiles(mgr, pipelineContext, pipelineEntity);
        for (int index = 0; index < pipelineEntity.getJobList().size(); ++index) {
            boolean usePrev = index < startJobEntryIdx;
            JobEntity curJob = pipelineEntity.getJobList().get(index);
            if (!SimpleExecUtil.checkDependency(curJob.getDependency(), pipelineContext)) continue;
            SimpleExecUtil.setInOutFiles(usePrev, curJob, mgr, pipelineContext);
        }
    }

    private static void setInOutFiles(boolean usePrev, JobEntity curJob, FileManager mgr, Map<String, Object> pipelineContext) {
        if (SimpleExecUtil.checkDependency(curJob.getDependency(), pipelineContext)) {
            List<InFileEntity> infileList = curJob.getInput().getConditoinList() != null ? SimpleExecUtil.getInFileList(curJob.getInput().getConditoinList(), pipelineContext) : curJob.getInput().getInfileList();
            for (InFileEntity curInFile : infileList) {
                mgr.addInFileInfo(curJob.getJobId(), curInFile.getFileId());
            }
            List<OutFileEntity> outFileList = curJob.getOutput().getConditoinList() != null ? SimpleExecUtil.getOutFileList(curJob.getOutput().getConditoinList(), pipelineContext) : curJob.getOutput().getOutFileList();
            for (OutFileEntity curOutFile : outFileList) {
                String baseDirId = curOutFile.getBaseDir();
                String filePath = mgr.getFile(baseDirId).getAbsolutePath() + "/" + curOutFile.getValue();
                String value = StringUtil.replacePlaceHolder(pipelineContext, "${", "}", filePath);
                mgr.addOutFileInfo(usePrev, curJob.getJobId(), curOutFile.getFileId(), value);
                pipelineContext.put(curOutFile.getFileId(), mgr.getFile(curOutFile.getFileId()).getAbsolutePath());
            }
        }
    }

    private static void setInitFiles(FileManager mgr, Map<String, Object> pipelineContext, PipelineEntity pipelineEntity) {
        List<InitFileEntity> initFileList = pipelineEntity.getInitFileList();
        for (InitFileEntity cur : initFileList) {
            File curFile = mgr.getFile(cur.getFileId());
            if (!cur.isOptional() && curFile == null) {
                throw new RuntimeException("File Not Found:" + cur.getFileId());
            }
            if (curFile != null) {
                pipelineContext.put(cur.getFileId(), curFile.getAbsolutePath());
                continue;
            }
            System.out.println("Not exist : " + cur.getFileId());
        }
    }

    public static WrapperEntity getWrapperInfo(PipelineEntity pipelineEntity, String jobId, String wrapperName) {
        for (JobEntity curJob : pipelineEntity.getJobList()) {
            if (!curJob.getJobId().equals(jobId)) continue;
            return curJob.getWrapper(wrapperName);
        }
        return null;
    }
}

