/*
 * Decompiled with CFR 0.152.
 */
package bi.core.util.exec;

import bi.core.util.common.StringUtil;
import bi.core.util.exec.ArgFactory;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleExecTemplate {
    private static final Logger log = LoggerFactory.getLogger(SimpleExecTemplate.class);
    protected ProcessBuilder processBuilder;
    protected Process process;
    protected String commandLine = null;
    protected String exec = null;
    protected String argument = null;
    protected File dir = null;
    protected String outResult = null;
    protected String errResult = null;
    protected int exitValue = -1;
    protected List<String> argList = new ArrayList<String>();
    boolean isTest = false;
    boolean printCommand = false;

    public Process getProcess() {
        return this.process;
    }

    public SimpleExecTemplate(String exec) {
        this(exec, null);
    }

    public SimpleExecTemplate(String exec, String argument, File dir) {
        this(exec + " " + argument, dir);
    }

    public SimpleExecTemplate(String commandLine, File dir) {
        this.exec = commandLine;
        this.commandLine = commandLine;
        this.dir = dir;
        this.isTest = Boolean.parseBoolean(System.getProperty("exec.test"));
        this.processBuilder = new ProcessBuilder(new String[0]);
        this.processBuilder.command(commandLine.split(" "));
        this.processBuilder.directory(dir);
        this.processBuilder.redirectErrorStream(true);
    }

    public static void main(String ... args) {
        SimpleExecTemplate exec = new SimpleExecTemplate("ls");
        exec.setWorkingDir(new File("/temp"));
        String out = exec.exec("out.txt");
        System.out.println(out);
    }

    public void addArgument(String name, Object value) {
        this.argList.add(name);
        this.argList.add(String.valueOf(value));
    }

    public void addNoSpaceArgument(String name, Object value) {
        this.argList.add(name + "" + String.valueOf(value));
    }

    public void addArgument(ArgFactory.Argument arg) {
        this.argList.add(arg.getName());
        this.argList.add(String.valueOf(arg.getValue()));
    }

    public void addArgument(String parameter) {
        this.argList.add(parameter);
    }

    public String exec() {
        return this._exec(null);
    }

    public String exec(String outPath) {
        return this._exec(outPath);
    }

    public String exec_err() {
        return this._exec_err(null);
    }

    public String exec_err(String outPath) {
        return this._exec_err(outPath);
    }

    public String execStdOut(String outPath) {
        return this._execStdOut(outPath);
    }

    public void executeNoOutput() {
        try {
            this.process = this.exe();
            if (this.isTest) {
                return;
            }
            this.process.getErrorStream().close();
            this.process.getInputStream().close();
            this.process.getOutputStream().close();
            this.process.waitFor();
        }
        catch (IOException | InterruptedException e) {
            log.error(this.exec + " failed with error:", (Object)e.getMessage(), (Object)e);
            this.errResult = StringUtil.prettyPrintExceptionMessage(e.getMessage(), e);
            throw new RuntimeException(this.errResult, e);
        }
    }

    public BufferedReader executeToBufferedReader() {
        BufferedReader reader = null;
        try {
            this.process = this.exe();
            if (this.isTest) {
                return null;
            }
            reader = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
        }
        catch (IOException e) {
            log.error(this.exec + " failed with error:", (Object)e.getMessage(), (Object)e);
            this.errResult = StringUtil.prettyPrintExceptionMessage(e.getMessage(), e);
            throw new RuntimeException(this.errResult, e);
        }
        return reader;
    }

    public boolean execute() {
        this._exec(null);
        return true;
    }

    public void exec(PrintWriter pw) {
        BufferedReader reader = null;
        try {
            this.process = this.exe();
            if (this.isTest) {
                return;
            }
            reader = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
            String line = null;
            while ((line = reader.readLine()) != null) {
                log.debug(line);
                pw.print(line);
            }
            log.debug("{} end successfully", (Object)this.exec);
            IOUtils.closeQuietly(reader);
        }
        catch (IOException e) {
            log.error(this.exec + " failed with error:", (Object)e.getMessage(), (Object)e);
            this.errResult = StringUtil.prettyPrintExceptionMessage(e.getMessage(), e);
            throw new RuntimeException(this.errResult, e);
        }
        finally {
            IOUtils.closeQuietly(reader);
            IOUtils.closeQuietly(pw);
        }
        IOUtils.closeQuietly(pw);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String _exec_err(String outPath) {
        OutputStream outStream;
        block14: {
            File outFile;
            block13: {
                outStream = null;
                outFile = null;
                if (outPath != null) {
                    outFile = new File(outPath);
                    if (outFile.getParentFile() == null) {
                        outFile = new File(this.dir.getAbsolutePath() + File.separator + outPath);
                    }
                    if (!outFile.getParentFile().exists()) {
                        outFile.getParentFile().mkdirs();
                    }
                    outStream = new FileOutputStream(outFile);
                } else {
                    outStream = new ByteArrayOutputStream();
                }
                this.process = this.exe();
                if (!this.isTest) break block13;
                String string = "test";
                IOUtils.closeQuietly(outStream);
                return string;
            }
            try {
                block16: {
                    block15: {
                        if (outPath == null) break block15;
                        SimpleExecTemplate.copyStream(this.process.getInputStream(), this.process.getErrorStream(), outStream);
                        break block16;
                    }
                    StringBuilder builder = new StringBuilder();
                    BufferedReader reader = null;
                    try {
                        reader = new BufferedReader(new InputStreamReader(this.process.getErrorStream()));
                        String line = null;
                        while ((line = reader.readLine()) != null) {
                            log.trace(line);
                            builder.append(line).append("\n");
                        }
                        this.errResult = SimpleExecTemplate.checkError(this.process.getErrorStream());
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(reader);
                        throw throwable;
                    }
                    IOUtils.closeQuietly(reader);
                    this.outResult = builder.toString();
                }
                this.process.waitFor();
                if (outFile == null) {
                    log.debug("{} end successfully", (Object)this.exec);
                    break block14;
                }
                log.debug("{} created successfully", (Object)outFile.getAbsolutePath());
            }
            catch (Exception e) {
                try {
                    log.error(this.exec + " failed with error:", (Object)e.getMessage(), (Object)e);
                    this.errResult = StringUtil.prettyPrintExceptionMessage(e.getMessage(), e);
                    throw new RuntimeException(this.errResult, e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(outStream);
                    throw throwable;
                }
            }
        }
        IOUtils.closeQuietly(outStream);
        return this.getOut();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String _exec(String outPath) {
        OutputStream outStream;
        block14: {
            File outFile;
            block13: {
                outStream = null;
                outFile = null;
                if (outPath != null) {
                    outFile = new File(outPath);
                    if (outFile.getParentFile() == null) {
                        outFile = new File(this.dir.getAbsolutePath() + File.separator + outPath);
                    }
                    if (!outFile.getParentFile().exists()) {
                        outFile.getParentFile().mkdirs();
                    }
                    outStream = new FileOutputStream(outFile);
                } else {
                    outStream = new ByteArrayOutputStream();
                }
                this.process = this.exe();
                if (!this.isTest) break block13;
                String string = "test";
                IOUtils.closeQuietly(outStream);
                return string;
            }
            try {
                block16: {
                    block15: {
                        if (outPath == null) break block15;
                        SimpleExecTemplate.copyStream(this.process.getInputStream(), this.process.getErrorStream(), outStream);
                        break block16;
                    }
                    StringBuilder builder = new StringBuilder();
                    BufferedReader reader = null;
                    try {
                        reader = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
                        String line = null;
                        while ((line = reader.readLine()) != null) {
                            log.trace(line);
                            builder.append(line).append("\n");
                        }
                        this.errResult = SimpleExecTemplate.checkError(this.process.getErrorStream());
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(reader);
                        throw throwable;
                    }
                    IOUtils.closeQuietly(reader);
                    this.outResult = builder.toString();
                }
                this.process.waitFor();
                if (outFile == null) {
                    log.debug("{} end successfully", (Object)this.exec);
                    break block14;
                }
                log.debug("{} created successfully", (Object)outFile.getAbsolutePath());
            }
            catch (Exception e) {
                try {
                    log.error(this.exec + " failed with error:", (Object)e.getMessage(), (Object)e);
                    this.errResult = StringUtil.prettyPrintExceptionMessage(e.getMessage(), e);
                    throw new RuntimeException(this.errResult, e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(outStream);
                    throw throwable;
                }
            }
        }
        IOUtils.closeQuietly(outStream);
        return this.getOut();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String _execStdOut(String outPath) {
        OutputStream outStream;
        block14: {
            File outFile;
            block13: {
                outStream = null;
                outFile = null;
                if (outPath != null) {
                    outFile = new File(outPath);
                    if (outFile.getParentFile() == null) {
                        outFile = new File(this.dir.getAbsolutePath() + File.separator + outPath);
                    }
                    if (!outFile.getParentFile().exists()) {
                        outFile.getParentFile().mkdirs();
                    }
                    outStream = new FileOutputStream(outFile);
                } else {
                    outStream = new ByteArrayOutputStream();
                }
                this.process = this.exe();
                if (!this.isTest) break block13;
                String string = "test";
                IOUtils.closeQuietly(outStream);
                return string;
            }
            try {
                block16: {
                    block15: {
                        if (outPath == null) break block15;
                        SimpleExecTemplate.copyStream(this.process.getInputStream(), outStream);
                        this.errResult = SimpleExecTemplate.checkError(this.process.getErrorStream());
                        break block16;
                    }
                    StringBuilder builder = new StringBuilder();
                    BufferedReader reader = null;
                    try {
                        reader = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
                        String line = null;
                        while ((line = reader.readLine()) != null) {
                            log.trace(line);
                            builder.append(line).append("\n");
                        }
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(reader);
                        throw throwable;
                    }
                    IOUtils.closeQuietly(reader);
                    this.outResult = builder.toString();
                    this.errResult = SimpleExecTemplate.checkError(this.process.getErrorStream());
                }
                this.process.waitFor();
                if (outFile == null) {
                    log.debug("{} end successfully", (Object)this.exec);
                    break block14;
                }
                log.debug("{} created successfully", (Object)outFile.getAbsolutePath());
            }
            catch (Exception e) {
                try {
                    log.error(this.exec + " failed with error:", (Object)e.getMessage(), (Object)e);
                    this.errResult = StringUtil.prettyPrintExceptionMessage(e.getMessage(), e);
                    throw new RuntimeException(this.errResult, e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(outStream);
                    throw throwable;
                }
            }
        }
        IOUtils.closeQuietly(outStream);
        return this.getOut();
    }

    protected Process exe() throws IOException {
        Process p = null;
        ArrayList<String> cmdList = new ArrayList<String>();
        if (this.argList.size() > 0) {
            String[] s;
            StringBuilder paramBuff = new StringBuilder();
            for (String param : this.argList) {
                paramBuff.append(param).append(" ");
            }
            this.commandLine = this.getExec() + " " + paramBuff.toString();
            for (String cmd : s = this.getExec().split("\\s+")) {
                cmdList.add(cmd);
            }
            cmdList.addAll(this.argList);
            this.processBuilder.command(cmdList);
        }
        log.debug("----------------------------");
        log.debug("cmd :{}", (Object)this.commandLine);
        log.debug("dir :{}", this.dir);
        if (this.printCommand) {
            log.info("----------------------------");
            log.info("cmd :{}", (Object)this.commandLine);
            log.info("dir :{}", this.dir);
            log.info("----------------------------");
        }
        if (this.isTest) {
            log.debug("test mode execute... ");
        } else {
            p = this.processBuilder.start();
        }
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyStream(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[4096];
        try {
            int bytesRead;
            while ((bytesRead = input.read(buffer)) != -1) {
                output.write(buffer, 0, bytesRead);
            }
        }
        finally {
            IOUtils.closeQuietly(input);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyStream(InputStream input, String err, OutputStream output) throws IOException {
        byte[] buffer = new byte[4096];
        try {
            int bytesRead;
            while ((bytesRead = input.read(buffer)) != -1) {
                output.write(buffer, 0, bytesRead);
            }
            output.write(err.getBytes());
        }
        finally {
            IOUtils.closeQuietly(input);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyStream(InputStream input, InputStream err, OutputStream output) throws IOException {
        byte[] buffer = new byte[4096];
        try {
            int bytesRead;
            while ((bytesRead = input.read(buffer)) != -1) {
                output.write(buffer, 0, bytesRead);
            }
            String errResult = SimpleExecTemplate.checkError(err);
            if (!StringUtil.isBlank(errResult)) {
                output.write(errResult.getBytes());
            }
        }
        finally {
            IOUtils.closeQuietly(input);
            IOUtils.closeQuietly(err);
        }
    }

    private static String checkError(InputStream err) throws IOException {
        String errResult = IOUtils.toString(err);
        if (!StringUtil.isBlank(errResult) && StringUtil.containsError(errResult)) {
            log.error(errResult);
            throw new RuntimeException(errResult);
        }
        return errResult;
    }

    public String getExec() {
        return this.exec;
    }

    public String getArgument() {
        if (this.argList.size() > 0) {
            StringBuilder paramBuff = new StringBuilder();
            for (String param : this.argList) {
                paramBuff.append(param).append(" ");
            }
            this.argument = paramBuff.toString();
        }
        return this.argument;
    }

    public String getCommandLine() {
        StringBuilder sb = new StringBuilder();
        for (String param : this.argList) {
            sb.append(param).append(" ");
        }
        return this.getExec() + " " + sb.toString();
    }

    public Integer removeArgument(String arg) {
        Integer n = 0;
        for (int i = 0; i < this.argList.size(); ++i) {
            if (!this.argList.get(i).equals(arg)) continue;
            this.argList.remove(i);
            Integer n2 = n;
            Integer n3 = n = Integer.valueOf(n + 1);
        }
        return n;
    }

    public File getDir() {
        return this.dir;
    }

    public String getOut() {
        if (!StringUtil.isBlank(this.errResult) && StringUtil.containsError(this.errResult)) {
            return this.outResult + "\n(error)\n" + this.errResult;
        }
        return this.outResult;
    }

    public void setWorkingDir(File dir) {
        this.dir = dir;
        this.processBuilder.directory(dir);
    }

    public void initArgument() {
        this.argList = new ArrayList<String>();
    }

    public boolean isPrintCommand() {
        return this.printCommand;
    }

    public void setPrintCommand(boolean printCommand) {
        this.printCommand = printCommand;
    }

    public int getExitValue() {
        return this.exitValue;
    }
}

