/*
 * Decompiled with CFR 0.152.
 */
package bi.core.util.exec;

import java.util.ArrayList;
import java.util.List;

public class ArgFactory {
    private List<Argument> argList = new ArrayList<Argument>();

    public static ArgFactory newInstance() {
        return new ArgFactory();
    }

    public ArgFactory addArg(String option) {
        this.argList.add(new Argument(option, ""));
        return this;
    }

    public ArgFactory addArg(String option, Object value) {
        this.argList.add(new Argument(option, value));
        return this;
    }

    public ArgFactory addChoiceArg(String option, String key, String choice1, Object value1, String choice2, Object value2) {
        Object value = null;
        if (key.equals(choice1)) {
            value = value1;
        } else if (key.equals(choice2)) {
            value = value2;
        } else {
            throw new RuntimeException("arg must be one of [" + choice1 + ", " + choice2 + "]");
        }
        this.argList.add(new Argument(option, value));
        return this;
    }

    public ArgFactory addChoiceArg(String key, String choice1, String option1, String choice2, String option2) {
        String option = null;
        if (key.equals(choice1)) {
            option = option1;
        } else if (key.equals(choice2)) {
            option = option2;
        } else {
            throw new RuntimeException("arg must be one of [" + choice1 + ", " + choice2 + "]");
        }
        this.argList.add(new Argument(option, ""));
        return this;
    }

    public String[] toArray() {
        return this.toString().split(" ");
    }

    public List<Argument> toList() {
        return this.argList;
    }

    public Argument toArg() {
        if (this.argList.size() > 1) {
            throw new RuntimeException("Argument size is not 1. current:" + this.argList.size());
        }
        return this.argList.get(0);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Argument arg : this.argList) {
            builder.append(arg.getName()).append(" ").append(arg.getValue()).append(" ");
        }
        return builder.toString();
    }

    public static class Argument {
        private String name;
        private Object value;

        public Argument(String name, Object value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

