/*
 * Decompiled with CFR 0.152.
 */
package bi.core.util.common;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.DefaultHttpClient;

public class Webtools {
    public static final String s_megaBlastLinkHtml = "<a href=\"http://www.ncbi.nlm.nih.gov/blast/megablast.shtml\">megaBLAST</a>";
    public static final String s_BlastnLinkHtml = "<a href=\"http://www.ncbi.nlm.nih.gov/blast/producttable.shtml\">BLASTN</a>";
    public static final String s_FastaLinkHtml = "<a href=\"http://fasta.bioch.virginia.edu/fasta_www2/fasta_list2.shtml\">FSATA</a>";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downloadFile(String urlFile, String localFileName) {
        OutputStream out = null;
        URLConnection conn = null;
        InputStream in = null;
        try {
            int numRead;
            URL url = new URL(urlFile);
            out = new BufferedOutputStream(new FileOutputStream(localFileName));
            conn = url.openConnection();
            in = conn.getInputStream();
            byte[] buffer = new byte[1024];
            long numWritten = 0L;
            while ((numRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, numRead);
                numWritten += (long)numRead;
            }
            System.out.println(localFileName + "\t" + numWritten);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException ioe) {}
        }
    }

    public static String getPercentHTMLColor_blue_green(float v) {
        if ((double)v >= 1.0) {
            return "#0000FF";
        }
        if ((double)v >= 0.9) {
            return "#0020DE";
        }
        if ((double)v >= 0.8) {
            return "#0041BD";
        }
        if ((double)v >= 0.7) {
            return "#00619C";
        }
        if ((double)v >= 0.6) {
            return "#00827B";
        }
        if ((double)v >= 0.5) {
            return "#00A25A";
        }
        if ((double)v >= 0.4) {
            return "#00B24A";
        }
        if ((double)v >= 0.3) {
            return "#00C339";
        }
        if ((double)v >= 0.2) {
            return "#00D329";
        }
        if ((double)v >= 0.1) {
            return "#00E318";
        }
        return "#00FF00";
    }

    public static String getPercentHTMLColor_blue_green_explain() {
        StringBuffer res = new StringBuffer("");
        res.append("<table cellspacing=\"0\" cellpadding=\"1\" border=\"1\" bordercolordark=\"white\" bordercolorlight=\"gray\"><tbody>");
        res.append("<tr><td bgcolor=\"" + Webtools.getPercentHTMLColor_blue_green(1.0f) + "\">1.0</td><tr>");
        res.append("<tr><td bgcolor=\"" + Webtools.getPercentHTMLColor_blue_green(0.95f) + "\">0.9<= x <1.0</td><tr>");
        res.append("<tr><td bgcolor=\"" + Webtools.getPercentHTMLColor_blue_green(0.85f) + "\">0.8<= x <9.0</td><tr>");
        res.append("<tr><td bgcolor=\"" + Webtools.getPercentHTMLColor_blue_green(0.75f) + "\">0.7<= x <8.0</td><tr>");
        res.append("<tr><td bgcolor=\"" + Webtools.getPercentHTMLColor_blue_green(0.65f) + "\">0.6<= x <7.0</td><tr>");
        res.append("<tr><td bgcolor=\"" + Webtools.getPercentHTMLColor_blue_green(0.55f) + "\">0.5<= x <6.0</td><tr>");
        res.append("<tr><td bgcolor=\"" + Webtools.getPercentHTMLColor_blue_green(0.45f) + "\">0.4<= x <5.0</td><tr>");
        res.append("<tr><td bgcolor=\"" + Webtools.getPercentHTMLColor_blue_green(0.35f) + "\">0.3<= x <4.0</td><tr>");
        res.append("<tr><td bgcolor=\"" + Webtools.getPercentHTMLColor_blue_green(0.25f) + "\">0.2<= x <3.0</td><tr>");
        res.append("<tr><td bgcolor=\"" + Webtools.getPercentHTMLColor_blue_green(0.15f) + "\">0.1<= x <2.0</td><tr>");
        res.append("<tr><td bgcolor=\"" + Webtools.getPercentHTMLColor_blue_green(0.05f) + "\">x <1.0</td><tr>");
        res.append("</tbody></table>");
        return new String(res);
    }

    public static boolean downloadNcbiTaxonomy(String directory) {
        boolean res = true;
        String localFileName = directory + "/taxdump.tar.gz";
        new File(directory + "/taxdump.tar.gz").delete();
        Webtools.downloadFile("ftp://ftp.ncbi.nih.gov/pub/taxonomy/taxdump.tar.gz", localFileName);
        ProcessBuilder pb = null;
        pb = new ProcessBuilder("gzip", "-d", "taxdump.tar.gz");
        System.out.println("ungzip now");
        pb.directory(new File(directory));
        try {
            String x;
            Process process = pb.start();
            process.waitFor();
            pb = new ProcessBuilder("tar", "fvx", "taxdump.tar");
            pb.directory(new File(directory));
            System.out.println("untar now");
            process = pb.start();
            BufferedReader r = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((x = r.readLine()) != null) {
            }
            r.close();
            process.waitFor();
        }
        catch (IOException e) {
            e.printStackTrace();
            res = false;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return res;
    }

    public static String getNcbiLink(String acc) {
        return new String("http://www.ncbi.nlm.nih.gov/entrez/viewer.fcgi?db=nuccore&id=" + acc);
    }

    public static String getPubmedLink(String pubmed_id) {
        return new String("http://www.ncbi.nlm.nih.gov/pubmed/" + pubmed_id);
    }

    public static String getPubmedLink(int pubmed_id) {
        return new String("http://www.ncbi.nlm.nih.gov/pubmed/" + pubmed_id);
    }

    public static String getNcbiLinkHTML(String acc) {
        return new String("<a href=\"http://www.ncbi.nlm.nih.gov/entrez/viewer.fcgi?db=nuccore&id=" + acc + "\">" + acc + "</a>");
    }

    public static String getNcbiGenomeProjectLink(int project_id) {
        return new String("<a href=\"http://www.ncbi.nlm.nih.gov/sites/entrez?Db=genomeprj&Cmd=Retrieve&list_uids=" + project_id + "\">" + project_id + "</a>");
    }

    public static String getSimilarityHTML(double value, double cutoff, String color_str) {
        String sim = String.format("%6.3f", value *= 100.0);
        if (value >= cutoff) {
            sim = "<font color=\"" + color_str + "\">" + sim + "</font>";
        }
        return sim;
    }

    public static String getEuzebyURL_HTML(String name) {
        String res = "<a href=\"" + Webtools.getEuzebyURL(name) + "\">" + name + "</a>";
        return res;
    }

    public static String getEuzebyURL_HTML_IMG(String name) {
        String res = "<a href=\"" + Webtools.getEuzebyURL(name) + "\"><img valign=bottom src=\"img/euzeby.gif\" BORDER=\"0\" ALT=\"Link to J.P. EUZEBY site\"></a>";
        return res;
    }

    public static String getEuzebyURL_HTML_IMG(String name, String target) {
        String res = "<a target=" + target + " href=\"" + Webtools.getEuzebyURL(name) + "\"><img valign=bottom src=\"img/euzeby.gif\" BORDER=\"0\" ALT=\"Link to J.P. EUZEBY site\"></a>";
        return res;
    }

    public static String getEuzebyURL(String name) {
        name = name.trim();
        String[] s = name.split("[\\s]");
        String genus_str = s[0].toLowerCase();
        String species_str = "";
        if (s.length > 1) {
            species_str = s[1].toLowerCase();
        }
        String URL2 = "http://www.bacterio.net/";
        if (s.length == 1) {
            URL2 = "http://www.bacterio.net/" + genus_str + ".html";
        }
        if (s.length > 1) {
            URL2 = "http://www.bacterio.net/" + genus_str + ".html#" + species_str;
        }
        return URL2;
    }

    public static String getDSMZnomenURL(String name) {
        name = name.trim();
        String[] s = name.split("[\\s]");
        String URL2 = "http://www.dsmz.de/microorganisms/bacterial_nomenclature_info.php?genus=" + s[0];
        return URL2;
    }

    public static String getStrainInfoURL_taxon(String name) {
        String URL2 = "http://www.straininfo.net/taxa/search?q=" + name;
        return URL2;
    }

    public static String getKeggURL(String KO_number) {
        String URL2 = "http://www.genome.jp/dbget-bin/www_bget?ko:" + KO_number;
        return URL2;
    }

    public static String getEggNogURL_tree(String eggnog_id) {
        String URL2 = "http://eggnogapi.embl.de/nog_data/html/tree/" + eggnog_id;
        return URL2;
    }

    public static String getCultureCollectionURL(String strain) {
        if (strain == null) {
            return null;
        }
        String ret_str = null;
        String[] str = strain.split(" ");
        if (str.length < 2) {
            return null;
        }
        if (str[0].equals("ATCC")) {
            ret_str = "http://www.atcc.org/ATCCAdvancedCatalogSearch/ProductDetails/tabid/452/Default.aspx?ATCCNum=" + str[1] + "&Template=bacteria";
        }
        if (str[0].equals("LMG")) {
            ret_str = "http://bccm.belspo.be/db/lmg_strain_details.php?NUM=" + str[1];
        }
        if (str[0].equals("JCM")) {
            ret_str = "http://www.jcm.riken.jp/cgi-bin/jcm/jcm_number?JCM=" + str[1];
        }
        if (str[0].equals("NBRC")) {
            String temp = "";
            for (int i = 0; i < 8 - str[1].length(); ++i) {
                temp = temp + "0";
            }
            ret_str = "http://www.nbrc.nite.go.jp/NBRC2/NBRCCatalogueDetailServlet?ID=NBRC&CAT=" + temp + str[1];
        }
        if (str[0].equals("DSM")) {
            ret_str = "https://www.dsmz.de/catalogues/details/culture/dsm-" + str[1] + ".html";
        } else if (str[0].equals("KCTC")) {
            ret_str = "http://kctc.kribb.re.kr/_KTC/SEARCH/M/SearchView.aspx?sn=" + str[1];
        } else if (str[0].equals("CCUG")) {
            ret_str = "http://www.ccug.se/default.cfm?page=search_record.cfm&ccugno=" + str[1];
        } else if (str[0].equals("CECT")) {
            ret_str = "http://www.cect.org/english/vstrn.php?cect=" + str[1];
        }
        return ret_str;
    }

    public static String get_table_header_html_admin() {
        return "<table class=\"general\" border=\"1\" bordercolordark=\"white\" bordercolorlight=\"gray\" cellspacing=\"0\" cellpadding=\"1\" bgcolor=\"#F3F4D2\"><tbody>";
    }

    public static String get_ncbi_genome_project_url(int gpid) {
        return "http://www.ncbi.nlm.nih.gov/bioproject/" + gpid;
    }

    public static String get_ncbi_genome_project_url(String gpid) {
        return "http://www.ncbi.nlm.nih.gov/bioproject/" + gpid;
    }

    public static String downloadMgRastFile(String dbId, String destFilePath) {
        DefaultHttpClient httpclient = new DefaultHttpClient();
        try {
            HttpHost target = new HttpHost("api.metagenomics.anl.gov", 80, "http");
            HttpGet getRequest = new HttpGet("/1/download/mgm" + dbId + "?file=100.1");
            HttpResponse httpResponse = httpclient.execute(target, getRequest);
            HttpEntity entity = httpResponse.getEntity();
            if (entity != null) {
                InputStream stream = entity.getContent();
                File destFile = new File(destFilePath);
                FileUtils.copyInputStreamToFile(stream, destFile);
            }
            String string = destFilePath;
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            httpclient.getConnectionManager().shutdown();
        }
    }

    public static String downloadMgRastMetaData(String dbId, String destFilePath) {
        try {
            URL url = new URL("http://metagenomics.anl.gov/metagenomics.cgi?page=DownloadMetagenome&action=download_md&filename=mgm" + dbId + ".metadata.txt");
            File f = new File(destFilePath);
            FileUtils.copyURLToFile(url, f);
            return destFilePath;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Double getVersionFromURL(String urlStr) {
        try {
            URL url = new URL(urlStr);
            InputStream is = url.openStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            String line = null;
            line = br.readLine();
            if (line != null) {
                Double ver = Double.valueOf(line.trim());
                return ver;
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Double getVersionFromURL(String urlStr, Integer timeout) throws IOException {
        BufferedReader br;
        InputStream is;
        HttpURLConnection conn;
        block8: {
            Double d;
            block7: {
                URL url = null;
                conn = null;
                is = null;
                br = null;
                try {
                    url = new URL(urlStr);
                    conn = (HttpURLConnection)url.openConnection();
                    HttpURLConnection.setFollowRedirects(false);
                    conn.setRequestMethod("GET");
                    conn.setConnectTimeout(timeout);
                    conn.setReadTimeout(timeout);
                    conn.connect();
                    is = conn.getInputStream();
                    br = new BufferedReader(new InputStreamReader(is));
                    String line = null;
                    line = br.readLine();
                    if (line != null) {
                        Double ver;
                        d = ver = Double.valueOf(line.trim());
                        IOUtils.closeQuietly(is);
                        break block7;
                    }
                    IOUtils.closeQuietly(is);
                    break block8;
                }
                catch (Exception e) {
                    Double d2 = null;
                    return d2;
                }
            }
            IOUtils.closeQuietly(br);
            if (conn == null) return d;
            conn.disconnect();
            return d;
        }
        IOUtils.closeQuietly(br);
        if (conn == null) return null;
        conn.disconnect();
        return null;
        finally {
            IOUtils.closeQuietly(is);
            IOUtils.closeQuietly(br);
            if (conn != null) {
                conn.disconnect();
            }
        }
    }
}

