/*
 * Decompiled with CFR 0.152.
 */
package bi.core.util.common;

import bi.core.util.common.StringUtil;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.sql.Date;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Locale;
import java.util.TreeMap;

public class Tools {
    public static String print_MC_accession_list(String header, int start, int end) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = start + 100000; i <= end + 100000; ++i) {
            String str = header + String.valueOf(i).substring(1);
            list.add(str);
        }
        StringBuffer res = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            res.append((String)list.get(i) + "\n");
        }
        return new String(res);
    }

    public static long getCpuTime() {
        ThreadMXBean bean = ManagementFactory.getThreadMXBean();
        return bean.isCurrentThreadCpuTimeSupported() ? bean.getCurrentThreadCpuTime() : 0L;
    }

    public static long getUserTime() {
        ThreadMXBean bean = ManagementFactory.getThreadMXBean();
        return bean.isCurrentThreadCpuTimeSupported() ? bean.getCurrentThreadUserTime() : 0L;
    }

    public static long getSystemTime() {
        ThreadMXBean bean = ManagementFactory.getThreadMXBean();
        return bean.isCurrentThreadCpuTimeSupported() ? bean.getCurrentThreadCpuTime() - bean.getCurrentThreadUserTime() : 0L;
    }

    public static String checkNullForSQL(String str) {
        if (str == null) {
            return null;
        }
        if ((str = str.trim()).isEmpty()) {
            return null;
        }
        if (str.equalsIgnoreCase("null")) {
            return null;
        }
        return str;
    }

    public static String getNullString(String str) {
        if (str == null) {
            return "";
        }
        if (str.equalsIgnoreCase("null")) {
            return "";
        }
        if (str.equalsIgnoreCase("&nbsp;")) {
            return "";
        }
        return str;
    }

    public static String getNullStringForCsv(String str) {
        if (str == null) {
            return "";
        }
        if (str.equalsIgnoreCase("null")) {
            return "";
        }
        str = str.replaceAll("\"", "`");
        return "\"" + str + "\"";
    }

    public static String getNullString(Double value) {
        if (value == null) {
            return "";
        }
        return value + "";
    }

    public static String getNullDoubleWithMinusOne(Double value) {
        if (value == null) {
            return "";
        }
        if (value == -1.0) {
            return "";
        }
        return value + "";
    }

    public static String getNullString(Integer value) {
        if (value == null) {
            return "";
        }
        return value + "";
    }

    public static String getStringSQL(String str) {
        if (str == null) {
            return null;
        }
        if ((str = str.trim()).equalsIgnoreCase("null")) {
            return null;
        }
        return str;
    }

    public static String getNullString_HTML(String str) {
        if (str == null) {
            return "&nbsp;";
        }
        if (str.equalsIgnoreCase("null")) {
            return "&nbsp;";
        }
        return str;
    }

    public static String getNullString_HTML(Date str) {
        if (str == null) {
            return "&nbsp;";
        }
        return String.valueOf(str);
    }

    public static String getNullString_HTML(int val) {
        if (val == -1) {
            return "&nbsp;";
        }
        return String.valueOf(val);
    }

    public static String getNullString_HTML(double val) {
        if (val == -1.0) {
            return "&nbsp;";
        }
        return String.valueOf(val);
    }

    public static char[] padEndGaps(char[] seq, char fill) {
        int i;
        for (i = 0; i < seq.length && seq[i] == '-'; ++i) {
            seq[i] = fill;
        }
        for (i = seq.length - 1; i > -1 && seq[i] == '-'; --i) {
            seq[i] = fill;
        }
        return seq;
    }

    public static void printArrayList(ArrayList<Object> list) {
        for (int i = 0; i < list.size(); ++i) {
            System.out.println(i + " = " + list.get(i));
        }
    }

    public static boolean getBoolean(String value) {
        if (value == null) {
            return false;
        }
        if (value.equals("true")) {
            return true;
        }
        if (value.equals("false")) {
            return false;
        }
        if (value.equals("on")) {
            return true;
        }
        if (value.equals("off")) {
            return false;
        }
        return false;
    }

    public static ArrayList<String> getCountryList() {
        ArrayList<String> res = new ArrayList<String>();
        Locale[] loc = Locale.getAvailableLocales();
        TreeMap<String, String> countryMap = new TreeMap<String, String>();
        for (int i = 0; i < loc.length; ++i) {
            String curCountry = loc[i].getDisplayCountry(Locale.ENGLISH);
            if (curCountry.length() < 2) continue;
            countryMap.put(curCountry, curCountry);
        }
        countryMap.put("Malaysia", "Malaysia");
        countryMap.put("Philippines", "Philippines");
        countryMap.put("Pakistan", "Pakistan");
        countryMap.put("Ethiopia", "Ethiopia");
        countryMap.put("Indonesia", "Indonesia");
        countryMap.put("Mongolia", "Mongolia");
        countryMap.put("Other countries", "Other countries");
        Iterator itr = countryMap.keySet().iterator();
        while (itr.hasNext()) {
            res.add((String)itr.next());
        }
        return res;
    }

    public static long getTimeStampNow() {
        java.util.Date date = new java.util.Date();
        return date.getTime();
    }

    public static String getTimeString(long stamp) {
        java.util.Date date = new java.util.Date(stamp);
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        String timeStr = "" + calendar.get(1) + "-" + (calendar.get(2) + 1) + "-" + calendar.get(5) + " " + calendar.get(11) + ":" + calendar.get(12);
        return timeStr;
    }

    public static String getDateString(long stamp) {
        java.util.Date date = new java.util.Date(stamp);
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        String res = "" + calendar.get(1) + "-" + (calendar.get(2) + 1) + "-" + calendar.get(5) + " " + calendar.get(11);
        return res;
    }

    public static ArrayList<String> MultiLines2List(String multi_lines) {
        ArrayList<String> res = new ArrayList<String>();
        StringReader sr = new StringReader(multi_lines.trim());
        BufferedReader br = new BufferedReader(sr);
        String line = null;
        try {
            while ((line = br.readLine()) != null && (line = line.trim()).length() != 0) {
                res.add(line);
            }
            br.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return res;
    }

    public static String padString(String s, int n, char c, boolean paddingLeft) {
        char[] pad = new char[n];
        for (int i = 0; i < n; ++i) {
            pad[i] = c;
        }
        s = paddingLeft ? new String(pad) + s : s + new String(pad);
        return s;
    }

    public static void close(Closeable c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static double mean(double[] array) {
        double sum = 0.0;
        for (int i = 0; i < array.length; ++i) {
            sum += array[i];
        }
        return sum / (double)array.length;
    }

    public static double max(double[] array) {
        double max = -1.0E9;
        for (int i = 0; i < array.length; ++i) {
            if (!(max < array[i])) continue;
            max = array[i];
        }
        return max;
    }

    public static double mean(ArrayList<Integer> array) {
        double sum = 0.0;
        for (int i = 0; i < array.size(); ++i) {
            sum += (double)array.get(i).intValue();
        }
        return sum / (double)array.size();
    }

    public static double median(ArrayList<Integer> values) {
        Collections.sort(values);
        if (values.size() % 2 == 1) {
            return values.get((values.size() + 1) / 2 - 1).intValue();
        }
        double lower = values.get(values.size() / 2 - 1).intValue();
        double upper = values.get(values.size() / 2).intValue();
        return (lower + upper) / 2.0;
    }

    public static double median(double[] m_ori) {
        double[] m = (double[])m_ori.clone();
        Arrays.sort(m);
        int middle = m.length / 2;
        if (m.length % 2 == 1) {
            return m[middle];
        }
        return (m[middle - 1] + m[middle]) / 2.0;
    }

    public static double standardDeviation(double[] array, int option) {
        if (array.length < 2) {
            return Double.NaN;
        }
        double sum = 0.0;
        double sd = 0.0;
        double meanValue = Tools.mean(array);
        for (int i = 0; i < array.length; ++i) {
            double diff = array[i] - meanValue;
            sum += diff * diff;
        }
        sd = Math.sqrt(sum / (double)(array.length - option));
        return sd;
    }

    public static double standardDeviation(ArrayList<Integer> array, int option) {
        if (array.size() < 2) {
            return Double.NaN;
        }
        double sum = 0.0;
        double sd = 0.0;
        double meanValue = Tools.mean(array);
        for (int i = 0; i < array.size(); ++i) {
            double diff = (double)array.get(i).intValue() - meanValue;
            sum += diff * diff;
        }
        sd = Math.sqrt(sum / (double)(array.size() - option));
        return sd;
    }

    public static ArrayList<String> getAccessionList(String acc_list) {
        if (acc_list == null) {
            return null;
        }
        String[] s = acc_list.trim().split("\\|");
        ArrayList<String> res = new ArrayList<String>();
        for (int i = 0; i < s.length; ++i) {
            res.add(s[i]);
        }
        return res;
    }

    public static String trim_quotation(String str) {
        String res = str;
        if (res.startsWith("\"")) {
            res = res.substring(1);
        }
        if (res.endsWith("\"")) {
            res = res.substring(0, res.length() - 1);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void filecopy(String inFile, String outFile) {
        File srcFile = new File(inFile);
        FileInputStream is = null;
        FileOutputStream os = null;
        AbstractInterruptibleChannel fcin = null;
        AbstractInterruptibleChannel fcout = null;
        try {
            is = new FileInputStream(srcFile);
            os = new FileOutputStream(outFile);
            fcin = is.getChannel();
            fcout = os.getChannel();
            long size = ((FileChannel)fcin).size();
            ((FileChannel)fcin).transferTo(0L, size, (WritableByteChannel)((Object)fcout));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                fcout.close();
                fcin.close();
                os.close();
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean deleteDirectory(File path) {
        File[] files;
        if (!path.exists()) {
            return false;
        }
        for (File file : files = path.listFiles()) {
            if (file.isDirectory()) {
                Tools.deleteDirectory(file);
                continue;
            }
            file.delete();
        }
        return path.delete();
    }

    public static String convertIntArrayToString(ArrayList<Integer> list) {
        if (list == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            if (i == 0) {
                sb.append(list.get(i));
                continue;
            }
            sb.append("|" + list.get(i));
        }
        return new String(sb);
    }

    public static byte[] getBinaryFromIntegerList(ArrayList<Integer> list) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            if (i == 0) {
                sb.append(list.get(i) + "");
                continue;
            }
            sb.append(":" + list.get(i));
        }
        return StringUtil.gzip(new String(sb));
    }

    public static ArrayList<Integer> getIntegerListFromBinary(byte[] data) {
        String text = StringUtil.ungzip(data);
        String[] s = text.split(":");
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (String str : s) {
            list.add(Integer.valueOf(str));
        }
        return list;
    }

    public static String toDecimalFormat(int decimalValue) {
        if (decimalValue == 0) {
            return "";
        }
        DecimalFormat decimalFormat = new DecimalFormat("#,###,###");
        return decimalFormat.format(decimalValue);
    }

    public static String toLongFormat(long longValue) {
        if (longValue == 0L) {
            return "";
        }
        DecimalFormat decimalFormat = new DecimalFormat("#,###,###");
        return decimalFormat.format(longValue);
    }

    public static String toDoubleFormat(double doubleValue) {
        if (doubleValue == 0.0) {
            return "";
        }
        DecimalFormat decimalFormat = new DecimalFormat("#.##");
        return decimalFormat.format(doubleValue);
    }

    public static void append2Csv(StringBuilder sb, String str, boolean isFirst) {
        if (str == null) {
            str = "";
        }
        if ((str = str.replaceAll("\n", "").replaceAll("\"", "`").trim()).equalsIgnoreCase("null")) {
            str = "";
        }
        if (isFirst) {
            sb.append("\"" + str + "\"");
        } else {
            sb.append(",\"" + str + "\"");
        }
    }

    public static String replaceSequencialSemicolon(String strWithSemicolons) {
        if (strWithSemicolons == null) {
            return "";
        }
        while (strWithSemicolons.indexOf(";;") != -1) {
            if (strWithSemicolons.indexOf(";;") == -1) continue;
            strWithSemicolons = strWithSemicolons.replaceAll(";;", ";");
        }
        return strWithSemicolons;
    }
}

