/*
 * Decompiled with CFR 0.152.
 */
package bi.core.util.common;

import bi.core.util.common.StringConsts;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.sql.Blob;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.sql.rowset.serial.SerialBlob;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang.text.StrSubstitutor;

public class StringUtil {
    private static final String NULL_STRING = "null";
    private static String ERR_PATTERN_ERROR = "error";
    private static String ERR_PATTERN_EXCEPTION = "exception";

    public static String replacePlaceHolder(Map properties, String placeHolderPrefix, String placeHolderSuffix, String source) {
        if ((source = StringUtil.removeNewLine(source)) != null) {
            StrSubstitutor sub = new StrSubstitutor(properties, placeHolderPrefix, placeHolderSuffix);
            return sub.replace(source);
        }
        return null;
    }

    public static String prettyPrintExceptionMessage(String message, Exception e) {
        String exceptionMessage = e.getMessage();
        String rootCauseMessage = ExceptionUtils.getRootCauseMessage(e);
        if (rootCauseMessage.contains("(root cause)")) {
            rootCauseMessage = "";
        }
        return exceptionMessage + "\n <p>(root cause)<p>\n" + rootCauseMessage;
    }

    public static String getStackTrace(Exception e) {
        e.printStackTrace();
        String result = null;
        StringWriter stw = new StringWriter();
        PrintWriter pw = new PrintWriter(stw);
        e.printStackTrace(pw);
        result = StringUtil.newKrString(stw.toString());
        IOUtils.closeQuietly(stw);
        IOUtils.closeQuietly(pw);
        return result;
    }

    public static String byteArrayToKrString(ByteArrayOutputStream stream) {
        try {
            return stream.toString("EUC-KR");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return stream.toString();
        }
    }

    public static String newKrString(String str) {
        try {
            return new String(str.getBytes(), "EUC-KR");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return str;
        }
    }

    public static boolean isBlank(String source) {
        return source != null && NULL_STRING.equalsIgnoreCase(source.trim()) || StringUtils.isBlank(source);
    }

    public static String cleanNull(String source) {
        if (StringUtil.isBlank(source)) {
            return "";
        }
        return source;
    }

    public static String getCleanParameter(String name, HttpServletRequest request) {
        return StringUtil.cleanNull(request.getParameter(name));
    }

    public static boolean isNothing(String source) {
        return source != null && "-".equalsIgnoreCase(source.trim()) || StringUtils.isBlank(source);
    }

    public static String removeNewLine(String in) {
        return in.replaceAll("(\\r|\\n|\\r\\n|\t)", " ");
    }

    public static List<String> commaSequenceToList(String commaSequence) {
        String[] secList;
        ArrayList<String> result = new ArrayList<String>();
        for (String sec : secList = commaSequence.split(",")) {
            result.add(sec.trim());
        }
        return result;
    }

    public static String generateRandomId(int size) {
        int min = (int)Math.pow(10.0, size - 1);
        int max = (int)Math.pow(10.0, size) - 1;
        Random rand = new Random();
        return String.valueOf(rand.nextInt(max - min + 1) + min);
    }

    public static boolean containsError(String source) {
        if (source != null) {
            String temp = source.toLowerCase();
            return temp.contains(ERR_PATTERN_ERROR) || temp.contains(ERR_PATTERN_EXCEPTION);
        }
        return false;
    }

    public static String[] toArray(String ... values) {
        return values;
    }

    public static String deleteLastChar(String source) {
        if (source.length() > 0) {
            return source.substring(0, source.length() - 1);
        }
        return source;
    }

    public static String deleteLastChar(String source, int number) {
        for (int i = 0; i < number; ++i) {
            source = StringUtil.deleteLastChar(source);
        }
        return source;
    }

    public static String dashToZero(String source) {
        if (source == null) {
            return "0";
        }
        if (source.equals("-")) {
            return "0";
        }
        return source;
    }

    public static String decimalFormat(String format, int number) {
        DecimalFormat decimal = new DecimalFormat(format);
        return decimal.format(number);
    }

    public static String commaSeparatedString(List<String> source) {
        StringBuilder builder = new StringBuilder();
        for (String item : source) {
            builder.append(item).append(",");
        }
        return StringUtil.deleteLastChar(builder.toString());
    }

    public static byte[] blobToBinary(Blob blobData) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        try {
            InputStream in = blobData.getBinaryStream();
            int n = 0;
            while ((n = in.read(buf)) >= 0) {
                baos.write(buf, 0, n);
            }
            in.close();
            baos.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return baos.toByteArray();
    }

    public static Blob binaryToBlob(byte[] byteData) {
        SerialBlob blob = null;
        try {
            blob = new SerialBlob(byteData);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return blob;
    }

    public static byte[] gzip(String source) {
        byte[] sourceByte = source.getBytes();
        BufferedOutputStream out = null;
        java.io.ByteArrayOutputStream bout = new java.io.ByteArrayOutputStream();
        try {
            out = new BufferedOutputStream(new GZIPOutputStream(bout));
            out.write(sourceByte);
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(out);
        return bout.toByteArray();
    }

    public static String ungzip(byte[] source) {
        BufferedReader in = null;
        StringBuilder buff = new StringBuilder();
        try {
            in = new BufferedReader(new InputStreamReader(new GZIPInputStream(new ByteArrayInputStream(source))));
            while (in.ready()) {
                buff.append(in.readLine()).append(StringConsts.NEW_LINE);
            }
            buff.deleteCharAt(buff.length() - 1);
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(in);
        return buff.toString();
    }
}

