/*
 * Decompiled with CFR 0.152.
 */
package bi.core.util.cli;

import bi.core.util.exec.SimpleExecUtil;
import bi.core.util.manager.FileManager;
import bi.core.util.manager.entity.ContextEntity;
import bi.core.util.manager.entity.InitFileEntity;
import bi.core.util.manager.entity.PipelineEntity;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.IOUtils;

public abstract class SimpleCLITemplate {
    protected CommandLine commandLine;
    private Map<String, Object> pipelineContext = new Hashtable<String, Object>();
    protected Options options = this.defineOptions();
    protected String usage;
    protected FileManager mgr;
    private PipelineEntity pipelineEntity;

    public SimpleCLITemplate(String usage, String ... args) {
        this.usage = usage;
        this.parseCommandline(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleCLITemplate(List<String> jobIdList, String usage, String ... args) {
        Option job = new Option("c", "config", true, "Pipeline paramset file path");
        this.options.addOption(job);
        this.usage = usage;
        this.parseCommandline(args);
        String xmlFile = this.getOptionValue("config");
        Unmarshaller unmarshaller = null;
        JAXBContext context = null;
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(xmlFile);
            context = JAXBContext.newInstance((Class[])new Class[]{PipelineEntity.class});
            unmarshaller = context.createUnmarshaller();
            this.setPipelineEntity((PipelineEntity)unmarshaller.unmarshal((InputStream)fin));
        }
        catch (Exception ex) {
            try {
                ex.printStackTrace();
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fin);
                throw throwable;
            }
            IOUtils.closeQuietly(fin);
        }
        IOUtils.closeQuietly(fin);
        this.mgr = new FileManager(jobIdList);
        this.init(this.mgr, this.getPipelineEntity(), this.pipelineContext);
        SimpleExecUtil.initFileManager(this.mgr.getStartJobEntryIdx(), this.mgr, this.pipelineContext, this.getPipelineEntity());
        for (ContextEntity curContext : this.pipelineEntity.getContextList()) {
            if (curContext.isOptional() || this.pipelineContext.get(curContext.getContextId()) != null) continue;
            throw new RuntimeException("Context Not setted:" + curContext.getContextId());
        }
        for (InitFileEntity initFile : this.pipelineEntity.getInitFileList()) {
            if (initFile.isOptional() || this.mgr.getFile(initFile.getFileId()) != null) continue;
            throw new RuntimeException("Init File Not setted:" + initFile.getFileId());
        }
    }

    public String getOptionValue(String optionName) {
        return this.getOptionValue(optionName, null, true);
    }

    public String getOptionValueQuietly(String optionName) {
        return this.getOptionValue(optionName, null, false);
    }

    public String getOptionValue(String optionName, String defaultValue) {
        return this.getOptionValue(optionName, defaultValue, false);
    }

    public String getOptionValue(String optionName, String defaultValue, boolean required) {
        Option[] optionList = this.commandLine.getOptions();
        try {
            for (Option option : optionList) {
                if (!option.getLongOpt().equals(optionName) && !option.getOpt().equals(optionName)) continue;
                return option.getValue();
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            this.showHelp(this.options);
            System.exit(0);
        }
        if (defaultValue != null) {
            return defaultValue;
        }
        if (required) {
            System.out.println("--" + optionName + " is required!");
            this.showHelp(this.options);
            System.exit(0);
        }
        return null;
    }

    protected Options parseCommandline(String[] args) {
        block2: {
            try {
                BasicParser parser = new BasicParser();
                this.commandLine = parser.parse(this.options, args, true);
                this.checkOptions(this.options);
            }
            catch (ParseException e) {
                if (e.getMessage().contains("-D")) break block2;
                System.out.println(e.getMessage() + "\n---------------------------------------");
                this.showHelp(this.options);
                System.exit(1);
            }
        }
        return this.options;
    }

    protected abstract Options defineOptions();

    protected abstract void init(FileManager var1, PipelineEntity var2, Map<String, Object> var3);

    private void checkOptions(Options options) {
        if (this.commandLine.hasOption("Help")) {
            this.showHelp(options);
        }
        List requiredOptionList = options.getRequiredOptions();
        for (String option : requiredOptionList) {
            if (this.commandLine.hasOption(option)) continue;
            System.out.println(option + " is required!");
            this.showHelp(options);
        }
    }

    public void showHelp() {
        this.showHelp(this.options);
    }

    private void showHelp(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.setWidth(150);
        formatter.printHelp(this.usage, "---------------------------------------", options, "", true);
        System.exit(0);
    }

    public void setUsage(String usage) {
        this.usage = usage;
    }

    public void printOptions() {
        Option[] optionList = this.commandLine.getOptions();
        StringBuilder builder = new StringBuilder();
        for (Option op : optionList) {
            builder.append(op.getLongOpt()).append(":").append(op.getValue()).append(" ");
        }
    }

    public Options getOptions() {
        return this.options;
    }

    public Map<String, Object> getPipelineContext() {
        return this.pipelineContext;
    }

    public void setPipelineContext(Map<String, Object> pipelineContext) {
        this.pipelineContext = pipelineContext;
    }

    public PipelineEntity getPipelineEntity() {
        return this.pipelineEntity;
    }

    public void setPipelineEntity(PipelineEntity pipelineEntity) {
        this.pipelineEntity = pipelineEntity;
    }
}

