/*
 * Decompiled with CFR 0.152.
 */
package bi.core.util.cli;

import java.util.Arrays;
import org.apache.commons.cli.Option;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class ChoiceOption
extends Option {
    private final String[] choices;

    public ChoiceOption(String opt, String longOpt, boolean hasArg, String description, String ... choices) throws IllegalArgumentException {
        super(opt, longOpt, hasArg, Arrays.toString(choices) + " " + description);
        this.choices = choices;
    }

    @Override
    public String getValue() throws RuntimeException {
        String value = super.getValue();
        if (value == null) {
            return value;
        }
        if (ArrayUtils.contains(this.choices, value)) {
            return value;
        }
        throw new RuntimeException("--" + this.getLongOpt() + ": " + value + " should be one of " + Arrays.toString(this.choices));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return new EqualsBuilder().appendSuper(super.equals(o)).append(this.choices, ((ChoiceOption)o).choices).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append(this.choices).toHashCode();
    }
}

