/*
 * Decompiled with CFR 0.152.
 */
package bi.core.bioutil.wrapper.config;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.core.env.Environment;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@EnableTransactionManagement
@ComponentScan(value={"bi.core.bioutil.wrapper"})
public class WrapperConfig {
    @Autowired
    private Environment env;

    public Environment getEnv() {
        return this.env;
    }

    public void setEnv(Environment env) {
        this.env = env;
    }

    @Bean
    public static PropertySourcesPlaceholderConfigurer myPropertySourcesPlaceholderConfigurer() {
        return new PropertySourcesPlaceholderConfigurer();
    }

    @Configuration
    @Profile(value={"prod"})
    @PropertySource(value={"classpath:env/prod/wrapper.properties"})
    static class Prod {
        Prod() {
        }
    }

    @Configuration
    @Profile(value={"dev"})
    @PropertySource(value={"classpath:env/dev/wrapper.properties"})
    static class Dev {
        Dev() {
        }
    }

    @Configuration
    @Profile(value={"default"})
    @PropertySource(value={"classpath:env/default/wrapper.properties"})
    static class Default {
        Default() {
        }
    }
}

