/*
 * Decompiled with CFR 0.152.
 */
package bi.core.bioutil.wrapper.common;

import bi.core.util.exec.GeneralExecInfo;
import bi.core.util.exec.SimpleExecTemplate;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class USearchWrapper
extends SimpleExecTemplate
implements GeneralExecInfo {
    private static final Logger log = LoggerFactory.getLogger(USearchWrapper.class);
    private String seqFileName = "";
    private String outFileName = "";

    public USearchWrapper() {
        super("usearch");
    }

    public USearchWrapper(String exec, String argument, File dir) {
        super(exec, argument, dir);
        this.exec = exec;
        this.argument = argument;
    }

    public void setProgramPath(String path) {
        this.exec = path;
    }

    public String getSeqFileName() {
        return this.seqFileName;
    }

    public void setSeqFileName(String seqFileName) {
        this.seqFileName = seqFileName;
    }

    public String getOutFileName() {
        return this.outFileName;
    }

    public void setOutFileName(String outFileName) {
        this.outFileName = outFileName;
    }

    public void setGlobalAlignment() {
        this.addArgument("-usearch_global", this.seqFileName);
    }

    public void setLocalAlignment() {
        this.addArgument("-usearch_local", this.seqFileName);
    }

    public void setDBFile(String dbFile) {
        this.addArgument("-db", dbFile);
    }

    public void setMakeudb(String seqFileName, String dbFile) {
        this.addArgument("-makeudb_usearch", seqFileName);
        this.addArgument("-output", dbFile);
    }

    public void setAlignmentOutput() {
        this.addArgument("-alnout", this.outFileName);
    }

    public void setBlastSimpleOutput() {
        this.addArgument("-blast6out", this.outFileName);
    }

    public void setBlastSimpleOutput(String outFileName) {
        this.addArgument("-blast6out", outFileName);
    }

    public void setSequenceIdentity(double identity) {
        this.addArgument("-id", identity);
    }

    public void setDerepFullLength() {
        this.addArgument("-derep_fulllength", this.seqFileName);
    }

    public void setDerepPrefix() {
        this.addArgument("-derep_prefix", this.seqFileName);
    }

    public void setFastaOut() {
        this.addArgument("-fastaout", this.outFileName);
    }

    public void setSortLength() {
        this.addArgument("-sortbylength", this.seqFileName);
    }

    public void setSortLength_ver8() {
        this.addArgument("-sort", "length");
    }

    public void setMinSeqLength(int length) {
        this.addArgument("-minseqlength", length);
    }

    public void setSortSize() {
        this.addArgument("-sortbysize", this.seqFileName);
    }

    public void setMinSize(int length) {
        this.addArgument("-minsize", length);
    }

    public void setClusterOTUs() {
        this.addArgument("-cluster_otus", this.seqFileName);
    }

    public void setOTUs() {
        this.addArgument("-otus", this.outFileName);
    }

    public void setUParseOutput(String outFile) {
        this.addArgument("-uparseout", outFile);
    }

    public void setReLabel(String prefix) {
        this.addArgument("-relabel", prefix);
    }

    public void setSizeOut() {
        this.addArgument("-sizeout");
    }

    public void setStrandPlus() {
        String value = "plus";
        this.addArgument("-strand", value);
    }

    public void setStrandBoth() {
        String value = "both";
        this.addArgument("-strand", value);
    }

    public void setUTax() {
        this.addArgument("-utax", this.seqFileName);
    }

    public void setTaxConfs(String tcFile) {
        this.addArgument("-taxconfs", tcFile);
    }

    public void setUTaxOut(String taxFile) {
        this.addArgument("-utaxout", taxFile);
    }

    public void setClusterFast() {
        this.addArgument("-cluster_fast", this.seqFileName);
    }

    public void setClusterSmallMem() {
        this.addArgument("-cluster_smallmem", this.seqFileName);
    }

    public void setCentroidOutput() {
        this.addArgument("-centroids", this.outFileName + "_centroid.fasta");
    }

    public void setConsensusOutput() {
        this.addArgument("-consout", this.outFileName + "_consensus.fasta");
    }

    public void setMSAOutput() {
        this.addArgument("-msaout_option", this.outFileName + "_msa.fasta");
    }

    public void setUc() {
        this.addArgument("-uc", this.outFileName);
    }

    public void setUcAll() {
        this.addArgument("-uc_allhits", this.outFileName);
    }

    public void setUBlast(String dbFile) {
        this.addArgument("-ublast", this.seqFileName);
        this.addArgument("-db", dbFile);
    }

    public void setEvalue(double evalue) {
        this.addArgument("-evalue", evalue);
    }

    public void setAccel(double accel) {
        this.addArgument("-accel", accel);
    }

    public void setDbSize(int dbSize) {
        this.addArgument("-ka_dbsize", dbSize);
    }

    public void setUChimeRef(String dbFile) {
        this.addArgument("-uchime_ref", this.seqFileName);
        this.setDBFile(dbFile);
    }

    public void setUChimeDenovo() {
        this.addArgument("-uchime_denovo", this.seqFileName);
    }

    public void setNonChimeraOut() {
        this.addArgument("-nonchimeras", this.outFileName);
    }

    public void setThreads(int threads) {
        this.addArgument("-threads", threads);
    }

    public void setHits(int hits) {
        this.addArgument("-maxaccepts", hits);
    }

    public void setReject(int hits) {
        this.addArgument("-maxrejects", hits);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int close() {
        int exitValue = -1;
        if (this.process != null) {
            try {
                this.process.getErrorStream().close();
                this.process.getInputStream().close();
                this.process.getOutputStream().close();
                exitValue = this.process.waitFor();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            finally {
                if (exitValue == 0) {
                    log.info("USearch Exited Normally. exitValue is " + exitValue);
                } else {
                    log.error("USearch Exited Abnormally. exitValue is " + exitValue);
                }
                this.process.destroy();
            }
        }
        return exitValue;
    }

    @Override
    public String exec() {
        return super.exec();
    }

    @Override
    public BufferedReader executeToBufferedReader() {
        return super.executeToBufferedReader();
    }

    @Override
    public String getVersion() {
        return "v8.0.1517";
    }
}

