/*
 * Decompiled with CFR 0.152.
 */
package bi.core.bioutil.wrapper.common;

import bi.core.bioutil.wrapper.WrapperConsts;
import bi.core.util.common.FilenameUtil;
import bi.core.util.exec.GeneralExecInfo;
import bi.core.util.exec.wrapper.JarWrapper;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrimmomaticWrapper
extends JarWrapper
implements GeneralExecInfo {
    private static final Logger log = LoggerFactory.getLogger(TrimmomaticWrapper.class);
    private static final String METHOD_PairedEnd = "PE";
    private static final String METHOD_SingleEnd = "SE";
    private int seed_mismatches = 2;
    private int palindrome_clip_threshold = 30;
    private int simple_clip_threshold = 10;
    private int leading = 3;
    private int trailing = 3;
    private int slidingwindow_size = 4;
    private int slidingwindow_qual = 15;
    private int minlen = 36;
    private int avgqual = 25;
    private String method;
    private File outDir;
    private static final String illuminaclip = "ILLUMINACLIP:";
    private String tail = ":" + this.seed_mismatches + ":" + this.palindrome_clip_threshold + ":" + this.simple_clip_threshold;

    public TrimmomaticWrapper(String jarPath) {
        super(jarPath);
    }

    public TrimmomaticWrapper() {
        super(WrapperConsts.TRIMMOMATIC_JAR_PATH);
    }

    public void setPhred(String phred) {
        this.addArgument("-" + phred);
    }

    public void setThreads(int threads) {
        if (threads != 0) {
            this.addArgument("-threads", threads);
        }
    }

    public void setOutDir(File outDir) {
        this.outDir = outDir;
    }

    public void setOutFileNames(String ... fileName) {
        if (METHOD_PairedEnd.equals(this.method) && fileName.length > 1) {
            String file1Path = this.outDir.getAbsolutePath() + File.separator + fileName[0];
            String file1PathWithoutExt = FilenameUtil.removeAllExtension(file1Path);
            String file2Path = this.outDir.getAbsolutePath() + File.separator + fileName[1];
            this.addArgument(file1Path);
            this.addArgument(file2Path);
            this.addArgument(file1PathWithoutExt + ".1.trim.p.gz");
            this.addArgument(file1PathWithoutExt + ".1.trim.up.gz");
            this.addArgument(file1PathWithoutExt + ".2.trim.p.gz");
            this.addArgument(file1PathWithoutExt + ".2.trim.up.gz");
        } else if (METHOD_SingleEnd.equals(this.method) && fileName.length == 1) {
            String file1Path = this.outDir.getAbsolutePath() + File.separator + fileName[0];
            this.addArgument(file1Path);
            this.addArgument(FilenameUtil.removeAllExtension(file1Path) + ".trim.gz");
        } else {
            log.debug("Impossible Case! FileName Length = " + fileName.length + " Method = " + this.method + "");
            return;
        }
    }

    public void applyIlluminaTruSeqAdapter() {
        if (METHOD_PairedEnd.equals(this.method)) {
            this.addArgument("ILLUMINACLIP:/trimmomatic/TruSeq3-PE.fa" + this.tail);
        } else if (METHOD_SingleEnd.equals(this.method)) {
            this.addArgument("ILLUMINACLIP:/trimmomatic/TruSeq3-SE.fa" + this.tail);
        } else {
            log.debug("Impossible Case! Method = " + this.method + "");
            return;
        }
    }

    @Override
    public String getVersion() {
        return "trimmomatic-0.32";
    }

    public void addLeading() {
        this.addArgument("LEADING:" + this.leading);
    }

    public void addTrailing() {
        this.addArgument("TRAILING:" + this.trailing);
    }

    public void addSlidingWindow() {
        this.addArgument("SLIDINGWINDOW:" + this.slidingwindow_size + ":" + this.slidingwindow_qual);
    }

    public void addMinlen() {
        this.addArgument("MINLEN:" + this.minlen);
    }

    public void addAvgQual() {
        this.addArgument("AVGQUAL:" + this.avgqual);
    }

    public void addLeading(int v) {
        this.addArgument("LEADING:" + v);
    }

    public void addTrailing(int v) {
        this.addArgument("TRAILING:" + v);
    }

    public void addSlidingWindow(int size, int qual) {
        this.addArgument("SLIDINGWINDOW:" + size + ":" + qual);
    }

    public void addMinlen(int v) {
        this.addArgument("MINLEN:" + v);
    }

    public void addAvgQual(int v) {
        this.addArgument("AVGQUAL:" + v);
    }

    public int getSeed_mismatches() {
        return this.seed_mismatches;
    }

    public void setSeed_mismatches(int seed_mismatches) {
        this.seed_mismatches = seed_mismatches;
    }

    public int getPalindrome_clip_threshold() {
        return this.palindrome_clip_threshold;
    }

    public void setPalindrome_clip_threshold(int palindrome_clip_threshold) {
        this.palindrome_clip_threshold = palindrome_clip_threshold;
    }

    public int getSimple_clip_threshold() {
        return this.simple_clip_threshold;
    }

    public void setSimple_clip_threshold(int simple_clip_threshold) {
        this.simple_clip_threshold = simple_clip_threshold;
    }

    public int getLeading() {
        return this.leading;
    }

    public void setLeading(int leading) {
        this.leading = leading;
    }

    public int getTrailing() {
        return this.trailing;
    }

    public void setTrailing(int trailing) {
        this.trailing = trailing;
    }

    public int getSlidingwindow_size() {
        return this.slidingwindow_size;
    }

    public void setSlidingwindow_size(int slidingwindow_size) {
        this.slidingwindow_size = slidingwindow_size;
    }

    public int getSlidingwindow_qual() {
        return this.slidingwindow_qual;
    }

    public void setSlidingwindow_qual(int slidingwindow_qual) {
        this.slidingwindow_qual = slidingwindow_qual;
    }

    public int getMinlen() {
        return this.minlen;
    }

    public void setMinlen(int minlen) {
        this.minlen = minlen;
    }
}

