/*
 * Decompiled with CFR 0.152.
 */
package bi.core.bioutil.wrapper.common;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RscriptWrapper {
    private static final Logger log = LoggerFactory.getLogger(RscriptWrapper.class);
    String rscriptPath = null;
    String dirPath = System.getProperty("user.dir");
    String[] args = null;

    public String getDirPath() {
        return this.dirPath;
    }

    public void setDirPath(String dirPath) {
        this.dirPath = dirPath;
    }

    public void writeTempRsource(ArrayList<String> lines) {
        File tempFile = new File(this.dirPath + "\\temp.R");
        FileWriter fw = null;
        BufferedWriter bw = null;
        try {
            fw = new FileWriter(tempFile, false);
            bw = new BufferedWriter(fw);
            bw.write("args <- commandArgs()");
            bw.newLine();
            for (int i = 0; i < lines.size(); ++i) {
                bw.write(lines.get(i));
                bw.newLine();
            }
            bw.flush();
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public void executeRscript() throws InterruptedException {
        StringBuffer cmd = new StringBuffer();
        if (this.rscriptPath != null) {
            cmd.append("\"" + this.rscriptPath + "/Rscript\"");
        } else {
            cmd.append("Rscript");
        }
        cmd.append(" ");
        cmd.append("\"" + this.dirPath + "/temp.R\"");
        if (this.args != null) {
            for (int i = 0; i < this.args.length; ++i) {
                cmd.append(" ");
                cmd.append(this.args[i]);
            }
        }
        System.out.println(cmd.toString());
        try {
            Process proc = Runtime.getRuntime().exec(cmd.toString());
            int resultSign = proc.waitFor();
            if (resultSign == 0) {
                String inputLine;
                log.info("R operation success");
                StringBuffer rOut = new StringBuffer();
                BufferedReader inputBuf = new BufferedReader(new InputStreamReader(proc.getInputStream(), "UTF-8"));
                while ((inputLine = inputBuf.readLine()) != null) {
                    rOut.append(inputLine);
                    rOut.append("\n");
                }
                inputBuf.close();
                log.info(rOut.toString());
            } else {
                log.info("R error : " + resultSign);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String executeRscriptAndTransferDataFrameToJava(int row, int column) throws InterruptedException {
        String[][] result = new String[row][column];
        StringBuffer cmd = new StringBuffer();
        cmd.append("Rscript");
        cmd.append(" ");
        cmd.append(this.dirPath);
        cmd.append("\\");
        cmd.append("temp.R");
        if (this.args != null) {
            for (int i = 0; i < this.args.length; ++i) {
                cmd.append(" ");
                cmd.append(this.args[i]);
            }
        }
        System.out.println(cmd.toString());
        try {
            Process proc = Runtime.getRuntime().exec(cmd.toString());
            int resultSign = proc.waitFor();
            if (resultSign == 0) {
                String inputLine;
                log.info("R operation success");
                BufferedReader inputBuf = new BufferedReader(new InputStreamReader(proc.getInputStream(), "UTF-8"));
                int i = 0;
                while ((inputLine = inputBuf.readLine()) != null) {
                    for (int j = 0; j < column; ++j) {
                        result[i][j] = inputLine.split(" ")[j];
                        System.out.print(result[i][j] + " ");
                    }
                    ++i;
                    System.out.println();
                }
                inputBuf.close();
            } else {
                log.info("R error : " + resultSign);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void set1Args(String inputFilePath) {
        this.args = new String[1];
        this.args[0] = inputFilePath;
    }

    public void set2Args(ArrayList<Double> inputArrList, ArrayList<Double> inputArrList2) {
        this.args = new String[2];
        String s1 = "c(" + inputArrList.get(0).toString();
        String s2 = "c(" + inputArrList2.get(0).toString();
        for (int i = 1; i < inputArrList.size(); ++i) {
            s1 = s1 + "," + inputArrList.get(i);
            s2 = s2 + "," + inputArrList2.get(i);
        }
        s1 = s1 + ")";
        s2 = s2 + ")";
        this.args[0] = s1;
        this.args[1] = s2;
    }

    public String numericVectors(String objectName, double[] doubleArray) {
        String line = objectName + " <- c(" + doubleArray[0];
        for (int i = 1; i < doubleArray.length; ++i) {
            line = line + ", " + doubleArray[i];
        }
        line = line + ")";
        return line;
    }

    public String numericVectors(String objectName, ArrayList<Double> doubleArrayList) {
        String line = objectName + " <- c(" + doubleArrayList.get(0);
        for (int i = 1; i < doubleArrayList.size(); ++i) {
            line = line + ", " + doubleArrayList.get(i);
        }
        line = line + ")";
        return line;
    }

    public String stringVectors(String objectName, String[] stringArray) {
        String line = objectName + " <- c('" + stringArray[0] + "'";
        for (int i = 1; i < stringArray.length; ++i) {
            line = line + ", '" + stringArray[i] + "'";
        }
        line = line + ")";
        return line;
    }

    public String stringVectors(String objectName, ArrayList<String> stringArrayList) {
        String line = objectName + " <- c('" + stringArrayList.get(0) + "'";
        for (int i = 1; i < stringArrayList.size(); ++i) {
            line = line + ", '" + stringArrayList.get(i) + "'";
        }
        line = line + ")";
        return line;
    }

    public String loadRpackage(String packageName) {
        String line = "if(!require('" + packageName + "')){" + "install.packages('ggplot2',repos='http://cran.nexr.com');" + "library(" + packageName + ");}";
        return line;
    }

    public String getRscriptPath() {
        return this.rscriptPath;
    }

    public void setRscriptPath(String rscriptPath) {
        this.rscriptPath = rscriptPath;
    }
}

