/*
 * Decompiled with CFR 0.152.
 */
package bi.core.bioutil.wrapper.common;

import bi.core.util.common.Tools;
import bi.core.util.exec.GeneralExecInfo;
import bi.core.util.exec.SimpleExecTemplate;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RaxMlWrapper
extends SimpleExecTemplate
implements GeneralExecInfo {
    private static final Logger log = LoggerFactory.getLogger(RaxMlWrapper.class);
    private int n_threads = 8;
    private long seed = 0L;
    private String inputFileName = null;

    public RaxMlWrapper() {
        super("raxmlHPC-PTHREADS");
    }

    public void setProgramPath(String path) {
        this.exec = path;
    }

    public void setThreads(int threads) {
        this.n_threads = threads;
    }

    public void setInputFile(String fileName) {
        this.inputFileName = fileName;
    }

    public void setDefaultForDna() {
        this.addArgument("-m", "GTRCAT");
    }

    public String getBestMLTreeFileName() {
        return "RAxML_bestTree." + this.seed;
    }

    public void cleanUpFiles() {
        new File(this.inputFileName).delete();
        new File(this.inputFileName + ".reduced").delete();
        new File(this.getDir() + "/RAxML_bestTree." + this.seed).delete();
        new File(this.getDir() + "/RAxML_info." + this.seed).delete();
        new File(this.getDir() + "/RAxML_parsimonyTree." + this.seed).delete();
        new File(this.getDir() + "/RAxML_log." + this.seed).delete();
        new File(this.getDir() + "/RAxML_result." + this.seed).delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() {
        this.seed = Tools.getTimeStampNow();
        this.addArgument("-n", this.seed);
        this.addArgument("-p", this.seed);
        this.addArgument("-s", this.inputFileName);
        this.addArgument("-T", this.n_threads);
        boolean res = false;
        BufferedReader br = this.executeToBufferedReader();
        String line = null;
        try {
            while ((line = br.readLine()) != null) {
                if (!line.startsWith("Best-scoring ML tree written to:")) continue;
                res = true;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            IOUtils.closeQuietly(br);
        }
        return res;
    }

    @Override
    public String getVersion() {
        return "8";
    }
}

