/*
 * Decompiled with CFR 0.152.
 */
package bi.core.bioutil.wrapper.common;

import bi.core.util.exec.GeneralExecInfo;
import bi.core.util.exec.SimpleExecTemplate;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MakeBlastDbWrapper
extends SimpleExecTemplate
implements GeneralExecInfo {
    private static final Logger log = LoggerFactory.getLogger(MakeBlastDbWrapper.class);
    private String dbFileName = null;
    public static int TYPE_DNA = 0;
    public static int TYPE_PROTEIN = 1;

    public void setProgramPath(String path) {
        this.exec = path;
    }

    public MakeBlastDbWrapper(String dbFileName, int molecule_type) {
        super("makeblastdb");
        this.dbFileName = dbFileName;
        if (molecule_type == TYPE_PROTEIN) {
            this.addArgument("-dbtype", "prot");
        } else {
            this.addArgument("-dbtype", "nucl");
        }
    }

    public void applyIndex(File indexFile) {
        this.addArgument("-in", indexFile.getAbsolutePath());
    }

    public void setOutFileNames(String fileName) {
        this.addArgument("-out", fileName);
    }

    void setParameters() {
        this.addArgument("-in", this.dbFileName);
    }

    public boolean executeWithDnaSeqDomainListAndDeleteOnExit() {
        boolean res = this.execute();
        new File(this.dbFileName + ".nhr").deleteOnExit();
        new File(this.dbFileName + ".nin").deleteOnExit();
        new File(this.dbFileName + ".nsq").deleteOnExit();
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() {
        boolean res = false;
        BufferedReader br = this.executeToBufferedReader();
        String line = null;
        try {
            while ((line = br.readLine()) != null) {
                if (!line.startsWith("Adding sequences from FASTA")) continue;
                res = true;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            IOUtils.closeQuietly(br);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeCheck(boolean runForcely) {
        if (!runForcely && new File(this.dbFileName + ".nhr").getAbsoluteFile().exists() && new File(this.dbFileName + ".nin").getAbsoluteFile().exists() && new File(this.dbFileName + ".nsq").getAbsoluteFile().exists()) {
            return true;
        }
        boolean res = false;
        BufferedReader br = this.executeToBufferedReader();
        String line = null;
        try {
            while ((line = br.readLine()) != null) {
                if (!line.startsWith("Adding sequences from FASTA")) continue;
                res = true;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            IOUtils.closeQuietly(br);
        }
        return res;
    }

    @Override
    public BufferedReader executeToBufferedReader() {
        this.setParameters();
        return super.executeToBufferedReader();
    }

    @Override
    public String getVersion() {
        return "2.2.29+";
    }
}

