/*
 * Decompiled with CFR 0.152.
 */
package bi.core.bioutil.wrapper.common;

import bi.core.util.exec.GeneralExecInfo;
import bi.core.util.exec.SimpleExecTemplate;
import java.io.BufferedReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HmmSearchWrapper
extends SimpleExecTemplate
implements GeneralExecInfo {
    private static final Logger log = LoggerFactory.getLogger(HmmSearchWrapper.class);
    private String hmmFileName;
    private String seqFileName;
    private String outFileName = null;

    public HmmSearchWrapper() {
        super("hmmsearch");
    }

    public void setProgramPath(String path) {
        this.exec = path;
    }

    @Override
    public String getVersion() {
        return "3.1b1";
    }

    public String getOutFileName() {
        return this.outFileName;
    }

    public void setOutFileName(String outFileName) {
        this.outFileName = outFileName;
    }

    public void setNoAlignment() {
        this.addArgument("--noali");
    }

    public void setCoreForMultiThread(int noCore) {
        this.addArgument("--cpu", noCore);
    }

    public String getHmmFileName() {
        return this.hmmFileName;
    }

    public void setHmmFileName(String hmmFileName) {
        this.hmmFileName = hmmFileName;
    }

    public String getSeqFileName() {
        return this.seqFileName;
    }

    public void setSeqFileName(String seqFileName) {
        this.seqFileName = seqFileName;
    }

    @Override
    public String exec() {
        this.addArgument(this.hmmFileName);
        this.addArgument(this.seqFileName);
        return super.exec();
    }

    @Override
    public boolean execute() {
        if (this.outFileName != null) {
            this.addArgument("-o", this.outFileName);
        }
        this.addArgument(this.hmmFileName);
        this.addArgument(this.seqFileName);
        return super.execute();
    }

    @Override
    public BufferedReader executeToBufferedReader() {
        if (this.outFileName != null) {
            this.addArgument("-o", this.outFileName);
        }
        this.addArgument(this.hmmFileName);
        this.addArgument(this.seqFileName);
        return super.executeToBufferedReader();
    }
}

