/*
 * Decompiled with CFR 0.152.
 */
package bi.core.bioutil.wrapper.common;

import bi.core.util.exec.GeneralExecInfo;
import bi.core.util.exec.SimpleExecTemplate;
import java.io.BufferedReader;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormatDbWrapper
extends SimpleExecTemplate
implements GeneralExecInfo {
    private static final Logger log = LoggerFactory.getLogger(FormatDbWrapper.class);
    private boolean isProtein = false;
    private String inFileName = null;

    public FormatDbWrapper() {
        super("formatdb");
    }

    public static Logger getLog() {
        return log;
    }

    public void setProgramPath(String path) {
        this.exec = path;
    }

    public void setInFileName(String inFileName) {
        this.inFileName = inFileName;
        this.addArgument("-i", inFileName);
    }

    public void setProtein() {
        this.isProtein = true;
    }

    public void deleteBlastDbFiles() {
        if (this.isProtein) {
            new File(this.inFileName + ".phr").delete();
            new File(this.inFileName + ".pin").delete();
            new File(this.inFileName + ".psq").delete();
        } else {
            new File(this.inFileName + ".nhr").delete();
            new File(this.inFileName + ".nin").delete();
            new File(this.inFileName + ".nsq").delete();
        }
    }

    public boolean checkSuccess() {
        File seqFile = new File(this.inFileName);
        File dbFile = null;
        dbFile = this.isProtein ? new File(this.inFileName + ".phr") : new File(this.inFileName + ".nhr");
        return dbFile.exists() && dbFile.lastModified() >= seqFile.lastModified();
    }

    @Override
    public String getVersion() {
        return "2.2.26";
    }

    @Override
    public String exec() {
        if (this.isProtein) {
            this.addArgument("-p", "T");
        } else {
            this.addArgument("-p", "F");
        }
        return super.exec();
    }

    @Override
    public BufferedReader executeToBufferedReader() {
        if (this.isProtein) {
            this.addArgument("-p", "T");
        } else {
            this.addArgument("-p", "F");
        }
        return super.executeToBufferedReader();
    }
}

