/*
 * Decompiled with CFR 0.152.
 */
package bi.core.bioutil.wrapper.common;

import bi.core.util.common.FilenameUtil;
import bi.core.util.exec.GeneralExecInfo;
import bi.core.util.exec.SimpleExecTemplate;
import java.io.File;

public class FastqcWrapper
extends SimpleExecTemplate
implements GeneralExecInfo {
    private static final String TAXONOMY_PROK = "prok";
    private static final String METHOD_PE = "PE";
    private String taxonomy;
    private String method;
    private String sampleId;
    private File outDir;

    public FastqcWrapper() {
        super("fastqc");
    }

    public FastqcWrapper(String taxonomy, String method, String sampleId) {
        super("fastqc");
        this.taxonomy = taxonomy;
        this.method = method;
        this.sampleId = sampleId;
    }

    public void setThreads(int threads) {
        if (threads != 0) {
            this.addArgument("-t", threads);
        }
    }

    public void setOutDir(File outDir) {
        this.outDir = outDir;
        File file = new File(outDir.getAbsolutePath() + File.separator + "FastQC_" + this.sampleId);
        this.addArgument("-o", file.getAbsolutePath());
    }

    public void setOutFileNames(String ... fileName) {
        if (METHOD_PE.equals(this.method) && fileName.length > 1) {
            String file1Path = this.outDir.getAbsolutePath() + File.separator + fileName[0];
            String file1PathWithoutExt = FilenameUtil.removeAllExtension(file1Path);
            String file2Path = this.outDir.getAbsolutePath() + File.separator + fileName[1];
            String file2PathWithoutExt = FilenameUtil.removeAllExtension(file2Path);
            this.addArgument(file1Path);
            if (TAXONOMY_PROK.equals(this.taxonomy)) {
                this.addArgument(file1PathWithoutExt + ".trim.gz");
            } else {
                this.addArgument(file1PathWithoutExt + ".trim.p.gz");
            }
            this.addArgument(file2Path);
            if (TAXONOMY_PROK.equals(this.taxonomy)) {
                this.addArgument(file2PathWithoutExt + ".trim.gz");
            } else {
                this.addArgument(file2PathWithoutExt + ".trim.p.gz");
            }
        } else {
            String file1Path = this.outDir.getAbsolutePath() + File.separator + fileName[0];
            this.addArgument(file1Path);
            this.addArgument(FilenameUtil.removeAllExtension(file1Path) + ".trim.p.gz");
        }
    }

    @Override
    public String getVersion() {
        return "0.11.2";
    }
}

