/*
 * Decompiled with CFR 0.152.
 */
package bi.core.bioutil.wrapper.common;

import bi.core.util.exec.GeneralExecInfo;
import bi.core.util.exec.SimpleExecTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiamondWrapper
extends SimpleExecTemplate
implements GeneralExecInfo {
    private static final Logger log = LoggerFactory.getLogger(DiamondWrapper.class);
    public static final String JOB_MAKEDB = "makedb";
    public static final String JOB_BLASTP = "blastp";
    public static final String JOB_BLASTX = "blastx";
    public static final String JOB_VIEW = "view";
    private String jobName;

    public DiamondWrapper(String jobName) {
        super("diamond");
        boolean setJob = this.setJob(jobName);
        if (!setJob) {
            log.error("unknown job : " + jobName);
            return;
        }
    }

    public void setProgramPath(String path) {
        this.exec = path;
    }

    public boolean setJob(String jobName) {
        this.jobName = jobName;
        switch (jobName) {
            case "makedb": {
                this.addArgument(JOB_MAKEDB);
                return true;
            }
            case "blastp": {
                this.addArgument(JOB_BLASTP);
                return true;
            }
            case "blastx": {
                this.addArgument(JOB_BLASTX);
                return true;
            }
            case "view": {
                this.addArgument(JOB_VIEW);
                return true;
            }
        }
        return false;
    }

    public void setThreads(int threads) {
        this.addArgument("-p", threads);
    }

    public void setDbFile(String dbFileName) {
        this.addArgument("-d", dbFileName);
    }

    public void setDaaFile(String daaFileName) {
        this.addArgument("-a", daaFileName);
    }

    public void logStdOutOn() {
        this.addArgument("-v");
    }

    public void setReferenceFastaFile(String refFastaFileName) {
        if (this.jobName.equals(JOB_MAKEDB)) {
            this.addArgument("-i", refFastaFileName);
        }
    }

    public void setBlockSize(float blockSize) {
        if (this.jobName.equals(JOB_MAKEDB)) {
            this.addArgument("-b", Float.valueOf(blockSize));
        }
    }

    public void setQueryFileName(String queryFileName) {
        if (this.jobName.equals(JOB_BLASTP) || this.jobName.equals(JOB_BLASTX)) {
            this.addArgument("-q", queryFileName);
        }
    }

    public void setNoHits(int hits) {
        if (this.jobName.equals(JOB_BLASTP) || this.jobName.equals(JOB_BLASTX)) {
            this.addArgument("-k", hits);
        }
    }

    public void setEvalue(double evalue) {
        if (this.jobName.equals(JOB_BLASTP) || this.jobName.equals(JOB_BLASTX)) {
            this.addArgument("-e", evalue);
        }
    }

    public void setSensitive() {
        if (this.jobName.equals(JOB_BLASTP) || this.jobName.equals(JOB_BLASTX)) {
            this.addArgument("--sensitive");
        }
    }

    public void setIndexChuckSize(int size) {
        if (this.jobName.equals(JOB_BLASTP) || this.jobName.equals(JOB_BLASTX)) {
            this.addArgument("-c", size);
        }
    }

    public void setOutFormat(String format) {
        if (this.jobName.equals(JOB_VIEW)) {
            this.addArgument("-f", format);
        }
    }

    public void setOutFileName(String outFileName) {
        if (this.jobName.equals(JOB_VIEW)) {
            this.addArgument("-o", outFileName);
        }
    }

    private boolean CheckArguments() {
        String args = this.getArgument();
        if (!(!this.jobName.equals(JOB_MAKEDB) || args.contains("-i") && args.contains("-d"))) {
            log.error("'-i', '-d' were essential param for " + this.jobName);
            return false;
        }
        if (!(!this.jobName.equals(JOB_BLASTP) && !this.jobName.equals(JOB_BLASTX) || args.contains("-q") && args.contains("-d") && args.contains("-a"))) {
            log.error("'-q', '-d', '-a' were essential param for " + this.jobName);
            return false;
        }
        if (this.jobName.equals(JOB_VIEW) && !args.contains("-a")) {
            log.error("'-a', '-f' were essential param for " + this.jobName);
            return false;
        }
        return true;
    }

    @Override
    public String exec() {
        if (this.CheckArguments()) {
            return super.exec();
        }
        return null;
    }

    @Override
    public String getVersion() {
        return "v0.7.9";
    }
}

