/*
 * Decompiled with CFR 0.152.
 */
package bi.core.bioutil.wrapper.common;

import bi.core.util.exec.GeneralExecInfo;
import bi.core.util.exec.SimpleExecTemplate;
import java.io.BufferedReader;

public class BlastnWrapper
extends SimpleExecTemplate
implements GeneralExecInfo {
    public static int TASK_BLASTN = 0;
    public static int TASK_BLASTN_SHORT = 1;
    public static int TASK_BLASTN_DC_MEGABLAST = 2;
    public static int TASK_BLASTN_MEGABLAST = 3;
    public static int TASK_RMBLASTN = 4;
    private int task_type = 0;
    private String dbFileName = null;
    private String inFileName = null;
    private String dustOption = "yes";
    private double evalue = 10.0;

    public BlastnWrapper(int task_type, String dbFileName) {
        super("blastn");
        this.dbFileName = dbFileName;
        this.task_type = task_type;
    }

    public void setProgramPath(String path) {
        this.exec = path;
    }

    public void setCoreForMultiThread(int noCore) {
        this.addArgument("-num_threads", noCore);
    }

    public void setOutputFormat(int format) {
        this.addArgument("-outfmt", format);
    }

    public void setOutputFormatToTablular() {
        this.addArgument("-outfmt", "6");
    }

    public double getEvalue() {
        return this.evalue;
    }

    public void setEvalue(double evalue) {
        this.evalue = evalue;
    }

    public void setQueryFilteringDUST(String option) {
        this.dustOption = option;
    }

    public void setFilterEvalue(double filterEvalue) {
        this.addArgument("-evalue", filterEvalue);
    }

    @Override
    public String getVersion() {
        return "2.2.30";
    }

    private void setParameters() {
        System.out.println(this.inFileName);
        this.addArgument("-db", this.dbFileName);
        this.addArgument("-query", this.inFileName);
        this.addArgument("-dust", this.dustOption);
        this.addArgument("-evalue", this.evalue);
        String task = "blastn";
        if (this.task_type == 1) {
            task = "blastn-short";
        } else if (this.task_type == 2) {
            task = "dc-megablast";
        } else if (this.task_type == 3) {
            task = "megablast";
        } else if (this.task_type == 4) {
            task = "rmblastn";
        }
        this.addArgument("-task", task);
    }

    @Override
    public BufferedReader executeToBufferedReader() {
        this.setParameters();
        return super.executeToBufferedReader();
    }

    public String getDbFileName() {
        return this.dbFileName;
    }

    public void setDbFileName(String dbFileName) {
        this.dbFileName = dbFileName;
    }

    public String getInFileName() {
        return this.inFileName;
    }

    public void setInFileName(String inFileName) {
        this.inFileName = inFileName;
    }

    public String getDustOption() {
        return this.dustOption;
    }

    public void setDustOption(String dustOption) {
        this.dustOption = dustOption;
    }
}

