/*
 * Decompiled with CFR 0.152.
 */
package bi.core.bioutil.wrapper.common;

import bi.core.util.exec.GeneralExecInfo;
import bi.core.util.exec.SimpleExecTemplate;
import java.io.BufferedReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlastallWrapper
extends SimpleExecTemplate
implements GeneralExecInfo {
    private static final Logger log = LoggerFactory.getLogger(BlastallWrapper.class);

    public BlastallWrapper() {
        super("blastall");
    }

    public void setProgramPath(String path) {
        this.exec = path;
    }

    public void setBlastProgram(String program) {
        this.addArgument("-p", program);
    }

    public void setInFileName(String inFileName) {
        this.addArgument("-i", inFileName);
    }

    public void setDbFileName(String dbFileName) {
        this.addArgument("-d", dbFileName);
    }

    public void setOutFileName(String outFileName) {
        this.addArgument("-o", outFileName);
    }

    public void setFilterEvalue(double filterEvalue) {
        this.addArgument("-e", filterEvalue);
    }

    public void setAlignedView(int alignedView) {
        this.addArgument("-m", alignedView);
    }

    public void setFilterQuerySeq(String filterQuerySeq) {
        this.addArgument("-F", filterQuerySeq);
    }

    public void setCoreForMultiThread(int noCore) {
        this.addArgument("-a", noCore);
    }

    public void setNoAlignmentShowed(int noAlignmentShowed) {
        this.addArgument("-b", noAlignmentShowed);
    }

    public void setNoDescriptionShowed(int noDescriptionShowed) {
        this.addArgument("-v", noDescriptionShowed);
    }

    @Override
    public String getVersion() {
        return "2.2.22";
    }

    @Override
    public String exec() {
        return super.exec();
    }

    @Override
    public BufferedReader executeToBufferedReader() {
        return super.executeToBufferedReader();
    }

    public void setAniOption() {
        this.setFilterEvalue(1.0E-15);
        this.setFilterQuerySeq("F");
        this.addArgument("-X", 150);
        this.addArgument("-q", -1);
        this.addArgument("-r", 1);
        this.setNoAlignmentShowed(1);
        this.setNoDescriptionShowed(1);
    }
}

