/*
 * Decompiled with CFR 0.152.
 */
package bi.core.bioutil.wrapper.common;

import bi.core.util.exec.GeneralExecInfo;
import bi.core.util.exec.SimpleExecTemplate;
import java.io.BufferedReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlastWrapper
extends SimpleExecTemplate
implements GeneralExecInfo {
    private static final Logger log = LoggerFactory.getLogger(BlastWrapper.class);
    public static final int PROGRAM_BLASTN = 0;
    public static final int PROGRAM_BLASTP = 1;
    public static final int PROGRAM_BLASTX = 2;
    public static final int PROGRAM_TBLASTN = 3;
    public static final int PROGRAM_TBLASTX = 4;

    public BlastWrapper() {
        super("blastall");
    }

    public BlastWrapper(int task) {
        super("blastall");
        this.setTask(task);
    }

    public void setProgramPath(String path) {
        this.exec = path;
    }

    public void setTask(int task) {
        String taskString = "";
        switch (task) {
            case 0: {
                taskString = "blastn";
                break;
            }
            case 1: {
                taskString = "blastp";
                break;
            }
            case 2: {
                taskString = "blastx";
                break;
            }
            case 3: {
                taskString = "tblastn";
                break;
            }
            case 4: {
                taskString = "tblastx";
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.addArgument("-p", taskString);
    }

    public void setInFileName(String inFileName) {
        this.addArgument("-i", inFileName);
    }

    public void setDbFileName(String dbFileName) {
        this.addArgument("-d", dbFileName);
    }

    public void setOutFileName(String outFileName) {
        this.addArgument("-o", outFileName);
    }

    public void setFilterEvalue(double filterEvalue) {
        this.addArgument("-e", filterEvalue);
    }

    public void setAlignedView(int alignedView) {
        this.addArgument("-m", alignedView);
    }

    public void setFilterQuerySeq(String filterQuerySeq) {
        this.addArgument("-F", filterQuerySeq);
    }

    public void setCoreForMultiThread(int noCore) {
        this.addArgument("-a", noCore);
    }

    public void setNoAlignmentShowed(int noAlignmentShowed) {
        this.addArgument("-b", noAlignmentShowed);
    }

    public void setNoDescriptionShowed(int noDescriptionShowed) {
        this.addArgument("-v", noDescriptionShowed);
    }

    @Override
    public String exec() {
        return super.exec();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BufferedReader executeToBufferedReader() {
        this.getProcess().destroy();
        if (this.getProcess().exitValue() != 0) {
            return null;
        }
        return super.executeToBufferedReader();
    }

    @Override
    public String getVersion() {
        return "2.2.28";
    }

    public void setAniOption() {
        this.setTask(0);
        this.setFilterEvalue(1.0E-15);
        this.setFilterQuerySeq("F");
        this.addArgument("-X", 150);
        this.addArgument("-q", -1);
        this.addArgument("-r", 1);
        this.setNoAlignmentShowed(1);
        this.setNoDescriptionShowed(1);
    }
}

