/*
 * Decompiled with CFR 0.152.
 */
package bi.core.bioutil.wrapper.common;

import bi.core.util.exec.GeneralExecInfo;
import bi.core.util.exec.SimpleExecTemplate;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlastPlusWrapper
extends SimpleExecTemplate
implements GeneralExecInfo {
    private String programString = null;
    private static final Logger log = LoggerFactory.getLogger(BlastPlusWrapper.class);
    public static final int PROGRAM_BLASTN = 0;
    public static final int PROGRAM_BLASTN_SHORT = 1;
    public static final int PROGRAM_MEGABLAST = 2;
    public static final int PROGRAM_DC_MEAGBLAST = 3;
    public static final int PROGRAM_RMBLASTN = 4;
    public static final int PROGRAM_BLASTP = 5;
    public static final int PROGRAM_BLASTP_SHORT = 6;
    public static final int PROGRAM_BLASTP_FAST = 7;
    public static final int PROGRAM_TBLASTN = 8;
    public static final int PROGRAM_TBLASTN_FAST = 9;
    public static final int PROGRAM_TBLASTX = 10;
    public static final int PROGRAM_BLASTX = 11;
    public static final int PROGRAM_BLASTX_FAST = 12;
    public static final int PROGRAM_PSIBLAST = 13;
    public static final int PROGRAM_RPSBLAST = 14;
    public static final int PROGRAM_DELTABLAST = 15;
    public static final int OUTPUT_SIMPLE = 7;
    public static final int OUTPUT_TEXT = 0;

    public BlastPlusWrapper() {
        super("blastn");
    }

    public BlastPlusWrapper(int task, int outputFmt) {
        super("");
        this.setTask(task);
        this.setOutFmt(outputFmt);
    }

    public void setOutFmt(int outputFmt) {
        switch (outputFmt) {
            case 7: {
                break;
            }
            case 0: {
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.setAlignedView(outputFmt);
    }

    public void setTask(int task) {
        boolean isWindows = System.getProperty("os.name").toLowerCase().startsWith("windows");
        String taskString = "";
        switch (task) {
            case 0: {
                this.programString = "blastn";
                taskString = "blastn";
                break;
            }
            case 1: {
                this.programString = "blastn";
                taskString = "blastn-short";
                break;
            }
            case 2: {
                this.programString = "blastn";
                taskString = "megablast";
                break;
            }
            case 3: {
                this.programString = "blastn";
                taskString = "dc-megablast";
                break;
            }
            case 4: {
                this.programString = "blastn";
                taskString = "rmblastn";
                break;
            }
            case 5: {
                this.programString = "blastp";
                taskString = "blastp";
                break;
            }
            case 6: {
                this.programString = "blastp";
                taskString = "blastp-short";
                break;
            }
            case 7: {
                this.programString = "blastp";
                taskString = "blastp-fast";
                break;
            }
            case 8: {
                this.programString = "tblastn";
                taskString = "tblastn";
                break;
            }
            case 9: {
                this.programString = "tblastn";
                taskString = "tblastn-fast";
                break;
            }
            case 10: {
                this.programString = "tblastx";
                taskString = "";
                break;
            }
            case 11: {
                this.programString = "blastx";
                taskString = "blastx";
                break;
            }
            case 12: {
                this.programString = "blastx";
                taskString = "blastx-fast";
                break;
            }
            case 13: {
                this.programString = "psiblast";
                taskString = "";
                break;
            }
            case 14: {
                this.programString = "rpsblast";
                taskString = "";
                break;
            }
            case 15: {
                this.programString = "deltablast";
                taskString = "";
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        if (isWindows) {
            this.programString = this.programString + ".exe";
        }
        if (taskString != null && !taskString.equals("")) {
            this.addArgument("-task", taskString);
        }
        if (this.exec.equals("") || this.exec == null) {
            this.exec = this.programString;
        } else {
            if (this.exec.endsWith(this.programString)) {
                return;
            }
            this.exec = this.exec + File.separator + this.programString;
        }
    }

    public void setProgramPath(String path) {
        this.exec = path;
        if (this.programString != null) {
            this.exec = path + File.separator + this.programString;
        }
    }

    public void setInFileName(String inFileName) {
        this.addArgument("-query", inFileName);
    }

    public void setDbFileName(String dbFileName) {
        this.addArgument("-db", dbFileName);
    }

    public void setOutFileName(String outFileName) {
        this.addArgument("-out", outFileName);
    }

    public void setFilterEvalue(double filterEvalue) {
        this.addArgument("-evalue", filterEvalue);
    }

    private void setAlignedView(int alignedView) {
        this.addArgument("-outfmt", alignedView);
    }

    public void setMaxTargetSequence(int maxTarget) {
        this.addArgument("-max_target_seqs", maxTarget);
    }

    public void setNumDescriptions(int numHits) {
        this.addArgument("-num_descriptions", numHits);
    }

    public void setNumAlignments(int numAlign) {
        this.addArgument("-num_alignments", numAlign);
    }

    public void setDbSize(int dbSize) {
        this.addArgument("-dbsize", dbSize);
    }

    public void setDbSize(long dbSize) {
        this.addArgument("-dbsize", dbSize);
    }

    public void setFilterQuerySeq(String filterQuerySeq) {
        if (this.programString.equals("blastp") || this.programString.equals("blastx") || this.programString.equals("tblastn") || this.programString.equals("tblastx")) {
            this.addArgument("-seg", filterQuerySeq);
        } else {
            this.addArgument("-dust", filterQuerySeq);
        }
    }

    public void setCoreForMultiThread(int noCore) {
        this.addArgument("-num_threads", noCore);
    }

    public void setAniOption() {
        this.setFilterEvalue(1.0E-15);
        this.setFilterQuerySeq("no");
        this.addArgument("-xdrop_gap", 150);
        this.addArgument("-penalty", -1);
        this.addArgument("-reward", 1);
    }

    public void setOrthoAniOption() {
        this.addArgument("-task", "blastn");
        this.setFilterQuerySeq("no");
        this.setCoreForMultiThread(4);
        this.setMaxTargetSequence(1);
        this.setFilterEvalue(1.0E-15);
        this.addArgument("-xdrop_gap", 150);
        this.addArgument("-penalty", -1);
        this.addArgument("-reward", 1);
        this.addArgument("-outfmt", "6 qseqid sseqid pident length nident mismatch qstart qend sstart send");
    }

    @Override
    public String getVersion() {
        return "2.2.30";
    }

    @Override
    public boolean execute() {
        return super.execute();
    }

    @Override
    public BufferedReader executeToBufferedReader() {
        return super.executeToBufferedReader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int close() {
        int exitValue = -1;
        if (this.process != null) {
            try {
                this.process.getErrorStream().close();
                this.process.getInputStream().close();
                this.process.getOutputStream().close();
                exitValue = this.process.waitFor();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            finally {
                if (exitValue == 0) {
                    log.info("Blast Plus End Normally. exitValue is " + exitValue);
                } else {
                    log.error("Blast Plus End Abnormally. exitValue is " + exitValue);
                }
                this.process.destroy();
            }
        }
        return exitValue;
    }
}

